/*
 * Created on Apr 19, 2008
 *
 * (c) 2006-2007 dka - edv, media, webdesign
 *
 */
package com.dkaedv.asteroids.ki;

import java.io.IOException;

import com.dkaedv.asteroids.data.Asteroid;
import com.dkaedv.asteroids.data.GameInfo;
import com.dkaedv.asteroids.data.IPositionable;
import com.dkaedv.asteroids.data.Ship;
import com.dkaedv.asteroids.data.Shot;
import com.dkaedv.asteroids.data.Ufo;
import com.dkaedv.asteroids.data.Vector;
import com.dkaedv.asteroids.net.DatagramSender;
import com.dkaedv.asteroids.util.VectorCalculations;

public class SimpleTargetController extends DummyController {
    private ShotTargetList shotTargetList;
    private MultiWeightingStrategy targetStrategy;
    private DatagramSender datagramSender;
    private CollisionProtector collisionProtector;

    private IPositionable target = null;
    private IPositionable oldtarget = null;
    private long recalculationTimestamp = 0;
    private boolean retarget = true;
    private final static long PREDICTION_TIME = 20; // Additional time to add to prediction
    private final static long THRUST_THRESHOLD = 300;

    private final static long THRUST_MAX_SPEED = 150;

    private final static long THRUST_STRATEGIC_MAX_SPEED = 100;
    private final static double STRATEGIC_MIN_DISTANCE = 200;

    private final static boolean ENABLE_THRUST = false;
    private final static boolean ENABLE_THRUST_TO_CENTER = false;

    private double rotationSpeed = 0.0045;
    private boolean haveRotationSpeed = true;
    private double startAngle = 0;
    private long rotationStartTime = 0;

    private long runtime = 0;

    @Override
    public void run() {
        log.debug("Thread running");

        while(true) {
            long starttime = System.currentTimeMillis();

            try {
                collisionProtector.doProcessing();
            } catch (RuntimeException e1) {
                // TODO Auto-generated catch block
                e1.printStackTrace();
            }

            if (! keysDatagram.isWarp()) {
                try {
                    targetStrategy.doProcessing();
                } catch (RuntimeException e1) {
                    // TODO Auto-generated catch block
                    e1.printStackTrace();
                }

                try {
                    doProcessing();
                } catch (RuntimeException e1) {
                    // TODO Auto-generated catch block
                    e1.printStackTrace();
                }
            }

            try {
                datagramSender.sendPacket();
            } catch (RuntimeException e1) {
                // TODO Auto-generated catch block
                e1.printStackTrace();
            } catch (IOException e1) {
                // TODO Auto-generated catch block
                e1.printStackTrace();
            }

            // Whole processing time is quite small
            //log.debug("Processing time: " + (System.currentTimeMillis() - starttime));

            try {
                gameStatus.waitForUpdate();

                // Sleep another bit to let target rater finish
                //Thread.sleep(3);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void doProcessing() {
        long runStartTime = System.currentTimeMillis();

        if (gameStatus.getShip() != null) {

            if (!haveRotationSpeed) {
                Ship ship = gameStatus.getShip();

                log.debug(ship.getDirectionAngle());

                if (rotationStartTime == 0) {
                    // Start rotation calculation
                    keysDatagram.left(2000);
                    startAngle = ship.getDirectionAngle();
                    rotationStartTime = System.currentTimeMillis();
                } else if ( (System.currentTimeMillis() - rotationStartTime) > 500) {
                    if (ship.getDirectionAngle() > (startAngle - 0.1)
                            && ship.getDirectionAngle() < (startAngle + 0.1) ) {

                        // Rotation finished
                        double rotTime = System.currentTimeMillis() - rotationStartTime;

                        rotationSpeed = (2 * Math.PI) / rotTime;
                        haveRotationSpeed = true;

                        log.debug("Rotation Speed: " + rotationSpeed);
                    }

                }

            } else {
                // Select a new target
                synchronized (targetList) {
                    target = targetList.getFirstTarget();
                }

                if (target != null) {
                    //long firstPredictionTime = PREDICTION_TIME + connectionStatus.getLatency();
                    long firstPredictionTime = connectionStatus.getLatency(); // + keysDatagram.getTimeToNextSend();

                    /*
                    if (runtime > keysDatagram.getTimeToNextSend()) {
                        firstPredictionTime += DatagramSender.SENDING_INTERVAL;
                    }
                    */

                    //log.debug("firstPredictionTime: " + firstPredictionTime);
                    long predictionTime = firstPredictionTime;

                    Ship ship = gameStatus.getShip();
                    //Vector shipDirection = ship.getDirectionVector();
                    Vector vectorToTarget = VectorCalculations.getDifferenceNormalized(ship.getPosition().getPredictedVector(predictionTime), target.getPosition().getPredictedVector(predictionTime));
                    //double diffAngle = VectorCalculations.getAngleBetween(shipDirection, vectorToTarget);
                    double targetDistance = VectorCalculations.getNorm(vectorToTarget);


                    Vector predictedTargetPosition = null;
                    long iterationDiff = 1000;
                    long lastIterationPredictionTime = 10000;
                    int iterationCount = 0;

                    double shotSpeed = gameStatus.getAverageShotSpeed() / 1000; // we need it in ms
                    //double shotSpeed = 490.0 / 1000.0; // we need it in ms

                    // Iterate as long as the difference is bigger than 1 ms
                    while (Math.abs(iterationDiff) > 1) {
                        predictionTime = (long) (firstPredictionTime + (targetDistance / shotSpeed));

                        predictedTargetPosition = target.getPosition().getPredictedVector(predictionTime);
                        vectorToTarget = VectorCalculations.getDifferenceNormalized(ship.getPosition().getPredictedVector(predictionTime), predictedTargetPosition);
                        targetDistance = VectorCalculations.getNorm(vectorToTarget);

                        // Update iteration difference
                        iterationDiff = predictionTime - lastIterationPredictionTime;
                        lastIterationPredictionTime = predictionTime;

                        iterationCount++;

                        if (iterationCount > 30) {
                            //log.debug("Iteration limit reached");
                            break;
                        }
                    }


                    // Calculate ship direction after latency
                    Vector shipDirection = getPredictedShipDirection(firstPredictionTime);

                    double diffAngle = VectorCalculations.getAngleBetween(shipDirection, vectorToTarget);
                    //log.debug("Iterations: " + iterationCount);



                    this.gameStatus.setHitVector(predictedTargetPosition);

                    turnTo(shipDirection, vectorToTarget);
                    //log.debug("Calculated angle: " + curAngle + " shipDirection: " + shipDirection + " toTarget: " + vectorToTarget);



                    recalculationTimestamp = System.currentTimeMillis();
                    //}

                    // Fire if targeted
                    /*
                    if (willHit(ship, target, firstPredictionTime)) {
                        keysDatagram.fire(1);

                        if ( (gameStatus.getUfo() == null && gameStatus.getShots().size() < 4)
                                || (gameStatus.getUfo() != null && gameStatus.getShots().size() < 6)) {
                            // OK, shot will be really executed

                            shotTargetList.registerShot(target);
                            retarget = true;

                        }
                    }
                    */

                    /*
                    double angleTolerance = 0.03;

                    // if target is close use bigger tolerance
                    if (targetDistance < 150) {
                        angleTolerance = 0.08;
                    }

                    // if target is far use smaller tolerance
                    if (targetDistance > 300) {
                        angleTolerance = 0.015;
                    }

                    if (target instanceof Asteroid) {
                        int radius = ((Asteroid)target).getRadius();

                        angleTolerance = angleTolerance * (1 + ((radius - 8) / 10));
                    }
                    */

                    double radius = 0;

                    if (target instanceof Asteroid) {
                        radius = ((Asteroid)target).getRadius();
                    }

                    if (target instanceof Ufo) {
                        radius = ((Ufo)target).getRadius();
                    }

                    // Only use 80% of the radius
                    radius = 0.8 * radius;

                    double angleTolerance = Math.abs(Math.atan2(radius, targetDistance));
                    //log.debug("Angle Tolerance: " + angleTolerance);

                    // One keypress rotates about 0.074 so the smallest tolerance should be half of it (0.037)
                    if (angleTolerance < 0.037) {
                        //log.debug("Angle tolerance too small: " + angleTolerance);
                        angleTolerance = 0.037;
                    }

                    if (Math.abs(diffAngle) < angleTolerance) {
                        //log.debug("Fire");

                        if ( (gameStatus.getUfo() == null && gameStatus.getShots().size() < 4)
                                || (gameStatus.getUfo() != null && gameStatus.getShots().size() < 6)) {
                            // OK, shot will be really executed
                            keysDatagram.fire(1);

                            shotTargetList.registerShot(target);
                            retarget = true;
                        }
                    }



                    // Thrust if we are too far away and less than 5 targets are left

                    if (ENABLE_THRUST
                            && targetDistance > THRUST_THRESHOLD
                            && ship.getPosition().getSpeed() < THRUST_MAX_SPEED
                            && targetList.getTargets().size() < 5) {
                        keysDatagram.thrust(20);
                    }


                    // Keep thrusting if ufo is present
                    /*
                    if (gameStatus.getUfo() != null
                            && ship.getPosition().getSpeed() < THRUST_MIN_SPEED) {
                        keysDatagram.thrust(20);
                    } else if (ship.getPosition().getSpeed() < THRUST_IDLE_SPEED) {
                        keysDatagram.thrust(1);
                    }
                    */

                } else {
                    if (ENABLE_THRUST_TO_CENTER) {
                        // We still don't have a target, move to center
                        long predictionTime = PREDICTION_TIME + connectionStatus.getLatency();

                        Vector shipDirection = gameStatus.getShip().getDirectionVector();
                        Vector vectorToTarget = VectorCalculations.getDifferenceNormalized(gameStatus.getShip().getPosition().getPredictedVector(predictionTime), new Vector(524, 524));
                        double diffAngle = VectorCalculations.getAngleBetween(shipDirection, vectorToTarget);
                        double targetDistance = VectorCalculations.getNorm(vectorToTarget);

                        if (Math.abs(diffAngle) < 0.15) {
                            // on course
                            keysDatagram.stopTurning();

                            if ( gameStatus.getShip() != null
                                    && gameStatus.getShip().getPosition().getSpeed() < THRUST_STRATEGIC_MAX_SPEED
                                    && targetDistance > STRATEGIC_MIN_DISTANCE) {

                                keysDatagram.thrust(1);
                            }
                        } else {
                            turnTo(shipDirection, vectorToTarget);
                        }
                    } else {
                        // Turn to corner
                        //log.debug("Turning to corner");

                        long predictionTime = PREDICTION_TIME + connectionStatus.getLatency();

                        Vector shipDirection = gameStatus.getShip().getDirectionVector();
                        Vector vectorToTarget = VectorCalculations.getDifferenceNormalized(gameStatus.getShip().getPosition().getPredictedVector(predictionTime), new Vector(0, 0));
                        double diffAngle = VectorCalculations.getAngleBetween(shipDirection, vectorToTarget);

                        //log.debug("diffAngle: " + diffAngle);

                        if (Math.abs(diffAngle) < 0.1) {
                            // on course
                            keysDatagram.stopTurning();
                        } else {
                            //log.debug("Turning to corner");
                            turnTo(shipDirection, vectorToTarget);
                        }

                    }
                }
            }
        } else {
            // no ship present
            target = null;
        }

        runtime = System.currentTimeMillis() - runStartTime;
        //Runtime is always very low (< 2ms) so it can be safely ignored
        //log.debug("Runtime: " + runtime + "ms");
    }

    private boolean willHit(Ship ship, IPositionable target, long predictionTime) {
        if (ship == null || target == null) {
            return false;
        }

        try {
            Vector shipCurPos = ship.getPosition().getPredictedVector(predictionTime);
            Vector targetCurPos = target.getPosition().getPredictedVector(predictionTime);

            double shipAngle = ship.getDirectionAngle() + Math.PI; // between 0 and PI
            double targetAngle = target.getPosition().getAngle() + Math.PI; // between 0 and PI

            double s1 = Math.tan(shipAngle);
            double s2 = Math.tan(targetAngle);

            double a1 = shipCurPos.y - (s1 * shipCurPos.x);
            double a2 = targetCurPos.y - (s2 * targetCurPos.x);

            double crossX = (a2 - a1) / (s1 - s2);
            double crossY = ((s1 * a2) - (s2 * a1)) / (s1 - s2);

            Vector hitVector = new Vector((int)crossX, (int)crossY);

            /*
            log.debug("shipAngle: " + shipAngle + " targetAngle: " + targetAngle
                    + " s1: " + s1 + " s2: " + s2 + " a1: " + a1 + " a2: " + a2
                    + " crossX: " + crossX + " crossY: " + crossY);
            */
            gameStatus.setHitVector(hitVector);

            double distShip = VectorCalculations.getDistance(shipCurPos, hitVector);
            double distTarget = VectorCalculations.getDistance(targetCurPos, hitVector);

            double timeShot = distShip / (GameInfo.SHOT_SPEED * 1000);
            double timeTarget = distTarget / target.getPosition().getSpeed();

            double timeDiff = Math.abs(timeShot - timeTarget);

            //log.debug("Time Diff: " + timeDiff + " timeShot: " + timeShot + " timeTarget: " + timeTarget + " distShip: " + distShip + " distTarget: " + distTarget);

            if (timeDiff < 0.3) {
                return true;
            }
        } catch (RuntimeException e) {
            e.printStackTrace();
        }

        return false;
    }

    private void turnTo(Vector shipDirection, Vector vectorToTarget) {
        double angle = Math.abs(VectorCalculations.getAngleBetween(shipDirection, vectorToTarget));
        long movementMs = (long) (angle / rotationSpeed);

        if (shipDirection.x * vectorToTarget.y - shipDirection.y * vectorToTarget.x > 0) {

            //log.debug("Left");
            keysDatagram.left(movementMs);

            /*
            log.debug("Ship Pos: " + ship.getPosition().getPredictedVector(PREDICTION_TIME) + " Dir: " + shipDirection
                    + " Target Pos: " + target.getPosition().getPredictedVector(PREDICTION_TIME) + " Dir: " + vectorToTarget
                    + " Diff angle: " + diffAngle
                    + " Left for " + movementMs + "ms"
                    + " Distance to target: " + targetDistance);
                    */
        } else {
            //log.debug("Right");
            keysDatagram.right(movementMs);

            /*
            log.debug("Ship Pos: " + ship.getPosition().getPredictedVector(PREDICTION_TIME) + " Dir: " + shipDirection
                    + " Target Pos: " + target.getPosition().getPredictedVector(PREDICTION_TIME) + " Dir: " + vectorToTarget
                    + " Diff angle: " + diffAngle
                    + " Right for " + movementMs + "ms"
                    + " Distance to target: " + targetDistance);
                    */
        }

    }

    private Vector getPredictedShipDirection(long predTime) {
        double curAngle = gameStatus.getShip().getDirectionAngle();
        if (keysDatagram.isLeft()) {
            // positive direction
            curAngle += predTime * rotationSpeed;
        } else if (keysDatagram.isRight()) {
            // negative direction
            curAngle -= predTime * rotationSpeed;
        }

        return new Vector(
                (int) (Math.cos(curAngle) * 1000),
                (int) (Math.sin(curAngle) * 1000)
                );
    }


    /**
     * @param shotTargetList the shotTargetList to set
     */
    public void setShotTargetList(ShotTargetList shotTargetList) {
        this.shotTargetList = shotTargetList;
    }

    /**
     * @param targetStrategy the targetStrategy to set
     */
    public void setTargetStrategy(MultiWeightingStrategy targetStrategy) {
        this.targetStrategy = targetStrategy;
    }

    /**
     * @param datagramSender the datagramSender to set
     */
    public void setDatagramSender(DatagramSender datagramSender) {
        this.datagramSender = datagramSender;
    }

    /**
     * @param collisionProtector the collisionProtector to set
     */
    public void setCollisionProtector(CollisionProtector collisionProtector) {
        this.collisionProtector = collisionProtector;
    }

}
