/*
 * Created on Jun 17, 2008
 *
 * (c) 2006-2007 dka - edv, media, webdesign
 *
 */
package com.dkaedv.asteroids.ki;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ConcurrentModificationException;
import java.util.concurrent.ConcurrentLinkedQueue;

import com.dkaedv.asteroids.data.IDrawable;
import com.dkaedv.asteroids.data.IPositionable;

public class ShotTargetList implements IDrawable {
    private final static int CIRCLE_SIZE = 40;

    private int listSize = 2;

    private ConcurrentLinkedQueue<IPositionable> shotTargets = new ConcurrentLinkedQueue<IPositionable>();
    private ConcurrentLinkedQueue<Long> shotTargetTimes = new ConcurrentLinkedQueue<Long>();
    private TargetList targetList;

    public synchronized void registerShot(IPositionable target) {
        if (!shotTargets.contains(target)) {
            shotTargets.add(target);
            shotTargetTimes.add(System.currentTimeMillis());
        }

        while (shotTargets.size() > listSize) {
            removeOldestTarget();
        }
    }

    public synchronized boolean wasShotOn(IPositionable target) {
        int targetCount = targetList.getTargets().size();
        int newListSize = targetCount / 3;

        if (newListSize > 3) {
            newListSize = 3;
        }

        listSize = newListSize;

        while (shotTargets.size() > listSize) {
            removeOldestTarget();
        }

        // Remove old entry
        if (shotTargets.size() > 0
              && (System.currentTimeMillis() - shotTargetTimes.peek()) > 500) {
            removeOldestTarget();
        }

        return shotTargets.contains(target);
    }

    public void draw(Graphics2D g, Graphics2D textG) {
        try {
            g.setColor(Color.GREEN);

            for (IPositionable target : shotTargets) {
                g.drawOval(target.getPosition().getCurVector().x - (CIRCLE_SIZE / 2), target.getPosition().getCurVector().y - (CIRCLE_SIZE / 2), CIRCLE_SIZE, CIRCLE_SIZE);
            }
        } catch (ConcurrentModificationException e) {
            // ignore it
        }
    }

    private void removeOldestTarget() {
        shotTargets.poll();
        shotTargetTimes.poll();
    }

    /**
     * @param targetList the targetList to set
     */
    public void setTargetList(TargetList targetList) {
        this.targetList = targetList;
    }
}
