/*
 * Created on Apr 17, 2008
 *
 * (c) 2006-2007 dka - edv, media, webdesign
 *
 */
package com.dkaedv.asteroids.data;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;

import org.springframework.remoting.soap.SoapFaultException;

import com.dkaedv.asteroids.gui.SpaceComponent;

public class Ship implements IPositionable, IDrawable {
    private Position position;


    // Drawing Support
    // taken from Rammi (rammi@caff.de)
    /** Ship color. */
    private static final Color COLOR = new Color(0xc0, 0xc0, 0xc0); // not as white as bullets

    /** The ship shape for drawing. */
    private static final GeneralPath SHIP_SHAPE = new GeneralPath();
    static {
      // defined for 0 angle
      SHIP_SHAPE.moveTo(16, 0);
      SHIP_SHAPE.lineTo(-16, 8);
      SHIP_SHAPE.lineTo(-8, 0);
      SHIP_SHAPE.lineTo(-16, -8);
      SHIP_SHAPE.closePath();
    }

    /** The direction of the ship, x coordinate. */
    private int dx;
    /** The direction of the ship, y coordinate. */
    private int dy;


    public Ship(int curX, int curY, int dx, int dy) {
        position = new Position(curX, curY);
        this.dx = dx;
        this.dy = dy;
    }

    public Position getPosition() {
        return position;
    }

    /**
     *  Get the direction angle.
     *
     *  The angle is measured counterclockwise, with <code>0</code> pointing to the right
     *  @return ship direction in radians
     *
     *  taken from Rammi (rammi@caff.de)
     */
    public double getDirectionAngle()
    {
      return Math.atan2(dy, dx);
    }

    /**
     * Return a direction vector.
     *
     * @return
     */
    public Vector getDirectionVector() {


        return new Vector(dx, dy);
    }

    public void draw(Graphics2D g, Graphics2D textG) {
        g.setColor(COLOR);
        AffineTransform at = AffineTransform.getTranslateInstance(position.getCurVector().x, position.getCurVector().y);
        at.concatenate(AffineTransform.getRotateInstance(getDirectionAngle()));
        g.fill(at.createTransformedShape(SHIP_SHAPE));

        textG.setColor(Color.white);
        textG.drawString(String.format("%01.2f", getDirectionAngle()), SpaceComponent.calcX(position.getCurVector().x + 10), SpaceComponent.calcY(position.getCurVector().y + 10));
        textG.drawString(String.format("%03d", (int)getPosition().getSpeed()), SpaceComponent.calcX(position.getCurVector().x + 10), SpaceComponent.calcY(position.getCurVector().y - 10));

        getPosition().draw(g, textG);
    }

    /**
     * @return the dx
     */
    public int getDx() {
        return dx;
    }

    /**
     * @param dx the dx to set
     */
    public void setDx(int dx) {
        this.dx = dx;
    }

    /**
     * @return the dy
     */
    public int getDy() {
        return dy;
    }

    /**
     * @param dy the dy to set
     */
    public void setDy(int dy) {
        this.dy = dy;
    }

}
