/*
 * Decompiled with CFR 0.152.
 */
package com.dkaedv.asteroids.util;

import com.dkaedv.asteroids.data.IPositionable;
import com.dkaedv.asteroids.data.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VectorCalculations {
    private static final Log log = LogFactory.getLog(VectorCalculations.class);

    public static final double getDistance(Vector v1, Vector v2) {
        Vector diff = VectorCalculations.getDifferenceNormalized(v1, v2);
        return VectorCalculations.getNorm(diff);
    }

    public static final double getDistance(IPositionable v1, IPositionable v2) {
        return VectorCalculations.getDistance(v1.getPosition().getCurVector(), v2.getPosition().getCurVector());
    }

    public static final double getNorm(Vector v) {
        return Math.sqrt(v.x * v.x + v.y * v.y);
    }

    public static final double getScalarProduct(Vector v1, Vector v2) {
        return v1.x * v2.x + v1.y * v2.y;
    }

    public static final double getAngleBetween(Vector v1, Vector v2) {
        double scalarProd = VectorCalculations.getScalarProduct(v1, v2);
        double normSource = VectorCalculations.getNorm(v1);
        double normTarget = VectorCalculations.getNorm(v2);
        double angle = Math.acos(scalarProd / (normSource * normTarget));
        return angle;
    }

    public static final double getAngle(IPositionable source, IPositionable target) {
        return VectorCalculations.getAngle(source.getPosition().getCurVector(), target.getPosition().getCurVector());
    }

    public static final double getAngle(Vector source, Vector target) {
        Vector diff = VectorCalculations.getDifference(source, target);
        return Math.atan2(diff.y, diff.x);
    }

    public static final Vector getDifference(Vector from, Vector to) {
        return new Vector(to.x - from.x, to.y - from.y);
    }

    public static final Vector getDifferenceNormalized(Vector from, Vector to) {
        int dx;
        int dy = to.y - from.y;
        for (dx = to.x - from.x; dx < -512; dx += 1024) {
        }
        while (dx > 511) {
            dx -= 1024;
        }
        while (dy < -384) {
            dy += 768;
        }
        while (dy > 383) {
            dy -= 768;
        }
        return new Vector(dx, dy);
    }
}

