//
//  APTarget.h
//  APlayer
//
//  Created by Holger Sadewasser on 5/10/08.
//  Copyright 2008. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "APObject.h"


@interface APTarget : NSObject {

// -------------------------------------------------------------------------------------
#pragma mark -
#pragma mark Attributes
// -------------------------------------------------------------------------------------

  @public
  
  double mHeadingX;
  double mHeadingY;
  uint8_t mAngleByte;
  int mRotDirection;
  unsigned mFrameOfShot;
  unsigned mWaitingTime;
  APObject * mObject;
  double mDurationOfShot;
  double mTotalDuration;
}

// -------------------------------------------------------------------------------------
#pragma mark -
#pragma mark Initializers/Clean up
// -------------------------------------------------------------------------------------

-(id)initWithAngleByte:(uint8_t)iAngleByte direction:(int)iRotDirection frameOfShot:(unsigned)iFrame waiting:(unsigned)iWaitingTime
                object:(APObject *)iObject timeToShot:(int)iTimeToShot durationOfShot:(double)iDurationOfShot;
-(void)dealloc;

// -------------------------------------------------------------------------------------
#pragma mark -
#pragma mark Instance Methods
// -------------------------------------------------------------------------------------

-(NSComparisonResult)compareTotalDurationToTarget:(APTarget *)iTarget;
-(NSComparisonResult)compareDurationToTarget:(APTarget *)iTarget;
-(NSComparisonResult)compareFramesToTarget:(APTarget *)iTarget;
-(APObject *)object;
-(double)durationOfShot;
-(double)totalDuration;
-(uint8_t)angleByte;
-(int)rotationDirection;
-(unsigned)frameOfShot;
-(unsigned)waitingTime;
-(double)headingX;
-(double)headingY;


@end
