//
//  APKeysequence.m
//  APlayer
//
//  Created by Holger Sadewasser on 6/21/08.
//  Copyright 2008. All rights reserved.
//

#import "APKeySequence.h"


@implementation APKeySequence

// -------------------------------------------------------------------------------------
#pragma mark -
#pragma mark Initializers/Clean up
// -------------------------------------------------------------------------------------

-(id)init {
  return [self initWithCapacity:100];
}

-(id)initWithCapacity:(unsigned)iNumItems {
  self = [super init];
  if (self != nil) {
    mKeySequence = [[NSMutableArray alloc] initWithCapacity:iNumItems];
    mLength = 0;
    mRotDirection = 0;
    mRotCount = 0;
  }
  return self;  
}

-(void) dealloc {
  [mKeySequence release];
  [super dealloc];
}



// -------------------------------------------------------------------------------------
#pragma mark -
#pragma mark Instance Methods
// -------------------------------------------------------------------------------------

-(void)addKeystroke:(APKeystroke *)iKeystroke {
  [mKeySequence addObject:iKeystroke];
  mLength += [iKeystroke repeatCount];
  if ( [iKeystroke keys] & cKeyLeft || [iKeystroke keys] & cKeyRight ) {
    mRotDirection = [[iKeystroke target] rotationDirection];
    mRotCount += [iKeystroke repeatCount];
  }
}

-(void)addKeys:(uint8_t)iKeys repeat:(unsigned)iRepeatCount target:(APTarget *)iTarget {
  [self addKeystroke:[APKeystroke keystrokeWithKeys:iKeys repeat:iRepeatCount target:iTarget]];
}

-(void)addKeys:(uint8_t)iKeys repeat:(unsigned)iRepeatCount {
  [self addKeystroke:[APKeystroke keystrokeWithKeys:iKeys repeat:iRepeatCount]];  
}

-(void)clear {
  [mKeySequence removeAllObjects];
  mLength = 0;
  mRotDirection = 0;
  mRotCount = 0;
}

-(unsigned)count {
  return [mKeySequence count];
}

-(int)length {
  return mLength;
}

-(APKeystroke *)currentKeys {
  return [mKeySequence objectAtIndex:0];
}

-(void)removeCurrentKeys {
  [mKeySequence removeObjectAtIndex:0];
  if ( [self count] == 0 ) {
    mLength = 0;
    mRotDirection = 0;
    mRotCount = 0;
  }
}

-(void)sent {
  APKeystroke * keystroke = [mKeySequence objectAtIndex:0];
  [keystroke sent];
  --mLength;
  if ( [keystroke keys] & cKeyLeft || [keystroke keys] & cKeyRight ) {
    --mRotCount;
  }
  if ( [keystroke repeatCount] == 0 ) {
    [self removeCurrentKeys];
  }
}

-(void)addShotToTarget:(APTarget *)iTarget repeat:(unsigned)iRepeat {
  unsigned i;
  
  for ( i = 0; i < iRepeat; i++ ) {
    [self addKeystroke:[APKeystroke keystrokeWithKeys:cKeyFire repeat:1 target:iTarget]];
    [self addKeystroke:[APKeystroke keystrokeWithKeys:cKeyNone repeat:1 target:iTarget]];
  }
}

-(BOOL)insertShotToTarget:(APTarget *)iTarget {
 
  NSEnumerator * enumerator = [mKeySequence objectEnumerator];
  APKeystroke * keystroke;
  APKeystroke * newRot = nil;
  APKeystroke * newShot = nil;
  uint8_t keys;
  unsigned repeat;
  unsigned frames = [iTarget frameOfShot];
  unsigned index = 0;
  BOOL flgDone = NO;
  BOOL flgRemoveShot = NO;
  BOOL flgInserted = NO;
  
  if ( frames > 0 ) {
    if ( frames > mRotCount || [iTarget rotationDirection] != mRotDirection ) return flgInserted;
  }
  
  while( flgDone == NO && (keystroke = [enumerator nextObject]) ) {
    if ( frames > [keystroke repeatCount] )
      frames -= [keystroke repeatCount];
    else {
      if ( frames > 0 ) {
        keys = [keystroke keys];
        newRot = [APKeystroke keystrokeWithKeys:keys repeat:frames target:iTarget];
        keys |= cKeyFire;
        newShot = [APKeystroke keystrokeWithKeys:keys repeat:1 target:iTarget];
        repeat = [keystroke repeatCount] - frames - 1;
        if ( repeat == 0 ) {
          [mKeySequence removeObjectAtIndex:index];
          flgRemoveShot = YES;
        } else {
          [keystroke setRepeatCount:repeat];
        }
        [mKeySequence insertObject:newShot atIndex:index];
        if ( newRot != nil )
          [mKeySequence insertObject:newRot atIndex:index];
        
        flgInserted = YES;
//        NSLog(@"Shot inserted");
      }
      flgDone = YES;
    }
    ++index;
  }
  if ( flgRemoveShot == YES && (keystroke = [enumerator nextObject]) ) {
    keys = [keystroke keys] & ~cKeyFire;  
    [keystroke setKeys:keys];
  }
  
  return flgInserted;
}

-(void)addHyperspace {
  [self clear];
  [self addKeys:cKeyHyperspace repeat:1];
}


@end
