#import "APIntersectView.h"
#import "APObject.h"


// methods that are used internally by this class, but should not be needed externally
// are defined here to keep them "private". Anyone who knows about them can still call
// them of course, but by putting the prototypes here, it emphasizes that they are only
// meant for internal use.
@interface APIntersectView(_private_methods)

-(void)_createObjectPosX:(double)iPosX posY:(double)iPosY dirX:(double)iDirX dirY:(double)iDirY;

@end


@implementation APIntersectView

-(id)initWithFrame:(NSRect)iFrameRect {
	if ((self = [super initWithFrame:iFrameRect]) != nil) {
    mObjects = [[NSMutableArray alloc] initWithCapacity:40];
    mShip = [[APShip alloc] init];
    [mShip setPosX:512 posY:84 viewX:1536 viewY:0];
	}
	return self;
}

-(void)drawRect:(NSRect)rect {

  int numObjects;
  int i;
  APObject * object;
  
  int angleCount;
  int objCount;
  uint8_t angleByte;
  int numAngles = 86;
  int direction = 1;
//  double x1, y1, x2, y2;
  double shotX, shotY;
  double dirX, dirY;
  double angle;
  double sina, cosa;
  double timeOfCollision;
  double accuracy;
  APAngleStruct_t * angles;
  BOOL flgHit;
  
  int angleCount2;
  double angle2;
  int numAngles2 = 43;
//  double radius = 81;
  double radius = 170;
  double x, y, dx, dy;
  
  NSDrawWindowBackground([self bounds]);
  NSFrameRect(NSMakeRect( (float)([mShip posX]-1.0), (float)([mShip posY]-1.0), (float)3.0, (float)3.0 ));
  
  angles = [mShip angles];

  angle2 = 0.0;
  for (angleCount2 = 0; angleCount2 < numAngles2; angleCount2++) {
    angle2 = (double)angleCount2 * 3.0 * M_PI / 128.0;
    x = [mShip posX] + radius * cos(angle2);
    y = [mShip posY] + radius * sin(angle2);
//    x = [mShip posX] + radius;
//    y = [mShip posY];
//    dx = (x - [mShip posX]) / (radius/4.0);
//    dy = (y - [mShip posY]) / (radius/4.0);
    dx = -(double)angles[angleCount2].intX / 12.0;
    dy = -(double)angles[angleCount2].intY / 12.0;
//    dx = 8.0 * sin(angle2);
//    dy = 8.0 * cos(angle2);
//    dx = ([mShip posX] - x) / (radius/4.0);
//    dy = ([mShip posY] - y) / (radius/4.0);
    [self _createObjectPosX:x posY:y dirX:dx dirY:dy];
    angle2 += 2.0 * M_PI/numAngles2;

    object = [mObjects objectAtIndex:0];
    [[NSColor greenColor] set];
    NSFrameRect(NSMakeRect( (float)(x-1.0), (float)(y-1.0), (float)3.0, (float)3.0 ));
    [[NSColor redColor] set];
    NSFrameRect(NSMakeRect( (float)([object posX]-1.0), (float)([object posY]-1.0), (float)3.0, (float)3.0 ));
    [[NSColor blackColor] set];
    
    numObjects = [mObjects count];
    flgHit = NO;
    angleByte = 0;
    for (angleCount = 0; angleCount < numAngles; angleCount++) {
      angle = (double)angleByte * 3.0 * M_PI / 128.0;
      sina = round(127.0*sin(angle));
      cosa = round(127.0*cos(angle));
      shotX = [mShip posX] + (floor(cosa/2.0) + floor(cosa/4.0))/8.0;
      shotY = [mShip posY] + (floor(sina/2.0) + floor(sina/4.0))/8.0;
      
      dirX = (double)(angles[angleByte].intX)/8.0;
      dirY = (double)(angles[angleByte].intY)/8.0;
      
      for (objCount = 0; objCount < numObjects; objCount++) {
        object = [mObjects objectAtIndex:objCount];
        //      radius = [object radius];
        timeOfCollision = [object timeOfCollisionWithPosX:shotX posY:shotY dirX:dirX dirY:dirY radius:0.0 delay:0 accuracy:&accuracy];
        if ( timeOfCollision >= 0.0 ) {
          flgHit = YES;
        }
      }
      angleByte += (uint8_t)direction;
      
      if ( angleCount2 == 0 ) {
        [[NSColor lightGrayColor] set];
        [NSBezierPath strokeLineFromPoint:NSMakePoint((float)shotX,(float)shotY) toPoint:NSMakePoint((float)(shotX+100.0*dirX),(float)(shotY+100.0*dirY))];
        [[NSColor blackColor] set];
      }
    }
    if ( flgHit == NO ) {
      for ( i = 0; i < numObjects; i++ ) {
        NSLog(@"angle %d", angleCount2);
        object = [mObjects objectAtIndex:i];
        [object draw];
      }
    }
  }
  
}

-(void)drawRect1:(NSRect)rect {
  
  int numObjects = [mObjects count];
  int i;
  APObject * object;
  
  NSDrawWindowBackground([self bounds]);
  for ( i = 0; i < numObjects; i++ ) {
    object = [mObjects objectAtIndex:i];
    [object draw];
  }

  int angleCount;
  int objCount;
  uint8_t angleByte = 0;
  int numAngles = 86;
  int direction = 1;
  double x, y, radius;
  double x1, y1, x2, y2;
  double shotX, shotY;
  double dirX, dirY;
  double angle;
  double sina, cosa;
  double timeOfCollision;
  double accuracy;
  APAngleStruct_t * angles;
  NSBezierPath * circle;
  float alpha;
  
  angles = [mShip angles];

  NSFrameRect(NSMakeRect( (float)([mShip posX]-1.0), (float)([mShip posY]-1.0), (float)3.0, (float)3.0 ));

  alpha = 1.0;
  for (angleCount = 0; angleCount < numAngles; angleCount++) {
    angle = (double)angleByte * 3.0 * M_PI / 128.0;
    sina = round(127.0*sin(angle));
    cosa = round(127.0*cos(angle));
    //    shotX = ship->mPosX - 0.5 + 19.5 * cos(angle);
    //    shotY = ship->mPosY - 0.5 + 19.5 * sin(angle);
    //    shotX = (ship->mPosX * 8.0 + 95 * cos(angle))/8.0;
    //    shotY = (ship->mPosY * 8.0 + 95 * sin(angle))/8.0;
    shotX = [mShip posX] + (floor(cosa/2.0) + floor(cosa/4.0))/8.0;
    shotY = [mShip posY] + (floor(sina/2.0) + floor(sina/4.0))/8.0;

    dirX = (double)(angles[angleByte].intX)/8.0;
    dirY = (double)(angles[angleByte].intY)/8.0;
    
    for (objCount = 0; objCount < numObjects; objCount++) {
      object = [mObjects objectAtIndex:objCount];
      radius = [object radius];
      timeOfCollision = [object timeOfCollisionWithPosX:shotX posY:shotY dirX:dirX dirY:dirY radius:0.0 delay:angleCount accuracy:&accuracy];
      if ( timeOfCollision < 0.0 )
        [[NSColor lightGrayColor] set];
      else {
        x = shotX + timeOfCollision*dirX - 1.0;
        y = shotY + timeOfCollision*dirY - 1.0;
        [[NSColor blueColor] set];
        NSFrameRect(NSMakeRect( (float)x, (float)y, (float)3.0, (float)3.0 ));

        [[NSColor greenColor] set];
        x = [object posX] + object->mQ*[object headingX];
        y = [object posY] + object->mQ*[object headingY];
        NSFrameRect(NSMakeRect( (float)(x-1.0), (float)(y-1.0), (float)3.0, (float)3.0 ));

        [[NSColor magentaColor] set];
        x1 = x + sqrt(object->mC)*[object headingX];
        y1 = y + sqrt(object->mC)*[object headingY];
        x2 = x - sqrt(object->mC)*[object headingX];
        y2 = y - sqrt(object->mC)*[object headingY];
        [NSBezierPath strokeLineFromPoint:NSMakePoint((float)x1,(float)y1) toPoint:NSMakePoint((float)x2,(float)y2)];
        [[NSColor colorWithCalibratedRed:0.0 green:1.0 blue:0.0 alpha:0.5] set];
        circle = [NSBezierPath bezierPathWithOvalInRect:NSMakeRect(x1-radius,y1-radius,2.0*radius,2.0*radius)];
        [circle stroke];
        circle = [NSBezierPath bezierPathWithOvalInRect:NSMakeRect(x2-radius,y2-radius,2.0*radius,2.0*radius)];
        [circle stroke];

        [[[NSColor redColor] colorWithAlphaComponent:alpha] set];
        NSLog(@"p: %f  a: %f", timeOfCollision, accuracy);
        x = [object posX] + (timeOfCollision + (double)angleCount)*[object headingX] - radius;
        y = [object posY] + (timeOfCollision + (double)angleCount)*[object headingY] - radius;
        NSFrameRect(NSMakeRect( (float)x, (float)y, (float)(radius*2.0), (float)(radius*2.0) ));
        
//        alpha -= 0.3;
      }

      [NSBezierPath strokeLineFromPoint:NSMakePoint((float)shotX,(float)shotY) toPoint:NSMakePoint((float)(shotX+100.0*dirX),(float)(shotY+100.0*dirY))];
    }
    angleByte += (uint8_t)direction;
  }
}

-(void)setObjects:(NSMutableArray *)iObjects ship:(APShip *)iShip {
  [iObjects retain];
  [mObjects release];
  mObjects = iObjects;
  [iShip retain];
  [mShip release];
  mShip = iShip;
}

-(void)dealloc {
  [mObjects release];
  [mShip release];  
  [super dealloc];
}

-(void)_createObjectPosX:(double)iPosX posY:(double)iPosY dirX:(double)iDirX dirY:(double)iDirY {
  APObject * object;
  double x = iPosX;
  double y = iPosY;
  int i;

  object = [[[APObject alloc] initWithType:cAsteroid1 size:0 posX:(int)(x+0.5) posY:(int)(y+0.5)] autorelease];
  for ( i = 0; i < 8; i++ ) {
    x += iDirX;
    y += iDirY;
    [object updateWithPosX:(int)(x+0.5) posY:(int)(y+0.5) frames:1];
  }
  [mObjects removeAllObjects];
  [mObjects addObject:object];
  
}

@end
