
#include "StdAfx.h"

#include <math.h>

#include "Vector2D.h"


Vector2D Vector2D::subtract(const Vector2D& vec1, const Vector2D& vec2)
{
	return Vector2D (vec1.getX() - vec2.getX(), vec1.getY() - vec2.getY());
}

Vector2D Vector2D::normalize(const Vector2D& src)
{
	Vector2D ret = src;
	ret.normalize();

	return ret;
}

/////////////////////////////////////////////////////////////////////
Vector2D::Vector2D(void)
: mX(0), mY(0)
{
}

Vector2D::Vector2D(double x, double y)
: mX(x), mY(y)
{
}

Vector2D::Vector2D(const Vector2D& rhs)
{
	mX = rhs.mX;
	mY = rhs.mY;
}

Vector2D::~Vector2D(void)
{
}

Vector2D& Vector2D::operator=(const Vector2D& rhs)
{
    if (&rhs == this) { return *this; }

	mX = rhs.mX;
	mY = rhs.mY;

    return *this; 
}

Vector2D& Vector2D::operator+=(const Vector2D& rhs)
{
	mX += rhs.mX;
	mY += rhs.mY;

	return *this;
}

Vector2D Vector2D::operator*(const double& rhs) const
{
	return Vector2D(mX * rhs, mY * rhs);
}

Vector2D Vector2D::operator/(const double& rhs) const
{
	return Vector2D(mX / rhs, mY / rhs);
}

Vector2D& Vector2D::operator*=(const double& rhs)
{
	mX *= rhs;
	mY *= rhs;

	return *this;
}

Vector2D Vector2D::operator-(const Vector2D& rhs) const
{
	return Vector2D(mX - rhs.mX, mY - rhs.mY);
}

Vector2D Vector2D::operator+(const Vector2D& rhs) const
{
	return Vector2D(mX + rhs.mX, mY + rhs.mY);
}

double Vector2D::getX() const
{
	return mX;
}

void Vector2D::setX(double x)
{
	mX = x;
}

double Vector2D::getY() const
{
	return mY;
}

void Vector2D::setY(double y)
{
	mY = y;
}

double Vector2D::getLength(void) const
{
	return (sqrt(mX * mX + mY * mY));
}

double Vector2D::getLengthSq(void) const
{
	return (mX * mX + mY * mY);
}

void Vector2D::normalize(void)
{
	// Test, ob der Vektor normalisiert werden kann
	if ((mX == 0) && (mY == 0)) { return; }
		
	double length = getLength();

	mX /= length;
	mY /= length;
}

double Vector2D::dotProduct(const Vector2D& rhs) const
{
	double lengthMe = getLength();
	double lengthRhs = rhs.getLength();

	if ((lengthMe == 0) || (lengthRhs == 0))
	{	// Winkel kann nicht bestimmt werden
		return 0.0;
	}

	// Liefert den Cosinus des Winkels zwischen den zwei Vektoren
	return (mX * rhs.mX + mY * rhs.mY) / (lengthMe * lengthRhs);
}

bool Vector2D::approximatelyEqual(const Vector2D& rhs) const
{
	double lengthMe = getLength();
	double lengthRhs = rhs.getLength();

	if ((lengthMe == 0) || (lengthRhs == 0) || (abs(lengthMe - lengthRhs) > 1.0))
	{	
		return false;
	}

	// Liefert den Cosinus des Winkels zwischen den zwei Vektoren
	return ((mX * rhs.mX + mY * rhs.mY) / (lengthMe * lengthRhs) > 0.99939);
}

