
#pragma once

#include "Vector2D.h"


class MovingEntity;


class Steering
{
public:
	Steering(MovingEntity* agent);
	virtual ~Steering(void);

	// Schaltet die verschiedenen Lenkungsverhalten ein oder aus
	void setObstacleAvoidanceOn(bool avoidanceOn);
	bool getObstacleAvoidanceOn(void) const;

	void setEmergencyJumpOn(bool emOn);
	bool getEmergencyJumpOn(void) const;

	void setSeekOn(bool seekOn);
	bool getSeekOn(void) const;

	// Gibt zurck, ob ein Hypersprung durchgefhrt werden soll
	bool emergencyJump(void);

	// Berechnet die Lenkungskraft, die auf den Agenten ausgebt werden soll. Es werden alle
	// eingeschalteten Methoden addiert
	Vector2D calculate(void); 

private:
	// Die verschiedenen Methoden um die Lenkungskraft zu berechnen
	Vector2D obstacleAvoidance(void);
	Vector2D seek(void);

	bool mObstacleAvoidanceIsOn;
	bool mEmergencyJumpIsOn;
	bool mSeekIsOn;

	int mEmergencyJumpLock;

	MovingEntity* mAgent;	// Dieser wird von der Lenkung beeinflut
};
