
#include "StdAfx.h"
#include <math.h>

#include "GlobalSettings.h"
#include "MovingEntity.h"

#include "Vector2D.h"
#include "Matrix2D.h"
#include "Calculator.h"
#include "PositionCalculator.h"

double PositionCalculator::RotationArray[256] = { 0 };


void PositionCalculator::tansferEntityToLocalSpace(const Vector2D translation, const double& rotation, MovingEntity* entity)
{
	// Mit dieser Methode wird ein Objekt in den lokalen Raum des Source-Objekts transferiert.
	// Dadurch werden diverse Berechnungen wesentlich vereinfacht.
	// Als Ausrichtung dient der bergebene Winkel rotation
	// Die Positionsangabn von entity liegen vor der Methode in globalen Koordinaten vor. Nacher
	// in lokalen
	Vector2D newPosition;

	Matrix2D t, r; // Die bentigten Matrizen. Translation und Rotation
	t.setTranslation(translation * (-1));
	r.setRotation(2 * Calculator::PI - rotation);

	newPosition = t.transform(entity->getPosition());
	newPosition = wrapAroundLocalCoordinates(newPosition); // Die Welt wird wie ein Toroid behandelt	
	entity->setPosition(r.transform(newPosition));

	// Die Geschwindigkeit und die Ausrichtung auch drehen
	entity->setVelocity(r.transform(entity->getVelocity()));
	entity->setHeading(r.transform(entity->getHeading()));
}

void PositionCalculator::tansferEntityToLocalSpaceInv(const Vector2D translation, const double& rotation, MovingEntity* entity)
{
	// Mit dieser Methode wird ein Objekt vom lokalen Raum des Source-Objekts in den World
	// Space transferiert.
	Vector2D newPosition;

	Matrix2D t, r; // Die bentigten Matrizen. Translation und Rotation
	t.setTranslation(translation);
	r.setRotation(rotation);

	// Die Geschwindigkeit und die Ausrichtung auch drehen
	entity->setVelocity(r.transform(entity->getVelocity()));
	entity->setHeading(r.transform(entity->getHeading()));

	newPosition = r.transform(entity->getPosition());
	newPosition = wrapAroundLocalCoordinates(newPosition); // Die Welt wird wie ein Toroid behandelt	
	newPosition = t.transform(newPosition);

	entity->setPosition(newPosition); // Die Welt wird wie ein Toroid behandelt	
}


Vector2D PositionCalculator::tansferPositionToLocalSpace(const Vector2D translation, const double& rotation, const Vector2D& position)
{
	Vector2D newPosition;

	Matrix2D t, r; // Die bentigten Matrizen. Translation und Rotation
	t.setTranslation(translation * (-1));
	r.setRotation(2 * Calculator::PI - rotation);

	newPosition = t.transform(position);
	newPosition = wrapAroundLocalCoordinates(newPosition); // Die Welt wird wie ein Toroid behandelt	
	return r.transform(newPosition);
}

Vector2D PositionCalculator::tansferPositionToLocalSpaceInv(const Vector2D translation, const double& rotation, const Vector2D& position)
{
	Vector2D newPosition;

	Matrix2D t, r; // Die bentigten Matrizen. Translation und Rotation
	t.setTranslation(translation);
	r.setRotation(rotation);

	newPosition = r.transform(position);
	newPosition = wrapAroundLocalCoordinates(newPosition); // Die Welt wird wie ein Toroid behandelt	
	return t.transform(newPosition);
}


Vector2D PositionCalculator::wrapAroundLocalCoordinates(const Vector2D& position) 
{
	double worldWidthHalf = static_cast<double>(GlobalSettings::Instance()->worldWidth) / 2;
	double worldHeightHalf = static_cast<double>(GlobalSettings::Instance()->worldHeight) / 2;

	Vector2D v = wrapAroundWorldCoordinates(Vector2D(position.getX() + worldWidthHalf, position.getY() + worldHeightHalf));

	return Vector2D(v.getX() - worldWidthHalf, v.getY() - worldHeightHalf);
}

Vector2D PositionCalculator::wrapAroundWorldCoordinates(const Vector2D& position) 
{
	// Die Multiplikation mit 1000 wird gemacht, um auch die Nachkommastellen zu behalten
	int x = static_cast<int>(position.getX() * 1000);
	int y = static_cast<int>(position.getY() * 1000);

	int worldWidth = GlobalSettings::Instance()->worldWidth * 1000;
	int worldHeight = GlobalSettings::Instance()->worldHeight * 1000;

	if (x >= worldWidth)
	{
		x %= worldWidth;
	}
	else if (x < 0)
	{
		x = worldWidth - (abs(x) % worldWidth);
	}

	if (y >= worldHeight)
	{
		y %= worldHeight;
	}
	else if (y < 0)
	{
		y = worldHeight - (abs(y) % worldHeight);
	}

	return Vector2D(static_cast<double>(x) / 1000, static_cast<double>(y) / 1000);

}


bool PositionCalculator::isPositionInWorldRange(const Vector2D &referencePos, const Vector2D &pos, double range)
{
	// Beim Test, ob ein Punkt innerhalb eines bestimmten Bereichs liegt, mssen wir zwei Flle 
	// unterscheiden. Der Referenzpunkt plus dem Bereich bersteigt die max Fenstergre. In diesen
	// Fall muss Bedingung a) erfllt sein. Ansonsten mu Bedingung B erfllt sein
	double worldWidth = static_cast<double>(GlobalSettings::Instance()->worldWidth);
	double worldHeight = static_cast<double>(GlobalSettings::Instance()->worldHeight);

	// Sicherstellen, da der Referenzpunkt im gltigen Bereich liegt
	Vector2D referenceWorld = wrapAroundWorldCoordinates(referencePos);

	// Test, ob der Punkt innerhalb des X-Bereichs liegt
	if (((referencePos.getX() + range) >= worldWidth) || ((referencePos.getX() - range) < 0))
	{	// Bedingung a
		double x1 = wrapAroundWorldCoordinates(Vector2D(referenceWorld.getX() + range, 0)).getX();
		double x2 = wrapAroundWorldCoordinates(Vector2D(referenceWorld.getX() - range, 0)).getX();
		if ((pos.getX() > x1) && (pos.getX() < x2))
		{
			return false;
		}
	}
	else
	{	// Bedingung B
		if (abs(pos.getX() - referenceWorld.getX()) > range)
		{
			return false;
		}
	}

	// Test, ob der Punkt innerhalb des Y-Bereichs liegt
	if (((referencePos.getY() + range) >= worldHeight) || ((referencePos.getY() - range) < 0))
	{	// Bedingung a
		double y1 = wrapAroundWorldCoordinates(Vector2D(0, referenceWorld.getY() + range)).getY();
		double y2 = wrapAroundWorldCoordinates(Vector2D(0, referenceWorld.getY() - range)).getY();
		if ((pos.getY() > y1) && (pos.getY() < y2))
		{
			return false;
		}
	}
	else
	{	// Bedingung B
		if (abs(pos.getY() - referenceWorld.getY()) > range)
		{
			return false;
		}
	}

	return true;
}


double PositionCalculator::getRotation(const unsigned char& position)
{
	return RotationArray[position];
}


void PositionCalculator::initializePositionArray(void)
{

	// Die berechneten Werte mit 4,21875
	RotationArray[0] = 0.00000f;
	RotationArray[1] = 0.07363f;
	RotationArray[2] = 0.14726f;
	RotationArray[3] = 0.22089f;
	RotationArray[4] = 0.29452f;
	RotationArray[5] = 0.36816f;
	RotationArray[6] = 0.44179f;
	RotationArray[7] = 0.51542f;
	RotationArray[8] = 0.58905f;
	RotationArray[9] = 0.66268f;
	RotationArray[10] = 0.73631f;
	RotationArray[11] = 0.80994f;
	RotationArray[12] = 0.88357f;
	RotationArray[13] = 0.95720f;
	RotationArray[14] = 1.03084f;
	RotationArray[15] = 1.10447f;
	RotationArray[16] = 1.17810f;
	RotationArray[17] = 1.25173f;
	RotationArray[18] = 1.32536f;
	RotationArray[19] = 1.39899f;
	RotationArray[20] = 1.47262f;
	RotationArray[21] = 1.54625f;
	RotationArray[22] = 1.61988f;
	RotationArray[23] = 1.69351f;
	RotationArray[24] = 1.76715f;
	RotationArray[25] = 1.84078f;
	RotationArray[26] = 1.91441f;
	RotationArray[27] = 1.98804f;
	RotationArray[28] = 2.06167f;
	RotationArray[29] = 2.13530f;
	RotationArray[30] = 2.20893f;
	RotationArray[31] = 2.28256f;
	RotationArray[32] = 2.35619f;
	RotationArray[33] = 2.42983f;
	RotationArray[34] = 2.50346f;
	RotationArray[35] = 2.57709f;
	RotationArray[36] = 2.65072f;
	RotationArray[37] = 2.72435f;
	RotationArray[38] = 2.79798f;
	RotationArray[39] = 2.87161f;
	RotationArray[40] = 2.94524f;
	RotationArray[41] = 3.01887f;
	RotationArray[42] = 3.09251f;
	RotationArray[43] = 3.16614f;
	RotationArray[44] = 3.23977f;
	RotationArray[45] = 3.31340f;
	RotationArray[46] = 3.38703f;
	RotationArray[47] = 3.46066f;
	RotationArray[48] = 3.53429f;
	RotationArray[49] = 3.60792f;
	RotationArray[50] = 3.68155f;
	RotationArray[51] = 3.75518f;
	RotationArray[52] = 3.82882f;
	RotationArray[53] = 3.90245f;
	RotationArray[54] = 3.97608f;
	RotationArray[55] = 4.04971f;
	RotationArray[56] = 4.12334f;
	RotationArray[57] = 4.19697f;
	RotationArray[58] = 4.27060f;
	RotationArray[59] = 4.34423f;
	RotationArray[60] = 4.41786f;
	RotationArray[61] = 4.49150f;
	RotationArray[62] = 4.56513f;
	RotationArray[63] = 4.63876f;
	RotationArray[64] = 4.71239f;
	RotationArray[65] = 4.78602f;
	RotationArray[66] = 4.85965f;
	RotationArray[67] = 4.93328f;
	RotationArray[68] = 5.00691f;
	RotationArray[69] = 5.08054f;
	RotationArray[70] = 5.15418f;
	RotationArray[71] = 5.22781f;
	RotationArray[72] = 5.30144f;
	RotationArray[73] = 5.37507f;
	RotationArray[74] = 5.44870f;
	RotationArray[75] = 5.52233f;
	RotationArray[76] = 5.59596f;
	RotationArray[77] = 5.66959f;
	RotationArray[78] = 5.74322f;
	RotationArray[79] = 5.81686f;
	RotationArray[80] = 5.89049f;
	RotationArray[81] = 5.96412f;
	RotationArray[82] = 6.03775f;
	RotationArray[83] = 6.11138f;
	RotationArray[84] = 6.18501f;
	RotationArray[85] = 6.25864f;
	RotationArray[86] = 0.04909f;
	RotationArray[87] = 0.12272f;
	RotationArray[88] = 0.19635f;
	RotationArray[89] = 0.26998f;
	RotationArray[90] = 0.34361f;
	RotationArray[91] = 0.41724f;
	RotationArray[92] = 0.49087f;
	RotationArray[93] = 0.56450f;
	RotationArray[94] = 0.63814f;
	RotationArray[95] = 0.71177f;
	RotationArray[96] = 0.78540f;
	RotationArray[97] = 0.85903f;
	RotationArray[98] = 0.93266f;
	RotationArray[99] = 1.00629f;
	RotationArray[100] = 1.07992f;
	RotationArray[101] = 1.15355f;
	RotationArray[102] = 1.22718f;
	RotationArray[103] = 1.30082f;
	RotationArray[104] = 1.37445f;
	RotationArray[105] = 1.44808f;
	RotationArray[106] = 1.52171f;
	RotationArray[107] = 1.59534f;
	RotationArray[108] = 1.66897f;
	RotationArray[109] = 1.74260f;
	RotationArray[110] = 1.81623f;
	RotationArray[111] = 1.88986f;
	RotationArray[112] = 1.96350f;
	RotationArray[113] = 2.03713f;
	RotationArray[114] = 2.11076f;
	RotationArray[115] = 2.18439f;
	RotationArray[116] = 2.25802f;
	RotationArray[117] = 2.33165f;
	RotationArray[118] = 2.40528f;
	RotationArray[119] = 2.47891f;
	RotationArray[120] = 2.55254f;
	RotationArray[121] = 2.62618f;
	RotationArray[122] = 2.69981f;
	RotationArray[123] = 2.77344f;
	RotationArray[124] = 2.84707f;
	RotationArray[125] = 2.92070f;
	RotationArray[126] = 2.99433f;
	RotationArray[127] = 3.06796f;
	RotationArray[128] = 3.14159f;
	RotationArray[129] = 3.21522f;
	RotationArray[130] = 3.28885f;
	RotationArray[131] = 3.36249f;
	RotationArray[132] = 3.43612f;
	RotationArray[133] = 3.50975f;
	RotationArray[134] = 3.58338f;
	RotationArray[135] = 3.65701f;
	RotationArray[136] = 3.73064f;
	RotationArray[137] = 3.80427f;
	RotationArray[138] = 3.87790f;
	RotationArray[139] = 3.95153f;
	RotationArray[140] = 4.02517f;
	RotationArray[141] = 4.09880f;
	RotationArray[142] = 4.17243f;
	RotationArray[143] = 4.24606f;
	RotationArray[144] = 4.31969f;
	RotationArray[145] = 4.39332f;
	RotationArray[146] = 4.46695f;
	RotationArray[147] = 4.54058f;
	RotationArray[148] = 4.61421f;
	RotationArray[149] = 4.68785f;
	RotationArray[150] = 4.76148f;
	RotationArray[151] = 4.83511f;
	RotationArray[152] = 4.90874f;
	RotationArray[153] = 4.98237f;
	RotationArray[154] = 5.05600f;
	RotationArray[155] = 5.12963f;
	RotationArray[156] = 5.20326f;
	RotationArray[157] = 5.27689f;
	RotationArray[158] = 5.35052f;
	RotationArray[159] = 5.42416f;
	RotationArray[160] = 5.49779f;
	RotationArray[161] = 5.57142f;
	RotationArray[162] = 5.64505f;
	RotationArray[163] = 5.71868f;
	RotationArray[164] = 5.79231f;
	RotationArray[165] = 5.86594f;
	RotationArray[166] = 5.93957f;
	RotationArray[167] = 6.01320f;
	RotationArray[168] = 6.08684f;
	RotationArray[169] = 6.16047f;
	RotationArray[170] = 6.23410f;
	RotationArray[171] = 0.02454f;
	RotationArray[172] = 0.09817f;
	RotationArray[173] = 0.17181f;
	RotationArray[174] = 0.24544f;
	RotationArray[175] = 0.31907f;
	RotationArray[176] = 0.39270f;
	RotationArray[177] = 0.46633f;
	RotationArray[178] = 0.53996f;
	RotationArray[179] = 0.61359f;
	RotationArray[180] = 0.68722f;
	RotationArray[181] = 0.76085f;
	RotationArray[182] = 0.83449f;
	RotationArray[183] = 0.90812f;
	RotationArray[184] = 0.98175f;
	RotationArray[185] = 1.05538f;
	RotationArray[186] = 1.12901f;
	RotationArray[187] = 1.20264f;
	RotationArray[188] = 1.27627f;
	RotationArray[189] = 1.34990f;
	RotationArray[190] = 1.42353f;
	RotationArray[191] = 1.49717f;
	RotationArray[192] = 1.57080f;
	RotationArray[193] = 1.64443f;
	RotationArray[194] = 1.71806f;
	RotationArray[195] = 1.79169f;
	RotationArray[196] = 1.86532f;
	RotationArray[197] = 1.93895f;
	RotationArray[198] = 2.01258f;
	RotationArray[199] = 2.08621f;
	RotationArray[200] = 2.15984f;
	RotationArray[201] = 2.23348f;
	RotationArray[202] = 2.30711f;
	RotationArray[203] = 2.38074f;
	RotationArray[204] = 2.45437f;
	RotationArray[205] = 2.52800f;
	RotationArray[206] = 2.60163f;
	RotationArray[207] = 2.67526f;
	RotationArray[208] = 2.74889f;
	RotationArray[209] = 2.82252f;
	RotationArray[210] = 2.89616f;
	RotationArray[211] = 2.96979f;
	RotationArray[212] = 3.04342f;
	RotationArray[213] = 3.11705f;
	RotationArray[214] = 3.19068f;
	RotationArray[215] = 3.26431f;
	RotationArray[216] = 3.33794f;
	RotationArray[217] = 3.41157f;
	RotationArray[218] = 3.48520f;
	RotationArray[219] = 3.55884f;
	RotationArray[220] = 3.63247f;
	RotationArray[221] = 3.70610f;
	RotationArray[222] = 3.77973f;
	RotationArray[223] = 3.85336f;
	RotationArray[224] = 3.92699f;
	RotationArray[225] = 4.00062f;
	RotationArray[226] = 4.07425f;
	RotationArray[227] = 4.14788f;
	RotationArray[228] = 4.22152f;
	RotationArray[229] = 4.29515f;
	RotationArray[230] = 4.36878f;
	RotationArray[231] = 4.44241f;
	RotationArray[232] = 4.51604f;
	RotationArray[233] = 4.58967f;
	RotationArray[234] = 4.66330f;
	RotationArray[235] = 4.73693f;
	RotationArray[236] = 4.81056f;
	RotationArray[237] = 4.88419f;
	RotationArray[238] = 4.95783f;
	RotationArray[239] = 5.03146f;
	RotationArray[240] = 5.10509f;
	RotationArray[241] = 5.17872f;
	RotationArray[242] = 5.25235f;
	RotationArray[243] = 5.32598f;
	RotationArray[244] = 5.39961f;
	RotationArray[245] = 5.47324f;
	RotationArray[246] = 5.54687f;
	RotationArray[247] = 5.62051f;
	RotationArray[248] = 5.69414f;
	RotationArray[249] = 5.76777f;
	RotationArray[250] = 5.84140f;
	RotationArray[251] = 5.91503f;
	RotationArray[252] = 5.98866f;
	RotationArray[253] = 6.06229f;
	RotationArray[254] = 6.13592f;
	RotationArray[255] = 6.20955f;

/*
	// Die Werte aus der Tabelle in Radiant
	RotationArray[0] = 0.00000f;
	RotationArray[1] = 0.06283f;
	RotationArray[2] = 0.14312f;
	RotationArray[3] = 0.22166f;
	RotationArray[4] = 0.28798f;
	RotationArray[5] = 0.37001f;
	RotationArray[6] = 0.43982f;
	RotationArray[7] = 0.51487f;
	RotationArray[8] = 0.58469f;
	RotationArray[9] = 0.65973f;
	RotationArray[10] = 0.72780f;
	RotationArray[11] = 0.80634f;
	RotationArray[12] = 0.88663f;
	RotationArray[13] = 0.96517f;
	RotationArray[14] = 1.03673f;
	RotationArray[15] = 1.10654f;
	RotationArray[16] = 1.17810f;
	RotationArray[17] = 1.24966f;
	RotationArray[18] = 1.32820f;
	RotationArray[19] = 1.39452f;
	RotationArray[20] = 1.47480f;
	RotationArray[21] = 1.55509f;
	RotationArray[22] = 1.61967f;
	RotationArray[23] = 1.69646f;
	RotationArray[24] = 1.77675f;
	RotationArray[25] = 1.84132f;
	RotationArray[26] = 1.92335f;
	RotationArray[27] = 1.99142f;
	RotationArray[28] = 2.06123f;
	RotationArray[29] = 2.14326f;
	RotationArray[30] = 2.21133f;
	RotationArray[31] = 2.28813f;
	RotationArray[32] = 2.35619f;
	RotationArray[33] = 2.43299f;
	RotationArray[34] = 2.50106f;
	RotationArray[35] = 2.58134f;
	RotationArray[36] = 2.65116f;
	RotationArray[37] = 2.73319f;
	RotationArray[38] = 2.80474f;
	RotationArray[39] = 2.87107f;
	RotationArray[40] = 2.95310f;
	RotationArray[41] = 3.01593f;
	RotationArray[42] = 3.09447f;
	RotationArray[43] = 3.17475f;
	RotationArray[44] = 3.23759f;
	RotationArray[45] = 3.31438f;
	RotationArray[46] = 3.39467f;
	RotationArray[47] = 3.45924f;
	RotationArray[48] = 3.54302f;
	RotationArray[49] = 3.61109f;
	RotationArray[50] = 3.68264f;
	RotationArray[51] = 3.75944f;
	RotationArray[52] = 3.83972f;
	RotationArray[53] = 3.90605f;
	RotationArray[54] = 3.97062f;
	RotationArray[55] = 4.05265f;
	RotationArray[56] = 4.11723f;
	RotationArray[57] = 4.19403f;
	RotationArray[58] = 4.27780f;
	RotationArray[59] = 4.34238f;
	RotationArray[60] = 4.41045f;
	RotationArray[61] = 4.49073f;
	RotationArray[62] = 4.55705f;
	RotationArray[63] = 4.63559f;
	RotationArray[64] = 4.71239f;
	RotationArray[65] = 4.77522f;
	RotationArray[66] = 4.85551f;
	RotationArray[67] = 4.93405f;
	RotationArray[68] = 5.00037f;
	RotationArray[69] = 5.08240f;
	RotationArray[70] = 5.14872f;
	RotationArray[71] = 5.21853f;
	RotationArray[72] = 5.29707f;
	RotationArray[73] = 5.37212f;
	RotationArray[74] = 5.44019f;
	RotationArray[75] = 5.51873f;
	RotationArray[76] = 5.58505f;
	RotationArray[77] = 5.66359f;
	RotationArray[78] = 5.73515f;
	RotationArray[79] = 5.80671f;
	RotationArray[80] = 5.87478f;
	RotationArray[81] = 5.96204f;
	RotationArray[82] = 6.02662f;
	RotationArray[83] = 6.10691f;
	RotationArray[84] = 6.18719f;
	RotationArray[85] = 6.25002f;
	RotationArray[86] = 0.04887f;
	RotationArray[87] = 0.12566f;
	RotationArray[88] = 0.19199f;
	RotationArray[89] = 0.27053f;
	RotationArray[90] = 0.33685f;
	RotationArray[91] = 0.40841f;
	RotationArray[92] = 0.49044f;
	RotationArray[93] = 0.57247f;
	RotationArray[94] = 0.64054f;
	RotationArray[95] = 0.70860f;
	RotationArray[96] = 0.78540f;
	RotationArray[97] = 0.86219f;
	RotationArray[98] = 0.93026f;
	RotationArray[99] = 0.99833f;
	RotationArray[100] = 1.08036f;
	RotationArray[101] = 1.16239f;
	RotationArray[102] = 1.23395f;
	RotationArray[103] = 1.30027f;
	RotationArray[104] = 1.37881f;
	RotationArray[105] = 1.44513f;
	RotationArray[106] = 1.52193f;
	RotationArray[107] = 1.60396f;
	RotationArray[108] = 1.66679f;
	RotationArray[109] = 1.74707f;
	RotationArray[110] = 1.82736f;
	RotationArray[111] = 1.89194f;
	RotationArray[112] = 1.97920f;
	RotationArray[113] = 2.04727f;
	RotationArray[114] = 2.11883f;
	RotationArray[115] = 2.19213f;
	RotationArray[116] = 2.26893f;
	RotationArray[117] = 2.33525f;
	RotationArray[118] = 2.41379f;
	RotationArray[119] = 2.48186f;
	RotationArray[120] = 2.55691f;
	RotationArray[121] = 2.63545f;
	RotationArray[122] = 2.70526f;
	RotationArray[123] = 2.77158f;
	RotationArray[124] = 2.85536f;
	RotationArray[125] = 2.91994f;
	RotationArray[126] = 2.99848f;
	RotationArray[127] = 3.08225f;
	RotationArray[128] = 3.14159f;
	RotationArray[129] = 3.21839f;
	RotationArray[130] = 3.29693f;
	RotationArray[131] = 3.36325f;
	RotationArray[132] = 3.44353f;
	RotationArray[133] = 3.51160f;
	RotationArray[134] = 3.57792f;
	RotationArray[135] = 3.65996f;
	RotationArray[136] = 3.73850f;
	RotationArray[137] = 3.80133f;
	RotationArray[138] = 3.88336f;
	RotationArray[139] = 3.94793f;
	RotationArray[140] = 4.01426f;
	RotationArray[141] = 4.09454f;
	RotationArray[142] = 4.17134f;
	RotationArray[143] = 4.24290f;
	RotationArray[144] = 4.31096f;
	RotationArray[145] = 4.39474f;
	RotationArray[146] = 4.45932f;
	RotationArray[147] = 4.53960f;
	RotationArray[148] = 4.61640f;
	RotationArray[149] = 4.67923f;
	RotationArray[150] = 4.75951f;
	RotationArray[151] = 4.83805f;
	RotationArray[152] = 4.90088f;
	RotationArray[153] = 4.98292f;
	RotationArray[154] = 5.04924f;
	RotationArray[155] = 5.12080f;
	RotationArray[156] = 5.20283f;
	RotationArray[157] = 5.27439f;
	RotationArray[158] = 5.35293f;
	RotationArray[159] = 5.42099f;
	RotationArray[160] = 5.49779f;
	RotationArray[161] = 5.56585f;
	RotationArray[162] = 5.64265f;
	RotationArray[163] = 5.71072f;
	RotationArray[164] = 5.79275f;
	RotationArray[165] = 5.86256f;
	RotationArray[166] = 5.93063f;
	RotationArray[167] = 6.01266f;
	RotationArray[168] = 6.07724f;
	RotationArray[169] = 6.15752f;
	RotationArray[170] = 6.23432f;
	RotationArray[171] = 0.01571f;
	RotationArray[172] = 0.09599f;
	RotationArray[173] = 0.17628f;
	RotationArray[174] = 0.24260f;
	RotationArray[175] = 0.32114f;
	RotationArray[176] = 0.39270f;
	RotationArray[177] = 0.46426f;
	RotationArray[178] = 0.53407f;
	RotationArray[179] = 0.60563f;
	RotationArray[180] = 0.68417f;
	RotationArray[181] = 0.76445f;
	RotationArray[182] = 0.84299f;
	RotationArray[183] = 0.91106f;
	RotationArray[184] = 0.98611f;
	RotationArray[185] = 1.05592f;
	RotationArray[186] = 1.12923f;
	RotationArray[187] = 1.20079f;
	RotationArray[188] = 1.28282f;
	RotationArray[189] = 1.34914f;
	RotationArray[190] = 1.42768f;
	RotationArray[191] = 1.50796f;
	RotationArray[192] = 1.57080f;
	RotationArray[193] = 1.64934f;
	RotationArray[194] = 1.72613f;
	RotationArray[195] = 1.79245f;
	RotationArray[196] = 1.87274f;
	RotationArray[197] = 1.94081f;
	RotationArray[198] = 2.01236f;
	RotationArray[199] = 2.09789f;
	RotationArray[200] = 2.16770f;
	RotationArray[201] = 2.23053f;
	RotationArray[202] = 2.31256f;
	RotationArray[203] = 2.37539f;
	RotationArray[204] = 2.45742f;
	RotationArray[205] = 2.53596f;
	RotationArray[206] = 2.61450f;
	RotationArray[207] = 2.68606f;
	RotationArray[208] = 2.75587f;
	RotationArray[209] = 2.82394f;
	RotationArray[210] = 2.90248f;
	RotationArray[211] = 2.96881f;
	RotationArray[212] = 3.04211f;
	RotationArray[213] = 3.12588f;
	RotationArray[214] = 3.19221f;
	RotationArray[215] = 3.26726f;
	RotationArray[216] = 3.34231f;
	RotationArray[217] = 3.41386f;
	RotationArray[218] = 3.49589f;
	RotationArray[219] = 3.56222f;
	RotationArray[220] = 3.63203f;
	RotationArray[221] = 3.70184f;
	RotationArray[222] = 3.78038f;
	RotationArray[223] = 3.85718f;
	RotationArray[224] = 3.92699f;
	RotationArray[225] = 3.99506f;
	RotationArray[226] = 4.07185f;
	RotationArray[227] = 4.15039f;
	RotationArray[228] = 4.22195f;
	RotationArray[229] = 4.29176f;
	RotationArray[230] = 4.35983f;
	RotationArray[231] = 4.44186f;
	RotationArray[232] = 4.50993f;
	RotationArray[233] = 4.58673f;
	RotationArray[234] = 4.66526f;
	RotationArray[235] = 4.72810f;
	RotationArray[236] = 4.80838f;
	RotationArray[237] = 4.88518f;
	RotationArray[238] = 4.95150f;
	RotationArray[239] = 5.03004f;
	RotationArray[240] = 5.09811f;
	RotationArray[241] = 5.16792f;
	RotationArray[242] = 5.23948f;
	RotationArray[243] = 5.31802f;
	RotationArray[244] = 5.39656f;
	RotationArray[245] = 5.47684f;
	RotationArray[246] = 5.54142f;
	RotationArray[247] = 5.62345f;
	RotationArray[248] = 5.68628f;
	RotationArray[249] = 5.75610f;
	RotationArray[250] = 5.84162f;
	RotationArray[251] = 5.91318f;
	RotationArray[252] = 5.98124f;
	RotationArray[253] = 6.05978f;
	RotationArray[254] = 6.12785f;
	RotationArray[255] = 6.20465f;
*/
}


