
#pragma once

#define VELOCITY_SAMPLE_COUNT 8

#include "Vector2D.h"


class MovingEntity
{
public:
	enum CreationState
	{
		NewEntity = 0,
		AssignedEntity = 1,
		DeadEntity = 2
	};

	enum ShotCalculationMethod
	{
		Unkown = 0,
		CalculationMethodDirectShot_1 = 1,
		CalculationMethodDirectShot_2 = 2,
		CalculationMethodCrashAsteroid = 3,
		CalculationMethodRestAsteroid = 4
	};

	ShotCalculationMethod mShotCalculationMethod;

	static const int InvalidId = 0;
	static const int SpaceShipId = 1;
	static const int SaucerId = 2;

	MovingEntity(bool withoutNewId = false);
	virtual ~MovingEntity(void);

	MovingEntity& operator=(const MovingEntity& rhs);

	CreationState getCreationState(void) const;
	void setCreationState(const CreationState& state);

	Vector2D getPosition(void) const;
	void setPosition(const Vector2D& position);

	Vector2D predictPosition(const int& framesInFuture) const;

	virtual Vector2D getHeading(void) const;
	void setHeading(const Vector2D& heading);

	Vector2D getVelocity(void) const; 

	void setVelocity(const Vector2D& velocity, const int& count = VELOCITY_SAMPLE_COUNT);
	virtual void calculateVelocityFromPrevPosition(const Vector2D& prevPosition, int frameCount);

	virtual float getRadius(void) const;

	int getVelocityCalcCounter(void) const;
	
	int getId(void) const;

	void fireAndForget(const int& frames);
	void decreaseFireAndForgetCounter(const int& frames = 1);
	void setAlreadyUnderFire(bool underFire);
	bool getAlreadyUnderFire(void) const;
	int getFireAndForgetCounter(void) const;

	double getRendezvousTime(void) const;
	void setRendezvousTime(const double& time);

	double getSpeed(void) const;

protected:
	void setId(const int& id);

	Vector2D mVelocity;	// Die Geschwindigkeit des Schiffs. Proteceted, damit Spaceship und Saucer
						// direkt darauf zugreifen knnen

	Vector2D mVelocities[VELOCITY_SAMPLE_COUNT]; // Nur frs Dump mal auf protected gesetzt
	int mCurrentVelocityPos;
	int mVelocityCalcCounter;

private:
	static int nextValidId;

    MovingEntity(const MovingEntity& rhs); // Copy Constructor verbieten

	Vector2D mPosition; // Der Mittelpunkt des Schiffs
	Vector2D mHeading;  // Die Blickrichtung des Schiffs (Normalisiert)

	CreationState mCreationState;

	int mId;

	double mRendezvousTime;

	int mFireAndForgetCounter;
	bool mAlreadyUnderFire;

	double mSpeed;
};
