
#include "StdAfx.h"
#include <math.h>
#include "Matrix2D.h"


Matrix2D::Matrix2D(void)
{
	for (int i = 0; i < 9; i++)
	{
		mM[i] = 0.0;
	}
}

Matrix2D::Matrix2D(const Matrix2D& rhs)
{
	for (int i = 0; i < 9; i++)
	{
		mM[i] = rhs.mM[i];
	}
}

Matrix2D::~Matrix2D(void)
{
}

Matrix2D& Matrix2D::operator=(const Matrix2D& rhs)
{
    if (&rhs == this) { return *this; }

	for (int i = 0; i < 9; i++)
	{
		mM[i] = rhs.mM[i];
	}

    return *this; 
}


/*
 * Vorsicht bei der Anwendung der Multiplikation von zwei Matritzen !!!
 * Die Multiplikation auf diese Art kombiniert den Effect der Matritzen
 * in umgekehrter Reihenfolge. D.h.: Hat man zwei Transformationsmatrizen
 * A und B, dann ist AB die kombinierte Transformation, allerdings wenn 
 * man zuerst B und dann A anwendet !!! 
 */
Matrix2D Matrix2D::operator*(const Matrix2D& rhs) const
{
	Matrix2D r;

	r.mM[0] = mM[0] * rhs.mM[0] + mM[1] * rhs.mM[3] + mM[2] * rhs.mM[6];
	r.mM[1] = mM[0] * rhs.mM[1] + mM[1] * rhs.mM[4] + mM[2] * rhs.mM[7];
	r.mM[2] = mM[0] * rhs.mM[2] + mM[1] * rhs.mM[5] + mM[2] * rhs.mM[8];

	r.mM[3] = mM[3] * rhs.mM[0] + mM[4] * rhs.mM[3] + mM[5] * rhs.mM[6];
	r.mM[4] = mM[3] * rhs.mM[1] + mM[4] * rhs.mM[4] + mM[5] * rhs.mM[7];
	r.mM[5] = mM[3] * rhs.mM[2] + mM[4] * rhs.mM[5] + mM[5] * rhs.mM[8];

	r.mM[6] = mM[6] * rhs.mM[0] + mM[7] * rhs.mM[3] + mM[8] * rhs.mM[6];
	r.mM[7] = mM[6] * rhs.mM[1] + mM[7] * rhs.mM[4] + mM[8] * rhs.mM[7];
	r.mM[8] = mM[6] * rhs.mM[2] + mM[7] * rhs.mM[5] + mM[8] * rhs.mM[8];

	return r;
}

void Matrix2D::setTranslation(const Vector2D& t)
{
	mM[0] = 1; 	mM[1] = 0;  mM[2] = t.getX();
	mM[3] = 0;  mM[4] = 1;  mM[5] = t.getY();
	mM[6] = 0;  mM[7] = 0;  mM[8] = 1;
}

void Matrix2D::setRotation(const double& a)
{
	mM[0] = cos(a);  mM[1] = -1 * sin(a);  mM[2] = 0;
	mM[3] = sin(a);  mM[4] = cos(a);	   mM[5] = 0;
	mM[6] = 0;  mM[7] = 0;  mM[8] = 1;
}

void Matrix2D::setScaling(const Vector2D& s)
{
	mM[0] = s.getX(); 	mM[1] = 0;		   mM[2] = 0;
	mM[3] = 0;			mM[4] = s.getY();  mM[5] = 0;
	mM[6] = 0;			mM[7] = 0;		   mM[8] = 1;
}

Vector2D Matrix2D::transform(const Vector2D position) const
{
	double x = position.getX();
	double y = position.getY();

	return Vector2D(x * mM[0] + y * mM[1] + mM[2],
					x * mM[3] + y * mM[4] + mM[5]);
}
