
#pragma once

#include "Asteroid.h"
#include "Shot.h"
#include <list>
#include <queue>

static const int MAX_ASTEROIDS = 100;
static const int MAX_SHOTS = 10;



class SpaceShip;
class Saucer;

using namespace std;

class GameStatus
{
public:
	static const double CalculationRange;

	GameStatus(void);
	virtual ~GameStatus(void);

	GameStatus& operator=(const GameStatus& rhs);

	void clear(void);

	bool getSpaceShipIsPresent(void) const;
	void setSpaceShipIsPresent(bool isPresent);
	SpaceShip* getSpaceShip(void);

	Saucer* getSaucer(void);

	int mNasteroids; // Anzahl Asteroiden
	Asteroid mAsteroids[MAX_ASTEROIDS];

	int getAsteroidsCount(void) const;
	void setAsteroidsCount(int asteroidsCount);
	Asteroid* getAsteroids();

	int mNshots;     // Anzahl Schsse
	Shot mShots[MAX_SHOTS];

	int getShotsCount(void) const;
	void setShotsCount(int shotsCount);
	Shot* getShots();

	void writeStatusToLog();

	void getAllMovingEntities(std::list<MovingEntity*>* entities);

	void clearShotList(void);
	list<Shot*>* getShotList(void);
	void calculateShots(const int& frameRate);

	void clearAsteroidList(void);
	list<Asteroid*>* getAsteroidList(void);
	void calculateAsteroids(const int& frameRate, const int& latenz);

	Asteroid* getAsteroidById(const int& id);
	MovingEntity* getObjectById(const int& id);

	void addTarget(int id);

private:
    GameStatus(const GameStatus& rhs); // Copy Constructor verbieten

	bool mSpaceShipIsPresent;  // Schiff sichtbar
	SpaceShip* mSpaceShip;

	Saucer* mSaucer;

	std::list<Shot*> mShotList;
	std::list<Asteroid*> mAsteroidList;

	std::queue<int> mNextTargetIds;
};
