
#pragma once

#include "MovingEntity.h"


class Asteroid : public MovingEntity
{
public:
	Asteroid(bool withoutNewId = false);
	virtual ~Asteroid(void);

	Asteroid& operator=(const Asteroid& rhs);

	int getType(void) const;
	void setType(int type);

	int getScaleFactor(void) const;
	void setScaleFactor(int scaleFactor);

	void set(double x, double y, int type, int scaleFactor);
	virtual float getRadius(void) const; // Ist abhngig vom Scaling Factor

	void writeStatusToLog() const;

private:
    Asteroid(const Asteroid& rhs); // Copy Constructor verbieten
	int mType; // 1 ... 4, uere Form
	int mScaleFactor;   // scale factor: 0 = gro, 15 = mittel, 14 = klein
};
