package se.jupp.asteroids;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.util.*;

import se.jupp.asteroids.Game.Hit;

/**
 * Space ship in automated player of Asteroid game.
 *
 * This is part of a solution for a competition
 * <a href="http://www.heise.de/ct/creativ/08/02/details/">by the German computer magazine c't</a>
 */
public class Ship extends GameObject implements Cloneable {
    /** Ship color. */
    private static final Color COLOR = new Color(0xc0, 0xc0, 0xc0); // not as white as bullets

    /** The ship shape for drawing. */
    private static final GeneralPath SHIP_SHAPE = new GeneralPath();
    static {
        // defined for 0 angle
        SHIP_SHAPE.moveTo(16, 0);
        SHIP_SHAPE.lineTo(-16, 8);
        SHIP_SHAPE.lineTo(-8, 0);
        SHIP_SHAPE.lineTo(-16, -8);
        SHIP_SHAPE.closePath();
    }
    int turns = 0;
    final static Position[] turrets =
            new Position[] { new Position(152, 0, true), //0
                    new Position(152, 8, true), //1
                    new Position(152, 16, true), //2
                    new Position(152, 32, true), //3
                    new Position(152, 40, true), //4
                    new Position(144, 56, true), //5
                    new Position(136, 64, true), //6
                    new Position(136, 72, true), //7
                    new Position(128, 80, true), //8
                    new Position(120, 96, true), //9
                    new Position(112, 104, true), //10
                    new Position(104, 112, true), //11
                    new Position(96, 120, true), //12
                    new Position(88, 128, true), //13
                    new Position(80, 128, true), //14
                    new Position(64, 136, true), //15
                    new Position(56, 144, true), //16
                    new Position(48, 144, true), //17
                    new Position(32, 152, true), //18
                    new Position(24, 152, true), //19
                    new Position(8, 152, true), //20
                    new Position(0, 152, true), //21
                    new Position(-8, 152, true), //22
                    new Position(-24, 152, true), //23
                    new Position(-40, 152, true), //24
                    new Position(-48, 152, true), //25
                    new Position(-56, 144, true), //26
                    new Position(-72, 144, true), //27
                    new Position(-80, 136, true), //28
                    new Position(-88, 128, true), //29
                    new Position(-96, 120, true), //30
                    new Position(-112, 120, true), //31
                    new Position(-120, 112, true), //32
                    new Position(-120, 96, true), //33
                    new Position(-128, 88, true), //34
                    new Position(-136, 80, true), //35
                    new Position(-144, 72, true), //36
                    new Position(-152, 56, true), //37
                    new Position(-152, 48, true), //38
                    new Position(-160, 40, true), //39
                    new Position(-160, 24, true), //40
                    new Position(-160, 16, true), //41
                    new Position(-160, 0, true), //42
                    new Position(-160, -8, true), //43
                    new Position(-160, -16, true), //44
                    new Position(-160, -32, true), //45
                    new Position(-160, -40, true), //46
                    new Position(-160, -56, true), //47
                    new Position(-152, -64, true), //48
                    new Position(-144, -80, true), //49
                    new Position(-144, -88, true), //50
                    new Position(-136, -96, true), //51
                    new Position(-128, -104, true), //52
                    new Position(-120, -112, true), //53
                    new Position(-112, -120, true), //54
                    new Position(-104, -128, true), //55
                    new Position(-96, -136, true), //56
                    new Position(-80, -144, true), //57
                    new Position(-72, -152, true), //58
                    new Position(-64, -152, true), //59
                    new Position(-48, -160, true), //60
                    new Position(-40, -160, true), //61
                    new Position(-32, -160, true), //62
                    new Position(-16, -160, true), //63
                    new Position(0, -160, true), //64
                    new Position(8, -160, true), //65
                    new Position(16, -160, true), //66
                    new Position(32, -160, true), //67
                    new Position(40, -160, true), //68
                    new Position(56, -152, true), //69
                    new Position(64, -152, true), //70
                    new Position(72, -144, true), //71
                    new Position(80, -136, true), //72
                    new Position(96, -128, true), //73
                    new Position(104, -120, true), //74
                    new Position(112, -112, true), //75
                    new Position(120, -104, true), //76
                    new Position(128, -96, true), //77
                    new Position(128, -88, true), //78
                    new Position(136, -80, true), //79
                    new Position(144, -64, true), //80
                    new Position(144, -56, true), //81
                    new Position(152, -40, true), //82
                    new Position(152, -32, true), //83
                    new Position(152, -16, true), //84
                    new Position(152, -8, true), //85
                    new Position(152, 0, true), //86
                    new Position(152, 16, true), //87
                    new Position(152, 24, true), //88
                    new Position(152, 40, true), //89
                    new Position(144, 48, true), //90
                    new Position(144, 56, true), //91
                    new Position(136, 72, true), //92
                    new Position(128, 80, true), //93
                    new Position(120, 88, true), //94
                    new Position(120, 96, true), //95
                    new Position(112, 112, true), //96
                    new Position(96, 120, true), //97
                    new Position(88, 120, true), //98
                    new Position(80, 128, true), //99
                    new Position(72, 136, true), //100
                    new Position(56, 144, true), //101
                    new Position(48, 144, true), //102
                    new Position(40, 152, true), //103
                    new Position(24, 152, true), //104
                    new Position(16, 152, true), //105
                    new Position(0, 152, true), //106
                    new Position(-8, 152, true), //107
                    new Position(-16, 152, true), //108
                    new Position(-32, 152, true), //109
                    new Position(-40, 152, true), //110
                    new Position(-56, 144, true), //111
                    new Position(-64, 144, true), //112
                    new Position(-80, 136, true), //113
                    new Position(-88, 128, true), //114
                    new Position(-96, 128, true), //115
                    new Position(-104, 120, true), //116
                    new Position(-112, 112, true), //117
                    new Position(-120, 104, true), //118
                    new Position(-128, 96, true), //119
                    new Position(-136, 80, true), //120
                    new Position(-144, 72, true), //121
                    new Position(-152, 64, true), //122
                    new Position(-152, 56, true), //123
                    new Position(-160, 40, true), //124
                    new Position(-160, 32, true), //125
                    new Position(-160, 16, true), //126
                    new Position(-160, 8, true), //127
                    new Position(-160, 0, true), //128
                    new Position(-160, -16, true), //129
                    new Position(-160, -32, true), //130
                    new Position(-160, -40, true), //131
                    new Position(-160, -48, true), //132
                    new Position(-152, -64, true), //133
                    new Position(-152, -72, true), //134
                    new Position(-144, -80, true), //135
                    new Position(-136, -96, true), //136
                    new Position(-128, -104, true), //137
                    new Position(-120, -112, true), //138
                    new Position(-112, -120, true), //139
                    new Position(-104, -128, true), //140
                    new Position(-96, -136, true), //141
                    new Position(-88, -144, true), //142
                    new Position(-80, -144, true), //143
                    new Position(-64, -152, true), //144
                    new Position(-56, -160, true), //145
                    new Position(-40, -160, true), //146
                    new Position(-32, -160, true), //147
                    new Position(-16, -160, true), //148
                    new Position(-8, -160, true), //149
                    new Position(0, -160, true), //150
                    new Position(16, -160, true), //151
                    new Position(24, -160, true), //152
                    new Position(40, -160, true), //153
                    new Position(48, -152, true), //154
                    new Position(56, -152, true), //155
                    new Position(72, -144, true), //156
                    new Position(80, -136, true), //157
                    new Position(88, -128, true), //158
                    new Position(96, -120, true), //159
                    new Position(112, -120, true), //160
                    new Position(120, -112, true), //161
                    new Position(120, -96, true), //162
                    new Position(128, -88, true), //163
                    new Position(136, -80, true), //164
                    new Position(144, -72, true), //165
                    new Position(144, -56, true), //166
                    new Position(152, -48, true), //167
                    new Position(152, -40, true), //168
                    new Position(152, -24, true), //169
                    new Position(152, -8, true), //170
                    new Position(152, 0, true), //171
                    new Position(152, 8, true), //172
                    new Position(152, 24, true), //173
                    new Position(152, 32, true), //174
                    new Position(144, 48, true), //175
                    new Position(144, 56, true), //176
                    new Position(136, 64, true), //177
                    new Position(128, 80, true), //178
                    new Position(128, 88, true), //179
                    new Position(120, 96, true), //180
                    new Position(112, 104, true), //181
                    new Position(104, 112, true), //182
                    new Position(96, 120, true), //183
                    new Position(80, 128, true), //184
                    new Position(72, 136, true), //185
                    new Position(64, 136, true), //186
                    new Position(56, 144, true), //187
                    new Position(40, 152, true), //188
                    new Position(32, 152, true), //189
                    new Position(16, 152, true), //190
                    new Position(8, 152, true), //191
                    new Position(0, 152, true), //192
                    new Position(-16, 152, true), //193
                    new Position(-32, 152, true), //194
                    new Position(-40, 152, true), //195
                    new Position(-48, 152, true), //196
                    new Position(-64, 144, true), //197
                    new Position(-72, 136, true), //198
                    new Position(-80, 136, true), //199
                    new Position(-96, 128, true), //200
                    new Position(-104, 120, true), //201
                    new Position(-112, 112, true), //202
                    new Position(-120, 104, true), //203
                    new Position(-128, 96, true), //204
                    new Position(-136, 88, true), //205
                    new Position(-144, 80, true), //206
                    new Position(-144, 64, true), //207
                    new Position(-152, 56, true), //208
                    new Position(-160, 48, true), //209
                    new Position(-160, 32, true), //210
                    new Position(-160, 24, true), //211
                    new Position(-160, 8, true), //212
                    new Position(-160, 0, true), //213
                    new Position(-160, -8, true), //214
                    new Position(-160, -24, true), //215
                    new Position(-160, -40, true), //216
                    new Position(-160, -48, true), //217
                    new Position(-152, -56, true), //218
                    new Position(-152, -72, true), //219
                    new Position(-144, -80, true), //220
                    new Position(-136, -88, true), //221
                    new Position(-128, -96, true), //222
                    new Position(-120, -112, true), //223
                    new Position(-120, -120, true), //224
                    new Position(-112, -120, true), //225
                    new Position(-96, -128, true), //226
                    new Position(-88, -136, true), //227
                    new Position(-80, -144, true), //228
                    new Position(-72, -152, true), //229
                    new Position(-56, -152, true), //230
                    new Position(-48, -160, true), //231
                    new Position(-40, -160, true), //232
                    new Position(-24, -160, true), //233
                    new Position(-8, -160, true), //234
                    new Position(0, -160, true), //235
                    new Position(8, -160, true), //236
                    new Position(24, -160, true), //237
                    new Position(32, -160, true), //238
                    new Position(48, -160, true), //239
                    new Position(56, -152, true), //240
                    new Position(64, -144, true), //241
                    new Position(80, -144, true), //242
                    new Position(88, -136, true), //243
                    new Position(96, -128, true), //244
                    new Position(104, -120, true), //245
                    new Position(112, -112, true), //246
                    new Position(120, -104, true), //247
                    new Position(128, -96, true), //248
                    new Position(136, -80, true), //249
                    new Position(136, -72, true), //250
                    new Position(144, -64, true), //251
                    new Position(152, -48, true), //252
                    new Position(152, -40, true), //253
                    new Position(152, -32, true), //254
                    new Position(152, -16, true) //255
            };
    final static Position[] directions =

    new Position[] { new Position(63, 0, true), // 0
            new Position(63, 4, true), // 1
            new Position(63, 9, true), // 2
            new Position(62, 14, true), // 3
            new Position(61, 18, true), // 4
            new Position(59, 23, true), // 5
            new Position(57, 27, true), // 6
            new Position(55, 31, true), // 7
            new Position(53, 35, true), // 8
            new Position(50, 39, true), // 9
            new Position(47, 42, true), // 10
            new Position(44, 46, true), // 11
            new Position(40, 49, true), // 12
            new Position(36, 52, true), // 13
            new Position(32, 54, true), // 14
            new Position(28, 56, true), // 15
            new Position(24, 58, true), // 16
            new Position(20, 60, true), // 17
            new Position(15, 61, true), // 18
            new Position(11, 62, true), // 19
            new Position(6, 63, true), // 20
            new Position(1, 63, true), // 21
            new Position(-3, 63, true), // 22
            new Position(-8, 63, true), // 23
            new Position(-13, 62, true), // 24
            new Position(-17, 61, true), // 25
            new Position(-22, 60, true), // 26
            new Position(-26, 58, true), // 27
            new Position(-30, 56, true), // 28
            new Position(-34, 53, true), // 29
            new Position(-38, 51, true), // 30
            new Position(-42, 48, true), // 31
            new Position(-45, 45, true), // 32
            new Position(-48, 41, true), // 33
            new Position(-51, 38, true), // 34
            new Position(-54, 34, true), // 35
            new Position(-56, 30, true), // 36
            new Position(-58, 25, true), // 37
            new Position(-60, 21, true), // 38
            new Position(-61, 17, true), // 39
            new Position(-63, 12, true), // 40
            new Position(-63, 8, true), // 41
            new Position(-64, 3, true), // 42
            new Position(-64, -2, true), // 43
            new Position(-63, -6, true), // 44
            new Position(-63, -11, true), // 45
            new Position(-62, -16, true), // 46
            new Position(-61, -20, true), // 47
            new Position(-59, -25, true), // 48
            new Position(-57, -29, true), // 49
            new Position(-55, -33, true), // 50
            new Position(-52, -37, true), // 51
            new Position(-49, -41, true), // 52
            new Position(-46, -44, true), // 53
            new Position(-43, -47, true), // 54
            new Position(-39, -50, true), // 55
            new Position(-36, -53, true), // 56
            new Position(-32, -56, true), // 57
            new Position(-27, -58, true), // 58
            new Position(-23, -59, true), // 59
            new Position(-19, -61, true), // 60
            new Position(-14, -62, true), // 61
            new Position(-10, -63, true), // 62
            new Position(-5, -64, true), // 63
            new Position(0, -64, true), // 64
            new Position(4, -64, true), // 65
            new Position(9, -63, true), // 66
            new Position(14, -62, true), // 67
            new Position(18, -61, true), // 68
            new Position(23, -59, true), // 69
            new Position(27, -58, true), // 70
            new Position(31, -56, true), // 71
            new Position(35, -53, true), // 72
            new Position(39, -50, true), // 73
            new Position(42, -47, true), // 74
            new Position(46, -44, true), // 75
            new Position(49, -41, true), // 76
            new Position(52, -37, true), // 77
            new Position(54, -33, true), // 78
            new Position(56, -29, true), // 79
            new Position(58, -25, true), // 80
            new Position(60, -20, true), // 81
            new Position(61, -16, true), // 82
            new Position(62, -11, true), // 83
            new Position(63, -6, true), // 84
            new Position(63, -2, true), // 85
            new Position(63, 3, true), // 86
            new Position(63, 8, true), // 87
            new Position(62, 12, true), // 88
            new Position(61, 17, true), // 89
            new Position(60, 21, true), // 90
            new Position(58, 25, true), // 91
            new Position(56, 30, true), // 92
            new Position(53, 34, true), // 93
            new Position(51, 38, true), // 94
            new Position(48, 41, true), // 95
            new Position(45, 45, true), // 96
            new Position(41, 48, true), // 97
            new Position(38, 51, true), // 98
            new Position(34, 53, true), // 99
            new Position(30, 56, true), // 100
            new Position(25, 58, true), // 101
            new Position(21, 60, true), // 102
            new Position(17, 61, true), // 103
            new Position(12, 62, true), // 104
            new Position(8, 63, true), // 105
            new Position(3, 63, true), // 106
            new Position(-2, 63, true), // 107
            new Position(-6, 63, true), // 108
            new Position(-11, 62, true), // 109
            new Position(-16, 61, true), // 110
            new Position(-20, 60, true), // 111
            new Position(-25, 58, true), // 112
            new Position(-29, 56, true), // 113
            new Position(-33, 54, true), // 114
            new Position(-37, 52, true), // 115
            new Position(-41, 49, true), // 116
            new Position(-44, 46, true), // 117
            new Position(-47, 42, true), // 118
            new Position(-50, 39, true), // 119
            new Position(-53, 35, true), // 120
            new Position(-56, 31, true), // 121
            new Position(-58, 27, true), // 122
            new Position(-59, 23, true), // 123
            new Position(-61, 18, true), // 124
            new Position(-62, 14, true), // 125
            new Position(-63, 9, true), // 126
            new Position(-64, 4, true), // 127
            new Position(-64, 0, true), // 128
            new Position(-64, -5, true), // 129
            new Position(-63, -10, true), // 130
            new Position(-62, -14, true), // 131
            new Position(-61, -19, true), // 132
            new Position(-59, -23, true), // 133
            new Position(-58, -27, true), // 134
            new Position(-56, -32, true), // 135
            new Position(-53, -36, true), // 136
            new Position(-50, -39, true), // 137
            new Position(-47, -43, true), // 138
            new Position(-44, -46, true), // 139
            new Position(-41, -49, true), // 140
            new Position(-37, -52, true), // 141
            new Position(-33, -55, true), // 142
            new Position(-29, -57, true), // 143
            new Position(-25, -59, true), // 144
            new Position(-20, -61, true), // 145
            new Position(-16, -62, true), // 146
            new Position(-11, -63, true), // 147
            new Position(-6, -63, true), // 148
            new Position(-2, -64, true), // 149
            new Position(3, -64, true), // 150
            new Position(8, -63, true), // 151
            new Position(12, -63, true), // 152
            new Position(17, -61, true), // 153
            new Position(21, -60, true), // 154
            new Position(25, -58, true), // 155
            new Position(30, -56, true), // 156
            new Position(34, -54, true), // 157
            new Position(38, -51, true), // 158
            new Position(41, -48, true), // 159
            new Position(45, -45, true), // 160
            new Position(48, -42, true), // 161
            new Position(51, -38, true), // 162
            new Position(52, -34, true), // 163
            new Position(56, -30, true), // 164
            new Position(58, -26, true), // 165
            new Position(60, -22, true), // 166
            new Position(61, -17, true), // 167
            new Position(62, -13, true), // 168
            new Position(63, -8, true), // 169
            new Position(63, -3, true), // 170
            new Position(63, 1, true), // 171
            new Position(63, 6, true), // 172
            new Position(62, 11, true), // 173
            new Position(61, 15, true), // 174
            new Position(60, 20, true), // 175
            new Position(58, 24, true), // 176
            new Position(56, 28, true), // 177
            new Position(54, 32, true), // 178
            new Position(52, 36, true), // 179
            new Position(49, 40, true), // 180
            new Position(46, 44, true), // 181
            new Position(42, 47, true), // 182
            new Position(39, 50, true), // 183
            new Position(35, 53, true), // 184
            new Position(31, 55, true), // 185
            new Position(27, 57, true), // 186
            new Position(23, 59, true), // 187
            new Position(18, 61, true), // 188
            new Position(14, 62, true), // 189
            new Position(9, 63, true), // 190
            new Position(4, 63, true), // 191
            new Position(0, 63, true), // 192
            new Position(-5, 63, true), // 193
            new Position(-10, 63, true), // 194
            new Position(-14, 62, true), // 195
            new Position(-19, 61, true), // 196
            new Position(-23, 59, true), // 197
            new Position(-27, 57, true), // 198
            new Position(-32, 55, true), // 199
            new Position(-36, 53, true), // 200
            new Position(-39, 50, true), // 201
            new Position(-43, 47, true), // 202
            new Position(-46, 44, true), // 203
            new Position(-49, 40, true), // 204
            new Position(-52, 36, true), // 205
            new Position(-55, 32, true), // 206
            new Position(-57, 28, true), // 207
            new Position(-59, 24, true), // 208
            new Position(-61, 20, true), // 209
            new Position(-62, 15, true), // 210
            new Position(-63, 11, true), // 211
            new Position(-63, 6, true), // 212
            new Position(-64, 1, true), // 213
            new Position(-64, -3, true), // 214
            new Position(-63, -8, true), // 215
            new Position(-63, -13, true), // 216
            new Position(-61, -17, true), // 217
            new Position(-60, -22, true), // 218
            new Position(-58, -26, true), // 219
            new Position(-56, -30, true), // 220
            new Position(-54, -34, true), // 221
            new Position(-51, -38, true), // 222
            new Position(-48, -42, true), // 223
            new Position(-45, -45, true), // 224
            new Position(-42, -48, true), // 225
            new Position(-38, -51, true), // 226
            new Position(-34, -54, true), // 227
            new Position(-30, -56, true), // 228
            new Position(-26, -58, true), // 229
            new Position(-22, -60, true), // 230
            new Position(-17, -61, true), // 231
            new Position(-13, -63, true), // 232
            new Position(-8, -63, true), // 233
            new Position(-3, -64, true), // 234
            new Position(1, -64, true), // 235
            new Position(6, -63, true), // 236
            new Position(11, -63, true), // 237
            new Position(15, -62, true), // 238
            new Position(20, -61, true), // 239
            new Position(24, -59, true), // 240
            new Position(28, -57, true), // 241
            new Position(32, -55, true), // 242
            new Position(36, -52, true), // 243
            new Position(40, -49, true), // 244
            new Position(44, -46, true), // 245
            new Position(47, -43, true), // 246
            new Position(50, -39, true), // 247
            new Position(53, -36, true), // 248
            new Position(55, -32, true), // 249
            new Position(57, -27, true), // 250
            new Position(59, -23, true), // 251
            new Position(61, -19, true), // 252
            new Position(62, -14, true), // 253
            new Position(63, -10, true), // 254
            new Position(63, -5, true) // 255
            };

    public Ship() {
        super(null, 0, 0);
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        Ship c = (Ship) super.clone();
        return c;
    }
    Position direction;
    List<Position> history = new ArrayList<Position>(8);
    List<Integer> turnHistory = new ArrayList<Integer>(11);

    /**
     *  Constructor.
     *  @param x  x coordinate of ship center
     *  @param y  y coordinate of ship center
     *  @param dx direction x
     *  @param dy direction y
     */
    public Ship(Frame.SpaceShipPos pos, int timeBorn) {
        super(pos, 16, timeBorn);
        this.direction = pos.direction;
        history.add(pos);
        turns = 0;
        turnHistory.add(turns);
        //        System.out.println("New SpaceShip " + this);
    }
    boolean left, right, thrust, fire, hyper;
    int lastFire = 0;
    Queue<Hit> hits = new LinkedList<Hit>();
    LinkedList<Bullet> bullets = new LinkedList<Bullet>();

    void registerBullet(Bullet b) {
        bullets.add(b);
    }

    void deregisterBullet(Bullet b) {
        bullets.remove(b);
    }

    void calibrate(Bullet bullet) {
        //        boolean found = false;
        for (int i = 0; i < directions.length; i++) {
            if (bullet.velocity.equals(directions[i])) {
                //                found = true;
                int t = (i + (turns - turnHistory.get(0))) & 0xFF;
                int td = (t - turns) & 0xff;
                if (t != turns) {
                    //                    System.out.println("calibrating " + td);
                    for (int j = 0; j < turnHistory.size(); j++)
                        turnHistory.set(j, (turnHistory.get(j) + td) & 0xff);
                    turns = t;
                    direction = directions[turns];
                }
                break;
            }
        }
        //        if (!found)
        //            System.out.println("calibration NOT FOUND turns=" + turns
        //                    + " direction=" + direction + " " + bullet);
    }

    void goLeft() {
        left = true;
        right = false;
    }

    void goRight() {
        left = false;
        right = true;
    }

    void goStraight() {
        left = false;
        right = false;
    }

    void goHyper() {
        left = false;
        right = false;
        hyper = true;
    }

    int bulletsUnderway() {
        return (bullets.size() + hits.size());
    }

    boolean canFire() {
        return lastFire < age - 1 && bulletsUnderway() < 4;
    }

    void fire(Hit hit) {
        fire = true;
        lastFire = age;
        this.hits.offer(hit);
        //        GameObject p;
        //        if (hit != null)
        //            p = hit.friend;
        //        else
        //            p = predictedBullet();
        //        System.out.println("" + this + " firing at "
        //                + ((hit != null) ? hit.enemy : null)
        //                + "\n    predicted bullet " + p);
    }

    Bullet predictedBullet() {
        return new Bullet(turret().add(velocity), bulletSpeed(), 0);
    }

    Bullet predictedBullet(int turns) {
        return new Bullet(turret(turns).add(velocity), bulletSpeed(turns), 0);
    }

    int getKeys() {
        return (left ? BUTTON_LEFT : 0) | (right ? BUTTON_RIGHT : 0)
                | (thrust ? BUTTON_THRUST : 0) | (fire ? BUTTON_FIRE : 0)
                | (hyper ? BUTTON_HYPERSPACE : 0);
    }

    int nextTurns(int t) {
        int x;
        if (left)
            x = t + 1;
        else if (right)
            x = t - 1;
        else
            x = t;
        x &= 0xFF;
        return x;
    }

    void update(Frame.SpaceShipPos pos) {
        super.update(pos);
        if (pos == null) {
            // Destroyed!
            //            System.out.println("Ship " + this + " destroyed");
        } else {
            this.pos = pos;
            velocity =
                    this.pos.subtract(history.get(0)).divide(history.size())
                        .normalize();
            //            System.out.println("old pos " + previous + " new pos " + this.pos
            //                    + "direction " + direction + " velocity " + velocity
            //                    + " velocity length " + velocity.length());
            turns = nextTurns(turns);
            this.direction = directions[turns];
            if (turnHistory.size() >= 11)
                turnHistory.remove(0);
            turnHistory.add(turns);
            //this.direction = pos.direction;
            fire = false;
            left = false;
            right = false;
            thrust = false;
            hyper = false;
            if (history.size() >= 8)
                history.remove(0);
            history.add(pos);
            if (hits.size() > 0 && age - lastFire > 2) {
                //                System.out
                //                    .println("some bullet did not appear? " + hits.size());
                hits.clear();
            }
        }
        //        System.out.println("Ship " + this + " updated");
    }

    /**
     *  Get the size of the object.
     *
     *  The size returned by this method is half the length of a square which contains the object,
     *  so the object's bounding box is between (x - size, y - size) and (x + size, y + size).
     *  @return object size
     */
    public int getSize() {
        return 16;
    }

    /**
     *  Get the direction angle.
     *
     *  The angle is measured counterclockwise, with <code>0</code> pointing to the right
     *  @return ship direction in radians
     */

    /**
     * Draw the object.
     *
     * @param g graphics context
     */
    @Override
    public void draw(Graphics2D g) {
        g.setColor(COLOR);
        AffineTransform at =
                AffineTransform.getTranslateInstance(pos.x(), pos.y());
        at.concatenate(AffineTransform.getRotateInstance(direction.getAngle()));
        g.fill(at.createTransformedShape(SHIP_SHAPE));

        //        Position p = pos.add(direction.multiply(70));
        //        g.setColor(Color.GREEN);
        //        g.fillOval(pos.x() - 2, pos.y() - 2, 5, 5);
        //        pos.drawLine(p, g);
        //        g.fillOval(p.x() - 2, p.y() - 2, 5, 5);
        drawVelocityVector(g);

        //        g.setColor(Color.red);
        //        pos.drawLine(pos.add(direction), g);
        //        super.draw(g);
    }

    Position turret() {
        return pos.add(turrets[turns]);
    }

    Position turret(int turns) {
        return pos.add(turrets[turns & 0xFF]);
    }

    Position bulletSpeed() {
        return directions[turns].add(velocity);
    }

    Position bulletSpeed(int turns) {
        return directions[turns & 0xFF].add(velocity);
    }

    /**
     * Returns a string representation of the object.
     *
     * @return a string representation of the object.
     */
    @Override
    public String toString() {
        return "Ship@" + pos + " direction " + direction + " velocity "
                + velocity + " age " + age;
    }
}
