/*
 * Decompiled with CFR 0.152.
 */
package se.jupp.asteroids;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import se.jupp.asteroids.GameData;
import se.jupp.asteroids.Position;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Frame
implements GameData {
    static final int MAME_DATAGRAM_SIZE = 1026;
    private static final int ID_BYTE = 1024;
    private static final int PING_BYTE = 1025;
    private static final int MASK_OPCODE = 240;
    private static final int OPCODE_LABS = 160;
    private static final int OPCODE_HALT = 176;
    private static final int OPCODE_JSRL = 192;
    private static final int OPCODE_RTSL = 208;
    private static final int OPCODE_JMPL = 224;
    private static final int OPCODE_SVEC = 240;
    private static final int OPCODE_SHIP = 96;
    private static final int SUB_ASTEROID_TYPE1 = 2291;
    private static final int SUB_ASTEROID_TYPE2 = 2303;
    private static final int SUB_ASTEROID_TYPE3 = 2317;
    private static final int SUB_ASTEROID_TYPE4 = 2330;
    private static final int SUB_UFO = 2345;
    private final byte id;
    private final byte ping;
    final int score;
    UfoPos ufo;
    List<AsteroidPos> asteroids = new LinkedList<AsteroidPos>();
    SpaceShipPos spaceShip;
    List<Position> bullets = new LinkedList<Position>();

    AsteroidPos asteroidAt(int i) {
        return i < this.asteroids.size() ? this.asteroids.get(i) : null;
    }

    Position bulletAt(int i) {
        return i < this.bullets.size() ? this.bullets.get(i) : null;
    }

    private static int byteToUnsigned(byte b) {
        return b < 0 ? b + 256 : b;
    }

    public String toString() {
        return "Frame asteroids=" + this.asteroids.size() + " bullets=" + this.bullets.size();
    }

    Frame(ByteBuffer b) throws IOException {
        this.id = b.get(1024);
        this.ping = b.get(1025);
        StringBuilder buf = new StringBuilder();
        this.decode(b, buf);
        this.score = buf.length() > 0 ? Integer.parseInt(buf.toString()) : -1;
    }

    private void decode(ByteBuffer b, StringBuilder scoreBuf) throws IOException {
        int n = b.remaining();
        if (n != 1026) {
            throw new IOException("Incorrect datagram with size " + n);
        }
        if ((b.get(1) & 0xF0) != 224) {
            throw new IOException(String.format("Incorrect vector buffer start: %02x%02x", b.get(1), b.get(1)));
        }
        int vx = 0;
        int vy = 0;
        int vs = 0;
        int v1x = 0;
        int v1y = 0;
        int dx = 0;
        int dy = 0;
        boolean possibleShip = false;
        int p = 2;
        while (p < 1024) {
            int highbyte = Frame.byteToUnsigned(b.get(p + 1));
            int opcode = highbyte & 0xF0;
            switch (opcode) {
                case 160: {
                    vy = (highbyte & 3) << 8 | Frame.byteToUnsigned(b.get(p));
                    highbyte = Frame.byteToUnsigned(b.get((p += 2) + 1));
                    vx = (highbyte & 3) << 8 | Frame.byteToUnsigned(b.get(p));
                    vs = highbyte >> 4;
                    p += 2;
                    break;
                }
                case 176: {
                    return;
                }
                case 192: {
                    switch ((highbyte & 0xF) << 8 | Frame.byteToUnsigned(b.get(p))) {
                        case 2291: {
                            this.asteroids.add(new AsteroidPos(vx, vy, vs, 0));
                            break;
                        }
                        case 2303: {
                            this.asteroids.add(new AsteroidPos(vx, vy, vs, 1));
                            break;
                        }
                        case 2317: {
                            this.asteroids.add(new AsteroidPos(vx, vy, vs, 2));
                            break;
                        }
                        case 2330: {
                            this.asteroids.add(new AsteroidPos(vx, vy, vs, 3));
                            break;
                        }
                        case 2345: {
                            this.ufo = new UfoPos(vx, vy, vs);
                            break;
                        }
                        case 2781: {
                            if (vx != 100 || vy != 876 || vs != 1) break;
                            scoreBuf.append('0');
                            break;
                        }
                        case 2862: {
                            if (vx != 100 || vy != 876 || vs != 1) break;
                            scoreBuf.append('1');
                            break;
                        }
                        case 2866: {
                            if (vx != 100 || vy != 876 || vs != 1) break;
                            scoreBuf.append('2');
                            break;
                        }
                        case 2874: {
                            if (vx != 100 || vy != 876 || vs != 1) break;
                            scoreBuf.append('3');
                            break;
                        }
                        case 2881: {
                            if (vx != 100 || vy != 876 || vs != 1) break;
                            scoreBuf.append('4');
                            break;
                        }
                        case 2888: {
                            if (vx != 100 || vy != 876 || vs != 1) break;
                            scoreBuf.append('5');
                            break;
                        }
                        case 2895: {
                            if (vx != 100 || vy != 876 || vs != 1) break;
                            scoreBuf.append('6');
                            break;
                        }
                        case 2902: {
                            if (vx != 100 || vy != 876 || vs != 1) break;
                            scoreBuf.append('7');
                            break;
                        }
                        case 2907: {
                            if (vx != 100 || vy != 876 || vs != 1) break;
                            scoreBuf.append('8');
                            break;
                        }
                        case 2915: {
                            if (vx != 100 || vy != 876 || vs != 1) break;
                            scoreBuf.append('9');
                        }
                    }
                    p += 2;
                    break;
                }
                case 208: {
                    return;
                }
                case 224: {
                    return;
                }
                case 240: {
                    p += 2;
                    break;
                }
                default: {
                    if (this.spaceShip == null) {
                        dy = (highbyte & 3) << 8 | Frame.byteToUnsigned(b.get(p));
                        if ((highbyte & 4) != 0) {
                            dy = -dy;
                        }
                        highbyte = Frame.byteToUnsigned(b.get((p += 2) + 1));
                        dx = (highbyte & 3) << 8 | Frame.byteToUnsigned(b.get(p));
                        if ((highbyte & 4) != 0) {
                            dx = -dx;
                        }
                        int vz = highbyte >> 4;
                        if (dx == 0 && dy == 0 && vz == 15) {
                            this.bullets.add(new Position(vx, vy));
                        }
                        if (dx != 0 && dy != 0) {
                            if (opcode == 96 && vz == 12) {
                                if (possibleShip) {
                                    if (this.spaceShip == null) {
                                        this.spaceShip = new SpaceShipPos(vx, vy, v1x - dx, v1y - dy);
                                    }
                                    possibleShip = false;
                                } else {
                                    v1x = dx;
                                    v1y = dy;
                                    possibleShip = true;
                                }
                            }
                        } else if (possibleShip) {
                            possibleShip = false;
                        }
                        p += 2;
                        break;
                    }
                    p += 4;
                }
            }
        }
    }

    public byte getId() {
        return this.id;
    }

    public int getPing() {
        return this.ping;
    }

    public UfoPos getUfo() {
        return this.ufo;
    }

    public Collection<AsteroidPos> getAsteroids() {
        return Collections.unmodifiableCollection(this.asteroids);
    }

    public SpaceShipPos getSpaceShip() {
        return this.spaceShip;
    }

    public Collection<Position> getBullets() {
        return Collections.unmodifiableCollection(this.bullets);
    }

    static class AsteroidPos
    extends Position {
        final int size;
        final int type;

        AsteroidPos(int x, int y, int size, int type) {
            super(x, y);
            this.size = size;
            this.type = type;
        }
    }

    static class SpaceShipPos
    extends Position {
        final Position direction;

        SpaceShipPos(int x, int y, int dx, int dy) {
            super(x, y);
            this.direction = new Position(dx >> 3, dy >> 3);
        }
    }

    static class UfoPos
    extends Position {
        final int size;

        UfoPos(int x, int y, int size) {
            super(x, y);
            this.size = size;
        }
    }
}

