/*
 * Decompiled with CFR 0.152.
 */
package se.jupp.asteroids;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import se.jupp.asteroids.Frame;
import se.jupp.asteroids.GameObject;
import se.jupp.asteroids.Position;

public class Asteroid
extends GameObject
implements Cloneable {
    private static final int NORMAL_SCALE = 8;
    int size;
    int scale;
    int type;
    private static final GeneralPath PATH0 = new GeneralPath();
    private static final GeneralPath PATH1 = new GeneralPath();
    private static final GeneralPath PATH2 = new GeneralPath();
    private static final GeneralPath PATH3 = new GeneralPath();
    private static final Shape[] SHAPES;
    private static final int BIG_MAX_SQUARED_DIST = 64;
    private static final int SMALL_MAX_SQUARED_DIST = 10;

    static {
        PATH0.moveTo(1.0f, 0.0f);
        PATH0.lineTo(4.0f, 1.0f);
        PATH0.lineTo(4.0f, 2.0f);
        PATH0.lineTo(1.0f, 4.0f);
        PATH0.lineTo(-2.0f, 4.0f);
        PATH0.lineTo(-1.0f, 3.0f);
        PATH0.lineTo(-4.0f, 3.0f);
        PATH0.lineTo(-4.0f, -1.0f);
        PATH0.lineTo(-2.0f, -4.0f);
        PATH0.lineTo(1.0f, -3.0f);
        PATH0.lineTo(2.0f, -4.0f);
        PATH0.lineTo(4.0f, -2.0f);
        PATH0.closePath();
        PATH1.moveTo(3.0f, 0.0f);
        PATH1.lineTo(4.0f, 2.0f);
        PATH1.lineTo(2.0f, 4.0f);
        PATH1.lineTo(0.0f, 2.0f);
        PATH1.lineTo(-2.0f, 4.0f);
        PATH1.lineTo(-4.0f, 2.0f);
        PATH1.lineTo(-4.0f, -2.0f);
        PATH1.lineTo(-2.0f, -4.0f);
        PATH1.lineTo(1.0f, -4.0f);
        PATH1.lineTo(4.0f, -2.0f);
        PATH1.closePath();
        PATH2.moveTo(4.0f, 1.0f);
        PATH2.lineTo(2.0f, 4.0f);
        PATH2.lineTo(-1.0f, 4.0f);
        PATH2.lineTo(-4.0f, 1.0f);
        PATH2.lineTo(-2.0f, 0.0f);
        PATH2.lineTo(-4.0f, -1.0f);
        PATH2.lineTo(-2.0f, -4.0f);
        PATH2.lineTo(0.0f, -1.0f);
        PATH2.lineTo(0.0f, -4.0f);
        PATH2.lineTo(2.0f, -4.0f);
        PATH2.lineTo(4.0f, -1.0f);
        PATH2.closePath();
        PATH3.moveTo(2.0f, 1.0f);
        PATH3.lineTo(4.0f, 2.0f);
        PATH3.lineTo(2.0f, 4.0f);
        PATH3.lineTo(0.0f, 3.0f);
        PATH3.lineTo(-2.0f, 4.0f);
        PATH3.lineTo(-4.0f, 2.0f);
        PATH3.lineTo(-3.0f, 0.0f);
        PATH3.lineTo(-4.0f, -2.0f);
        PATH3.lineTo(-2.0f, -4.0f);
        PATH3.lineTo(-1.0f, -3.0f);
        PATH3.lineTo(2.0f, -4.0f);
        PATH3.lineTo(4.0f, -1.0f);
        PATH3.closePath();
        SHAPES = new Shape[]{PATH1, PATH3, PATH2, PATH0};
    }

    public Asteroid(Frame.AsteroidPos pos, int timeBorn) {
        super(pos, 4 * Asteroid.scale(pos.size), timeBorn);
        this.size = pos.size;
        this.scale = Asteroid.scale(this.size);
        assert (pos.type >= 0 && pos.type < SHAPES.length);
        this.type = pos.type;
    }

    protected Object clone() throws CloneNotSupportedException {
        Asteroid c = (Asteroid)super.clone();
        return c;
    }

    boolean match(Frame.AsteroidPos pos) {
        if (pos == null) {
            return false;
        }
        if (pos.size != this.size) {
            return false;
        }
        if (pos.type != this.type) {
            return false;
        }
        int max = this.age == 0 ? 64 : 10;
        return this.pos.add(this.velocity).distanceSquared(pos) <= max;
    }

    void update(Frame.AsteroidPos pos) {
        super.update(pos);
        if (pos != null) {
            if (this.age <= 8) {
                this.pos = pos;
                this.velocity = pos.subtract(this.bornAt).divide(this.age).normalize();
            } else {
                this.pos = this.pos.add(this.velocity).unnormalize();
            }
        }
    }

    int smallerSize() {
        switch (this.size) {
            case 0: {
                return 15;
            }
            case 15: {
                return 14;
            }
            case 14: {
                return -1;
            }
        }
        return -1;
    }

    private static int scale(int size) {
        switch (size) {
            case 0: {
                return 8;
            }
            case 15: {
                return 4;
            }
            case 14: {
                return 2;
            }
        }
        return 0;
    }

    public int getSize() {
        return 4 * this.scale;
    }

    public int getType() {
        return this.type;
    }

    public void draw(Graphics2D g) {
        if (this.dangerous) {
            g.setColor(Color.RED);
        } else {
            g.setColor(Color.gray);
        }
        Position p = this.pos.unnormalize();
        AffineTransform trafo = new AffineTransform(this.scale, 0.0f, 0.0f, this.scale, p.x(), p.y());
        g.draw(trafo.createTransformedShape(SHAPES[this.type]));
        this.drawVelocityVector(g);
    }

    public String toString() {
        return "Asteroid@" + this.id + this.pos;
    }
}

