/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package de.oflebbe.asteroids;

import java.util.Iterator;
import java.util.LinkedList;

/**
 *
 * @author olaf
 */
public class ScreenAnalyser {

    Screen previous, current;

    public ScreenAnalyser() {
        previous = current = null;
    }

    public void nextFrame(Screen scr) {

        previous = current;
        current = scr;

        if (previous == null) {
            return;
        }
        
        LinkedList<Asteroid> currAsteroids = new LinkedList<Asteroid>(
                current.getAsteroids());
       
        for (Asteroid ast : previous.getAsteroids()) {
           
            Iterator<Asteroid> itCurr = currAsteroids.iterator();
            while (itCurr.hasNext()) {
                Asteroid ast2 = itCurr.next();
                if (ast2.maybeSame(ast)) {
                    ast2.setVolicity(ast);
                    itCurr.remove();
                    break;
                }
            }
        }
        
        
        if (previous.getShip() != null && current.getShip() != null) {
            current.getShip().setVolicity( previous.getShip());
        }
        if (previous.getSaucer() != null && current.getSaucer() != null) {
            current.getSaucer().setVolicity(previous.getSaucer());
        }
        
        
        LinkedList<Shot> currShots = new LinkedList<Shot>(
                current.getShots());
       
        for (Shot shot : previous.getShots()) {
            
            Iterator<Shot> itCurr = currShots.iterator();
            while (itCurr.hasNext()) {
                Shot sh2 = itCurr.next();
                if (sh2.maybeSame(shot)) {
                    sh2.setVolicity(shot);
                    sh2.setUfoShot(shot.isUfoShot());
                    itCurr.remove();
                   
                    break;
                }
            }
        }
        // Shots not identified
        for (Shot sh2 : currShots) {
            sh2.setUfoShot(current.getShip() != null && sh2.len2(current.getShip()) > 25*25);
        }
         
    }
}
