package de.oflebbe.asteroids;

import java.util.ArrayList;

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 *
 * @author olaf
 */
public class MovingObject extends Veci2D {
    
    ArrayList<Veci2D> lv;
    Vecd2D v;
    MovingObject() {
        v = new Vecd2D( 0., 0.);
    }

    public MovingObject(int posx, int posy) {
        super(posx, posy);
        v = new Vecd2D( 0., 0.);
    }
    
    public MovingObject(MovingObject other) {
        super(other);
        v = new Vecd2D( 0., 0.);
    }

    public Vecd2D getV() {
        return v;
    }
    
    public double getVx() {
        return v.getX();
    }

   
    public double getVy() {
        return v.getY();
    }
    
    public void setV( Vecd2D v) {
        this.v = v;
    }
    
    public void setVx( double vx) {
        v.setX( vx);
    }

   
    public void setVy(double vy) {
       v.setY( vy);
    }
    
    static public int wrapX(int dx ) {
        if (dx > 511) dx-=1024;
        else if (dx < -512) dx+=1024;
        return dx;
    }
    static public int wrapY(int dy ) {
        if (dy > 383) dy-=768;
        else if (dy < -384) dy+=768;
        return dy;
    }
    
    static final int slidingAverageCount = 4;
    
    // Velocity vector / Frame
    // sliding average because of Saucer changing direction
    
    public void setVolicity( MovingObject otherPreviousFrame) {
        Veci2D sumv = new Veci2D();
        lv = new ArrayList<Veci2D>(slidingAverageCount);
        
        if (otherPreviousFrame.lv != null) {
            
            for (int i = (otherPreviousFrame.lv.size() == slidingAverageCount ? 1 : 0)
                    ; i < otherPreviousFrame.lv.size(); i++) {
                Veci2D val = otherPreviousFrame.lv.get(i);
                sumv.add( val);
                lv.add(val);
            }
        }
        
        Veci2D vec = getDir(otherPreviousFrame);
        sumv.add( vec);
        lv.add( vec);
        
        v = sumv.div( lv.size());        
    }
    
    public Veci2D getDir(MovingObject other ) {
        Veci2D vec = new Veci2D( wrapX( getX() - other.getX()),
                                 wrapY( getY() - other.getY()));
        return vec;
    }    
     
    public int len2(MovingObject other ) {
        return getDir( other).len2();
    }
   
}
