package Asteroid;

public class KeysPacket {
		static final Byte KEY_HYPERSPACE = 1;
		static final Byte KEY_FIRE = 2;
		static final Byte KEY_THRUST = 4;
		static final Byte KEY_RIGHT = 8;
		static final Byte KEY_LEFT = 0x10;

		byte[] signature = new byte[8];
		byte keys;
		byte ping;     // wird vom Server bei nchster Gelegenheit zurckgeschickt. Fr Latenzmessung.

		KeysPacket()
		{
			signature[0] = 'c';
			signature[1] = 't';
			signature[2] = 'm';
			signature[3] = 'a';
			signature[4] = 'm';
			signature[5] = 'e';
			keys = '@';
			ping = 0;
		}
		
		void clear()
		{
				keys = '@';
		};         // alle Tasten loslassen

		void hyperspace(boolean b)
		{
			if (b)
				keys |= KEY_HYPERSPACE;
			else
				keys &= ~KEY_HYPERSPACE;
		};  // Hyperspace drcken (true) oder loslassen (false)
		void fire(boolean b)        // Feuerknopf drcken (true) oder loslassen (false)
		{
			if (b)
				keys |= KEY_FIRE;
			else
				keys &= ~KEY_FIRE;
		}; 
		void thrust(boolean b)      // Beschleunigen ...
		{
			if (b)
				keys |= KEY_THRUST;
			else
				keys &= ~KEY_THRUST;
		}; 
		void right(boolean b)       // rechts drehen ...
		{
			if (b)
				keys |= KEY_RIGHT;
			else
				keys &= ~KEY_RIGHT;
		}; 
		void left(boolean b)        // links drehen
		{
			if (b)
				keys |= KEY_LEFT;
			else
				keys &= ~KEY_LEFT;
		}; 
		
		public byte[] toByteArray()
		{
			signature[6]=keys;
			signature[7]=ping;
			return signature;
		}
}
	
	
	
	

