/*
 * Decompiled with CFR 0.152.
 */
package Asteroid;

import Asteroid.FramepaketDisplay;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;

public abstract class VecObject {
    int x;
    int y;
    int oid = 0;
    int dx;
    int dy;
    int radius = 2;
    int ox;
    int oy;
    int q;
    int distanz;
    int neededFrames;
    int shipx;
    int shipy;
    Point vorhalteziel;
    boolean willKollide = false;
    static int OID = 1;
    static int MIN_X = -1024;
    static int MAX_X = 1023;
    static int MIN_Y = -768;
    static int MAX_Y = 767;
    static boolean showOID = true;
    static boolean showQual = false;
    static boolean showXY = true;
    static boolean showDxDy = false;
    static boolean showDxDyNorm = false;
    static boolean showSpeed = true;

    public String getIdString() {
        StringBuilder s = new StringBuilder();
        if (showOID) {
            s.append(Integer.toString(this.oid)).append(", ");
        }
        if (showQual) {
            s.append(Integer.toString(this.q)).append(", ");
        }
        if (showXY) {
            s.append("[").append(Integer.toString(this.x)).append(",").append(Integer.toString(this.y)).append("], ");
        }
        if (showDxDy) {
            s.append("[d").append(Integer.toString(this.dx)).append(",d").append(Integer.toString(this.dy)).append("]");
        }
        if (showDxDyNorm) {
            s.append("[d").append(Integer.toString(this.dx * 10 / this.q)).append(",d").append(Integer.toString(this.dy * 10 / this.q)).append("]");
        }
        if (showSpeed && this.oid > 0) {
            s.append("[s");
        }
        double rdx = this.dx;
        double rdy = this.dy;
        double speed = Math.sqrt((rdx /= (double)this.q) * rdx + (rdy /= (double)this.q) * rdy);
        s.append(Double.toString(speed)).append("]");
        return s.toString();
    }

    public boolean isAsteroid() {
        return false;
    }

    void set(int x, int y) {
        this.x = x;
        this.y = y;
    }

    void setOid(int oid) {
        this.oid = oid;
    }

    void relocate(int shipx, int shipy) {
        this.shipx = shipx;
        this.shipy = shipy;
        this.x -= shipx;
        this.y -= shipy;
        while (this.x < -512) {
            this.x += 1024;
        }
        while (this.x > 511) {
            this.x -= 1024;
        }
        while (this.y < -384) {
            this.y += 768;
        }
        while (this.y > 383) {
            this.y -= 768;
        }
    }

    VecObject findeVorgaengerIn(ArrayList<VecObject> objInDerNaehe, ArrayList<VecObject> vorVorgaenger) {
        VecObject vorgaenger;
        ArrayList<VecObject> objMitVorgaenger = new ArrayList<VecObject>(objInDerNaehe.size());
        ArrayList<VecObject> objOhneVorgaenger = new ArrayList<VecObject>(objInDerNaehe.size());
        for (VecObject a : objInDerNaehe) {
            if (a.oid > 0) {
                objMitVorgaenger.add(a);
                continue;
            }
            objOhneVorgaenger.add(a);
        }
        if (objMitVorgaenger.size() > 0 && (vorgaenger = this.findeVorgaengerMitOid(objMitVorgaenger)) != null) {
            return vorgaenger;
        }
        if (objOhneVorgaenger.size() > 0) {
            vorgaenger = this.findeVorgaengerOhneOid(objMitVorgaenger, vorVorgaenger);
            if (vorgaenger != null) {
                return vorgaenger;
            }
            return (VecObject)objOhneVorgaenger.get(0);
        }
        return null;
    }

    void findeVorgaenger(ArrayList<VecObject> vorgaengerListe, ArrayList<VecObject> vorVorgaengerListe) {
        ArrayList<VecObject> objInDerNaehe = new ArrayList<VecObject>(10);
        for (VecObject a : vorgaengerListe) {
            if (!this.isImRadius(a, 10)) continue;
            objInDerNaehe.add(a);
        }
        if (objInDerNaehe.size() == 0) {
            return;
        }
        if (objInDerNaehe.size() > 1) {
            VecObject vorgaenger = this.findeVorgaengerIn(objInDerNaehe, vorVorgaengerListe);
            if (vorgaenger != null) {
                this.setVorgaenger(vorgaenger);
                return;
            }
        } else {
            VecObject v = (VecObject)objInDerNaehe.get(0);
            this.setVorgaenger(v);
            return;
        }
    }

    protected void setVorgaenger(VecObject v) {
        if (v.oid == 0) {
            this.oid = v.oid = OID++;
            this.dx = this.x - v.x;
            this.dy = this.y - v.y;
            this.ox = v.x;
            this.oy = v.y;
            this.q = 1;
        } else {
            this.oid = v.oid;
            this.ox = v.ox;
            this.oy = v.oy;
            this.q = v.q + 1;
            this.dx = this.x - this.ox;
            this.dy = this.y - this.oy;
        }
    }

    boolean isImRadius(VecObject a, int radius) {
        int min_x = this.x - radius;
        while (min_x < MIN_X) {
            min_x += MAX_X - MIN_X;
        }
        if (min_x > a.x) {
            return false;
        }
        int max_x = this.x + radius;
        while (max_x > MAX_X) {
            max_x -= MAX_X - MIN_X;
        }
        if (max_x < a.x) {
            return false;
        }
        int min_y = this.y - radius;
        while (min_y < MIN_Y) {
            min_y += MAX_Y - MIN_Y;
        }
        if (min_y > a.y) {
            return false;
        }
        int max_y = this.y + radius;
        while (max_y > MAX_Y) {
            max_y -= MAX_Y - MIN_Y;
        }
        return max_y >= a.y;
    }

    boolean isImRadius(int x1, int y1, int radius) {
        int min_x = this.x - radius;
        while (min_x < -512) {
            min_x += 1024;
        }
        if (min_x > x1) {
            return false;
        }
        int max_x = this.x + radius;
        while (max_x > 511) {
            max_x -= 1024;
        }
        if (max_x < x1) {
            return false;
        }
        int min_y = this.y - radius;
        while (min_y < -512) {
            min_y += 1024;
        }
        if (min_y > y1) {
            return false;
        }
        int max_y = this.y + radius;
        while (max_y > 511) {
            max_y -= 1024;
        }
        return max_y >= y1;
    }

    protected VecObject findeMitOid(ArrayList<VecObject> liste, int oid) {
        for (VecObject a : liste) {
            if (a.oid != oid) continue;
            return a;
        }
        return null;
    }

    protected VecObject findeVorgaengerMitOid(ArrayList<VecObject> objMitVorgaenger) {
        for (VecObject a : objMitVorgaenger) {
            if (!this.isImRadius(a.x + a.dx, a.y + a.dy, 3)) continue;
            return a;
        }
        return null;
    }

    protected VecObject findeVorgaengerOhneOid(ArrayList<VecObject> objOhneVorgaenger, ArrayList<VecObject> vorVorgaengerListe) {
        for (VecObject a1 : objOhneVorgaenger) {
            for (VecObject a2 : vorVorgaengerListe) {
                if (!this.isImRadius(a1.x - a2.x + a1.x, a1.y - a2.y + a1.y, 3)) continue;
                a2.setOid(OID++);
                a1.setVorgaenger(a2);
                return a1;
            }
        }
        return null;
    }

    public int willKollideWithInFrames(Rectangle r) {
        int tmp;
        if (this.oid == 0) {
            return 0;
        }
        if (this.dx > 0 && this.x - this.radius > r.x + r.width) {
            return 0;
        }
        if (this.dx < 0 && this.x + this.radius < r.x) {
            return 0;
        }
        if (this.dy > 0 && this.y - this.radius > r.y + r.height) {
            return 0;
        }
        if (this.dy < 0 && this.y + this.radius < r.y) {
            return 0;
        }
        int x1 = 0;
        int y1 = 0;
        int x2 = 0;
        int y2 = 0;
        double rdxy = this.dx;
        double rdyx = 1.0 / (rdxy /= (double)this.dy);
        if (this.dx != 0) {
            y1 = (int)Math.round((double)(r.x - this.x - this.radius) * rdyx + (double)this.y);
            y2 = (int)Math.round((double)(r.x + r.width + this.radius - this.x) * rdyx + (double)this.y);
        } else if (this.x + this.radius < r.x || this.x - this.radius > r.x + r.width) {
            return 0;
        }
        if (this.dy != 0) {
            x1 = (int)Math.round((double)(r.y - this.y - this.radius) * rdxy + (double)this.x);
            x2 = (int)Math.round((double)(r.y + r.height + this.radius - this.y) * rdxy + (double)this.x);
        } else if (this.y + this.radius < r.y || this.x - this.radius > r.y + r.height) {
            return 0;
        }
        if (x1 > x2) {
            tmp = x1;
            x1 = x2;
            x2 = tmp;
        }
        if (y1 > y2) {
            tmp = y1;
            y1 = y2;
            y2 = tmp;
        }
        if (this.dx == 0 && (x1 > r.x && x1 < r.x + r.width || x2 > r.x && x2 < r.x + r.width)) {
            return 1;
        }
        if (this.dy == 0 && (y1 > r.y && y1 < r.y + r.height || y2 > r.y && y2 < r.y + r.height)) {
            return 1;
        }
        if ((y1 < r.y && y2 > r.y || y1 < r.y + r.height && y2 > r.y + r.height) && (x1 < r.x && x2 > r.x || x1 < r.x + r.width && x2 > r.x + r.width)) {
            return 1;
        }
        if (y1 >= r.y && y2 < r.y + r.height || x1 >= r.x && x2 < r.x + r.width) {
            return 1;
        }
        return 0;
    }

    void drawAsTargetOn(Graphics g) {
        int rx = this.x + this.shipx;
        int ry = this.y + this.shipy;
        if (rx < 0) {
            rx += 1024;
        }
        if (ry < 0) {
            ry += 768;
        }
        if (rx > 1023) {
            rx -= 1024;
        }
        if (ry > 767) {
            ry -= 768;
        }
        g.setColor(Color.red);
        g.drawOval(rx / FramepaketDisplay.SCALE, FramepaketDisplay.SIZEY - ry / FramepaketDisplay.SCALE, 3, 3);
        if (this.vorhalteziel != null) {
            rx = this.vorhalteziel.x + this.shipx;
            ry = this.vorhalteziel.y + this.shipy;
            if (rx < 0) {
                rx += 1024;
            }
            if (ry < 0) {
                ry += 768;
            }
            if (rx > 1023) {
                rx -= 1024;
            }
            if (ry > 767) {
                ry -= 768;
            }
            g.drawLine((rx - 10) / FramepaketDisplay.SCALE, FramepaketDisplay.SIZEY - ry / FramepaketDisplay.SCALE, (rx + 10) / FramepaketDisplay.SCALE, FramepaketDisplay.SIZEY - ry / FramepaketDisplay.SCALE);
            g.drawLine(rx / FramepaketDisplay.SCALE, FramepaketDisplay.SIZEY - (ry - 10) / FramepaketDisplay.SCALE, rx / FramepaketDisplay.SCALE, FramepaketDisplay.SIZEY - (ry + 10) / FramepaketDisplay.SCALE);
        }
    }
}

