/*
 * Decompiled with CFR 0.152.
 */
package Asteroid;

import Asteroid.Asteroid;
import Asteroid.AsteroidMain;
import Asteroid.FramePacket;
import Asteroid.FramepaketDisplay;
import Asteroid.GameStatus;
import Asteroid.KeysPacket;
import Asteroid.Shot;
import Asteroid.Ufo;
import Asteroid.VecObject;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.LinkedList;

public class AsteroidPlayer
implements Runnable {
    final DatagramSocket socket;
    final InetAddress serverAdress;
    final FramePacket framepaket;
    final KeysPacket keyspaket;
    GameStatus game2;
    GameStatus game1;
    GameStatus game0;
    GameStatus gameDiag;
    FramepaketDisplay display;
    static int[] DIR_VAL;
    final double[] W_VAL;
    static int MAXIMALE_FD_Q;
    boolean lastfire;
    LinkedList<GameStatus> gameHist = new LinkedList();

    static {
        int[] nArray = new int[17];
        nArray[1] = 152;
        nArray[2] = 296;
        nArray[3] = 440;
        nArray[4] = 584;
        nArray[5] = 720;
        nArray[6] = 856;
        nArray[7] = 976;
        nArray[8] = 1088;
        nArray[9] = 1192;
        nArray[10] = 1280;
        nArray[11] = 1360;
        nArray[12] = 1416;
        nArray[13] = 1472;
        nArray[14] = 1504;
        nArray[15] = 1528;
        nArray[16] = 1536;
        DIR_VAL = nArray;
        MAXIMALE_FD_Q = 300000;
    }

    AsteroidPlayer(InetAddress serverAdress) throws IOException {
        this.serverAdress = serverAdress;
        this.socket = new DatagramSocket();
        this.framepaket = new FramePacket();
        this.keyspaket = new KeysPacket();
        this.W_VAL = new double[17];
        int idx = 0;
        while (idx < 16) {
            this.W_VAL[idx] = Math.atan((double)DIR_VAL[idx] / (double)DIR_VAL[16 - idx]);
            ++idx;
        }
        this.W_VAL[16] = 1.570796;
    }

    void setDiagnosticDisplay(FramepaketDisplay d) {
        this.display = d;
    }

    GameStatus InterpretScreen() {
        GameStatus game = new GameStatus();
        int dx = 0;
        int dy = 0;
        int sf = 0;
        int vx = 0;
        int vy = 0;
        int vz = 0;
        int vs = 0;
        int v1x = 0;
        int v1y = 0;
        int shipdetect = 0;
        char[] vector_ram = this.framepaket.getVRam();
        if (vector_ram[0] != '\ue001' && vector_ram[0] != '\ue201') {
            return null;
        }
        int pc = 1;
        while (pc < 511) {
            int op = vector_ram[pc] >> 12;
            switch (op) {
                case 10: {
                    vy = vector_ram[pc] & 0x3FF;
                    vx = vector_ram[pc + 1] & 0x3FF;
                    vs = vector_ram[pc + 1] >> 12;
                    break;
                }
                case 11: {
                    return game;
                }
                case 12: {
                    switch (vector_ram[pc] & 0xFFF) {
                        case 2291: {
                            game.addAsteroid(vx, vy, 1, vs);
                            break;
                        }
                        case 2303: {
                            game.addAsteroid(vx, vy, 2, vs);
                            break;
                        }
                        case 2317: {
                            game.addAsteroid(vx, vy, 3, vs);
                            break;
                        }
                        case 2330: {
                            game.addAsteroid(vx, vy, 4, vs);
                            break;
                        }
                        case 2345: {
                            game.saucer_present = true;
                            game.ufo = new Ufo(vx, vy, vs);
                        }
                    }
                    break;
                }
                case 13: {
                    return game;
                }
                case 14: {
                    return game;
                }
                case 15: {
                    break;
                }
                default: {
                    dy = vector_ram[pc] & 0x3FF;
                    if ((vector_ram[pc] & 0x400) != 0) {
                        dy = -dy;
                    }
                    dx = vector_ram[pc + 1] & 0x3FF;
                    if ((vector_ram[pc + 1] & 0x400) != 0) {
                        dx = -dx;
                    }
                    sf = op;
                    vz = vector_ram[pc + 1] >> 12;
                    if (dx == 0 && dy == 0 && vz == 15) {
                        game.addShot(vx, vy);
                    }
                    if (op == 6 && vz == 12 && dx != 0 && dy != 0) {
                        switch (shipdetect) {
                            case 0: {
                                v1x = dx;
                                v1y = dy;
                                ++shipdetect;
                                break;
                            }
                            case 1: {
                                game.ship_present = true;
                                game.ship_x = vx;
                                game.ship_y = vy;
                                game.ship_dx = v1x - dx;
                                game.ship_dy = v1y - dy;
                                int dir = 0;
                                int testV = Math.abs(game.ship_dx);
                                int[] nArray = DIR_VAL;
                                int n = DIR_VAL.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    int xv = nArray[n2];
                                    if (xv == testV) break;
                                    ++dir;
                                    ++n2;
                                }
                                if (game.ship_dx < 0 && game.ship_dy > 0) {
                                    dir = 64 - dir;
                                } else if (game.ship_dx < 0 && game.ship_dy <= 0) {
                                    dir += 32;
                                } else if (game.ship_dx >= 0 && game.ship_dy < 0) {
                                    dir = 32 - dir;
                                }
                                game.ship_dir = dir;
                                ++shipdetect;
                            }
                        }
                        break;
                    }
                    if (shipdetect != true) break;
                    shipdetect = 0;
                }
            }
            if (op <= 10) {
                ++pc;
            }
            if (op == 14) continue;
            ++pc;
        }
        return game;
    }

    @Override
    public void run() {
        int prevframe = 0;
        int t = 0;
        while (true) {
            boolean bl;
            int frames;
            int zDir;
            Point p;
            int n;
            int dy;
            Asteroid altesFeuerziel;
            ++t;
            this.keyspaket.ping = (byte)(this.keyspaket.ping + 1);
            this.send();
            this.receive();
            byte by = (byte)(prevframe + 1);
            prevframe = by;
            if (this.framepaket.frameno != by || this.framepaket.ping != this.framepaket.ping) {
                System.out.println("Latenz " + (this.keyspaket.ping - this.framepaket.ping) + ", " + (this.framepaket.frameno - prevframe) + " Frames verloren.");
                prevframe = this.framepaket.frameno;
            }
            GameStatus game = this.InterpretScreen();
            if (game.ship_present) {
                for (VecObject vecObject : game.asteroids) {
                    vecObject.relocate(game.ship_x, game.ship_y);
                }
                for (VecObject vecObject : game.shots) {
                    vecObject.relocate(game.ship_x, game.ship_y);
                }
            }
            this.game2 = this.game1;
            this.game1 = this.game0;
            this.game0 = game;
            if (AsteroidMain.DIAG) {
                this.gameHist.add(this.game0);
                if (this.gameHist.size() > 20000) {
                    this.gameHist.remove();
                }
            }
            if (this.game1 != null && this.game1.saucer_present && this.game0.saucer_present) {
                this.game0.ufo.relocate(this.game0.ship_x, this.game0.ship_y);
                this.game0.ufo.setVorgaenger(this.game1.ufo);
            }
            if (this.game2 != null) {
                this.kalkBewegungsvektoren();
                this.markAsteroidWhoWillBeHit();
            }
            if (this.display != null) {
                if (this.gameDiag != null) {
                    this.display.setGamestatus(this.gameDiag);
                } else {
                    this.display.setGamestatus(game);
                }
            }
            this.keyspaket.clear();
            int n2 = Integer.MAX_VALUE;
            Rectangle shipRect = new Rectangle(-18, -18, 36, 36);
            if (!game.ship_present) continue;
            VecObject feuerziel = null;
            if (this.game1 != null && this.game1.feuerziel != null && this.game1.feuerziel.isAsteroid() && this.game1.feuerziel.willKollide && !(altesFeuerziel = (Asteroid)this.game1.feuerziel).getWillBeHit()) {
                for (Asteroid asteroid : this.game0.asteroids) {
                    if (asteroid.oid != altesFeuerziel.oid) continue;
                    feuerziel = asteroid;
                    this.berechneVorhalteZiel(feuerziel);
                    break;
                }
            }
            for (Asteroid a : game.asteroids) {
                if (a.getWillBeHit()) continue;
                boolean bl2 = a.willKollide = a.willKollideWithInFrames(shipRect) > 0;
                if (!a.willKollide) continue;
                int dx = a.x;
                dy = a.y;
                a.distanz = dx * dx + dy * dy;
                switch (a.sf) {
                    case 0: {
                        a.distanz -= 1600;
                        break;
                    }
                    case 15: {
                        a.distanz -= 400;
                        break;
                    }
                    case 14: {
                        a.distanz -= 64;
                    }
                }
                if (a.distanz < n) {
                    n = a.distanz;
                }
                if ((p = this.berechneVorhalteZiel(a)) == null) continue;
                zDir = this.berechneRichtungFuer(p);
                frames = Math.abs(game.ship_dir - zDir);
                if (frames > 32) {
                    frames -= 32;
                }
                a.neededFrames = frames;
                if (a.distanz >= MAXIMALE_FD_Q) continue;
                if (feuerziel == null) {
                    feuerziel = a;
                    continue;
                }
                if (a.distanz + a.neededFrames * 8 >= feuerziel.distanz + feuerziel.neededFrames * 8) continue;
                feuerziel = a;
            }
            if (game.saucer_present) {
                int zDir2;
                int frames2;
                Ufo ufo = game.ufo;
                int n3 = ufo.x;
                int dy2 = ufo.y;
                ufo.distanz = n3 * n3 + dy2 * dy2;
                switch (ufo.size) {
                    case 15: {
                        ufo.distanz -= 240;
                        break;
                    }
                    case 14: {
                        ufo.distanz -= 60;
                    }
                }
                Point p2 = this.berechneVorhalteZiel(ufo);
                if (p2 == null) {
                    ufo.vorhalteziel = p2 = new Point(ufo.x, ufo.y);
                }
                if ((frames2 = Math.abs(game.ship_dir - (zDir2 = this.berechneRichtungFuer(p2)))) > 32) {
                    frames2 -= 32;
                }
                ufo.neededFrames = frames2;
                if (ufo.distanz < MAXIMALE_FD_Q) {
                    if (feuerziel == null) {
                        feuerziel = ufo;
                    } else if (ufo.distanz < feuerziel.distanz) {
                        feuerziel = ufo;
                    }
                }
            }
            if (feuerziel == null) {
                for (Asteroid a : game.asteroids) {
                    int dx = a.x;
                    dy = a.y;
                    a.distanz = dx * dx + dy * dy;
                    switch (a.sf) {
                        case 0: {
                            a.distanz -= 1600;
                            break;
                        }
                        case 15: {
                            a.distanz -= 400;
                            break;
                        }
                        case 14: {
                            a.distanz -= 64;
                        }
                    }
                    p = this.berechneVorhalteZiel(a);
                    if (p == null) continue;
                    zDir = this.berechneRichtungFuer(p);
                    frames = Math.abs(game.ship_dir - zDir);
                    if (frames > 32) {
                        frames -= 32;
                    }
                    a.neededFrames = frames;
                    if (a.sf != 14 && a.distanz <= 500 || a.distanz >= MAXIMALE_FD_Q) continue;
                    if (feuerziel == null) {
                        feuerziel = a;
                        continue;
                    }
                    if (a.distanz + a.neededFrames * 8 >= feuerziel.distanz + feuerziel.neededFrames * 8) continue;
                    feuerziel = a;
                }
            }
            int nDir = game.ship_dir;
            if (feuerziel != null) {
                if (feuerziel.vorhalteziel == null) {
                    this.berechneVorhalteZiel(feuerziel);
                }
                Point point = feuerziel.vorhalteziel;
                int zDir3 = this.berechneRichtungFuer(point);
                int min_dx = point.x;
                int min_dy = point.y;
                if (zDir3 != game.ship_dir) {
                    if (game.ship_dx * min_dy - game.ship_dy * min_dx > 0) {
                        this.keyspaket.left(true);
                        if (--nDir < 0) {
                            nDir = 63;
                        }
                    } else {
                        this.keyspaket.right(true);
                        if (++nDir > 63) {
                            nDir = 0;
                        }
                    }
                }
            }
            for (Shot shot : game.shots) {
                if (shot.q <= 3) continue;
                int frames3 = shot.willKollideWithInFrames(shipRect);
                boolean bl3 = shot.willKollide = frames3 > 0;
                if (!shot.willKollide || frames3 >= 20) continue;
                this.keyspaket.hyperspace(true);
            }
            if (n < 729) {
                this.keyspaket.hyperspace(true);
            }
            if (this.display != null) {
                if (this.gameDiag != null) {
                    this.display.setGamestatus(this.gameDiag);
                } else {
                    game.feuerziel = feuerziel;
                    this.display.setGamestatus(game);
                }
            }
            if (((bl = this.willHitAnything(nDir)) || feuerziel != null) && !this.lastfire && (feuerziel != null && feuerziel == game.ufo && feuerziel.neededFrames < 2 || feuerziel != null && feuerziel.willKollide && feuerziel.neededFrames < 5 && feuerziel.distanz < 600 || bl)) {
                this.keyspaket.fire(true);
                this.lastfire = true;
                continue;
            }
            this.lastfire = false;
        }
    }

    private int berechneRichtungFuer(Point p) {
        Point dPoint = new Point(p.x, p.y);
        double px = Math.abs(dPoint.x);
        double py = Math.abs(dPoint.y);
        double w = py == 0.0 ? 1.0 : Math.atan(px / py);
        double min_dist = Math.abs(this.W_VAL[0] - w);
        int dir = 0;
        double[] dArray = this.W_VAL;
        int n = this.W_VAL.length;
        int n2 = 0;
        while (n2 < n) {
            double tv = dArray[n2];
            double dist = Math.abs(tv - w);
            if (dist < min_dist) {
                min_dist = dist;
            }
            if (dist > min_dist) break;
            ++dir;
            ++n2;
        }
        --dir;
        if (dPoint.x < 0 && dPoint.y > 0) {
            dir = 64 - dir;
        } else if (dPoint.x < 0 && dPoint.y <= 0) {
            dir += 32;
        } else if (dPoint.x >= 0 && dPoint.y < 0) {
            dir = 32 - dir;
        }
        return dir;
    }

    private Point berechneVorhalteZiel(VecObject o) {
        double f2;
        double a;
        double f1;
        if (o.oid == 0) {
            return null;
        }
        int frame = 0;
        double rdy = o.dy;
        double rdx = o.dx;
        double b = 2.0 * ((rdx /= (double)o.q) * (double)o.x + (rdy /= (double)o.q) * (double)o.y);
        double v = 7.97;
        double c = o.x * o.x + o.y * o.y;
        if ((frame = (int)(Math.max(f1 = (-1.0 * b + Math.sqrt(b * b - 4.0 * (a = rdx * rdx + rdy * rdy - v * v) * c)) / (2.0 * a), f2 = (-1.0 * b - Math.sqrt(b * b - 4.0 * a * c)) / (2.0 * a)) + 0.7)) <= 0) {
            return null;
        }
        o.vorhalteziel = new Point((int)Math.round((double)frame * rdx + (double)o.x), (int)Math.round((double)frame * rdy + (double)o.y));
        return o.vorhalteziel;
    }

    private double velocity(int frame, double dx0, int x0, int x1, double dy0, int y0, int y1) {
        return Math.sqrt(Math.pow((double)frame * dx0 + (double)x0 - (double)x1, 2.0) + Math.pow((double)frame * dy0 + (double)y0 - (double)y1, 2.0)) / (double)frame;
    }

    private void kalkBewegungsvektoren() {
        for (VecObject vecObject : this.game0.asteroids) {
            vecObject.findeVorgaenger(new ArrayList<VecObject>(this.game1.asteroids), new ArrayList<VecObject>(this.game2.asteroids));
        }
        if (this.game2.shots.size() > 0) {
            for (VecObject vecObject : this.game0.shots) {
                vecObject.findeVorgaenger(new ArrayList<VecObject>(this.game1.shots), new ArrayList<VecObject>(this.game2.shots));
            }
        }
        if (this.game2.saucer_present && this.game1.saucer_present && this.game0.saucer_present) {
            ArrayList<VecObject> arrayList = new ArrayList<VecObject>();
            ArrayList<VecObject> vu1 = new ArrayList<VecObject>();
            arrayList.add(this.game2.ufo);
            vu1.add(this.game1.ufo);
            this.game0.ufo.findeVorgaenger(vu1, arrayList);
        }
    }

    private void send() {
        byte[] ba = this.keyspaket.toByteArray();
        DatagramPacket packet = new DatagramPacket(ba, ba.length, this.serverAdress, 1979);
        try {
            this.socket.send(packet);
        }
        catch (IOException e) {
            System.out.println("Fehler beim Senden :" + e.getLocalizedMessage());
        }
    }

    private void receive() {
        DatagramPacket packet = new DatagramPacket(new byte[FramePacket.LENGTH], FramePacket.LENGTH);
        try {
            int read = 0;
            do {
                this.socket.receive(packet);
                this.framepaket.setFromBuffer(packet.getData());
            } while ((read += packet.getLength()) < FramePacket.LENGTH);
        }
        catch (IOException e) {
            System.out.println("Fehler beim Empfangen :" + e.getLocalizedMessage());
        }
    }

    public void displayFirst() {
        if (this.gameHist.size() > 0) {
            this.gameDiag = this.gameHist.getFirst();
            this.display.setGamestatus(this.gameDiag);
        }
    }

    public void displayLast() {
        if (this.gameHist.size() > 0) {
            this.gameDiag = null;
            this.display.setGamestatus(this.game0);
        }
    }

    public void displayPrev(boolean fast) {
        int idx;
        int inc;
        int n = inc = fast ? 10 : 1;
        if (this.gameDiag == null) {
            this.gameDiag = this.game0;
        }
        if ((idx = this.gameHist.indexOf(this.gameDiag) - inc) >= 0) {
            this.gameDiag = this.gameHist.get(idx);
            this.display.setGamestatus(this.gameDiag);
        }
    }

    public void displayNext(boolean fast) {
        int inc;
        int n = inc = fast ? 10 : 1;
        if (this.gameDiag == null) {
            return;
        }
        int idx = this.gameHist.indexOf(this.gameDiag) + inc;
        if (idx < this.gameHist.size()) {
            this.gameDiag = this.gameHist.get(idx);
            this.display.setGamestatus(this.gameDiag);
        }
    }

    public void markAsteroidWhoWillBeHit() {
        block0: for (Shot s : this.game0.shots) {
            s.willHit = false;
            if (s.oid <= 0 || s.dx == 0 && s.dy == 0) continue;
            double rdy = s.dy;
            rdy /= (double)s.q;
            double rdx = s.dx;
            rdx /= (double)s.q;
            int sf = 1;
            while (sf < 80) {
                Point sp = new Point((int)Math.round((double)sf * rdx + (double)s.x), (int)Math.round((double)sf * rdy + (double)s.y));
                for (Asteroid a : this.game0.asteroids) {
                    if (a.oid <= 0) continue;
                    double ardy = a.dy;
                    ardy /= (double)a.q;
                    double ardx = a.dx;
                    Point ap = new Point((int)Math.round((double)sf * (ardx /= (double)a.q) + (double)a.x), (int)Math.round((double)sf * ardy + (double)a.y));
                    if (!(ap.distance(sp) <= (double)a.radius)) continue;
                    a.willBeHit();
                    s.willHit = true;
                    break;
                }
                if (s.willHit) continue block0;
                ++sf;
            }
        }
    }

    protected boolean willHitAnything(int nDir) {
        double rdy;
        double rdx;
        if (nDir < 16) {
            rdx = DIR_VAL[nDir];
            rdy = DIR_VAL[16 - nDir];
        } else if (nDir < 32) {
            rdx = DIR_VAL[32 - nDir];
            rdy = DIR_VAL[nDir - 16] * -1;
        } else if (nDir < 48) {
            rdx = DIR_VAL[nDir - 32] * -1;
            rdy = DIR_VAL[48 - nDir] * -1;
        } else {
            rdx = DIR_VAL[64 - nDir] * -1;
            rdy = DIR_VAL[nDir - 48];
        }
        double sfak1 = Math.sqrt(rdx * rdx + rdy * rdy) / 7.88;
        double sfak2 = Math.sqrt(rdx * rdx + rdy * rdy) / 8.02;
        double rdy1 = rdy / sfak1;
        double rdx1 = rdx / sfak1;
        double rdy2 = rdy / sfak2;
        double rdx2 = rdx / sfak2;
        int sf = 1;
        while (sf < 100) {
            Point sp1 = new Point((int)Math.round((double)sf * rdx1), (int)Math.round((double)sf * rdy1));
            Point sp2 = new Point((int)Math.round((double)sf * rdx2), (int)Math.round((double)sf * rdy2));
            for (Asteroid a : this.game0.asteroids) {
                if (a.oid <= 0 || a.getWillBeHit() || a.sf != 14 && a.distanz <= 500) continue;
                double ardy = a.dy;
                double ardx = a.dx;
                Point ap = new Point((int)Math.round((double)sf * (ardx /= (double)a.q) + (double)a.x), (int)Math.round((double)sf * (ardy /= (double)a.q) + (double)a.y));
                if (!(ap.distance(sp1) < (double)a.radius) && !(ap.distance(sp2) < (double)a.radius)) continue;
                return true;
            }
            ++sf;
        }
        return false;
    }

    public void repaintDisplay() {
        this.display.repaint();
    }
}

