﻿/*
 * Asteroids Player Client 
 * 2008 ct-Wettbewerb
 * 
 * by Stefc (stefan.boether@gmail.com) */

using System;

namespace stefc.asteroids.strategy
{
    /// <summary>
    /// Abstrakte Game-Strategie die verfolgt wird
    /// </summary>
    abstract class AbstractStrategy
    {
        private IController controller;
        private AbstractStrategy nextStrategy;

        public AbstractStrategy(IController controller)
        {
            this.controller = controller;
        }

        protected IController Controller
        {
            get { return controller; }
        }

        protected bool DoRun(GameFrame currentGame)
        {
            
            if (currentGame.HyperSpaceJump)
            {
                Controller.Hyperspace();
                return false;
            }

            if (currentGame.GameState.WinkelByte == -1)
            {
                Controller.Left();
                return false;
            }

            return true;
            
        }

        public abstract AbstractStrategy Run(GameFrame currentGame);
        
        public virtual void Reset()
        { }

        public AbstractStrategy Next
        {
            get {
                nextStrategy.Reset();
                return nextStrategy; 
            }
            set { nextStrategy = value; }
        }

        protected void GetInTarget(GameFrame currentGame, Target target, bool isDangerous)
        {
            int srcAngle = currentGame.GameState.WinkelByte;
            if (srcAngle == target.Angle)
            {
                Controller.Fire();
                if (!isDangerous)
                    if ((target.SpaceObject.Size != 0))
                    {
                        int delta = (int)(GameUtils.GetTarget(target.SpaceObject).Length / 8.0);
                        if (delta > 3)
                            currentGame.GameState.BlockTarget(target.SpaceObject, delta);
                    }
            }
            else if ((srcAngle > target.Angle) && ((srcAngle-target.Angle)<128))
                Controller.Right();
            else
                Controller.Left();
        }
   }

}
