﻿using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Net;
using System.Net.Sockets;
using System.Diagnostics;

using stefc.asteroids.strategy;

namespace stefc.asteroids
{
    class Player : IController, IGameState
    {
        private UdpClient udpClient;
        private IPEndPoint udpEndPoint;

        byte[] sendBuffer; 
        private byte lastPing;
        private int lastFireTime;
        private int lastHyperTime; 

        private KeyCode keys;
        private GameFrame currentGame;
        private GameFrame prevGame;
        private int winkelByte;
        private int time;

        private List<Point> queue;
        private bool signalLeft;
        private bool signalRight;

        private TextWriter log; 

        private IDictionary<int, int> blocked;

        public Player(string server, int port)
        {
            // setup sendbuffer
            sendBuffer = new byte[8];

            sendBuffer[0] = (byte)'c';
            sendBuffer[1] = (byte)'t';
            sendBuffer[2] = (byte)'m';
            sendBuffer[3] = (byte)'a';
            sendBuffer[4] = (byte)'m';
            sendBuffer[5] = (byte)'e';

            // setup sockets for UDP connection
            udpEndPoint = new IPEndPoint(IPAddress.Parse(server), port);
            udpClient = new UdpClient();
            udpClient.Connect(udpEndPoint);
            
            lastPing = 0;
            lastFireTime = 0;
            winkelByte = -1;
            time = 0;

            queue = new List<Point>(5);

            blocked = new Dictionary<int, int>();
            // log = new StreamWriter("asteroid.csv");
        }

        public void Dump()
        { 
            keys = KeyCode.None;
            while (true)
            {
                lastPing++;
                
                // Send keys 
                SendPacket(keys);

                // Receive frame packet 
                FramePacket frame = ReceivePacket();
                
                Dump(frame);

                keys = KeyCode.None;

                keys |= KeyCode.Left;
            }
        }

        public void Run()
        {
            //do
            //{
            //    SendPacket(KeyCode.None);
            //    FramePacket packet = ReceivePacket();

            //    if (packet.Buffer[0]!=98) break;

            //    string buffer = new ASCIIEncoding().GetString(packet.Buffer);
            //    string[] tokens = buffer.Split(' ');
                

            //    Console.WriteLine(tokens[0]);
            //    Console.WriteLine(tokens[1]);
        
            //} while (true);

            //Console.WriteLine("Start");

            Stopwatch total = new Stopwatch();
            Stopwatch fps = new Stopwatch();

            prevGame = null;

            AbstractStrategy strategy = null;

            int syncsErr = 0;
            int latencyErr = 0;
            
            fps.Start();

            time = 0;
            int frames = 0;

            currentGame = null;
            keys = KeyCode.None;
            signalLeft = false;
            signalRight = false;
            while (true)
            {
                
                // Send keys 
                SendPacket(keys);

                // Receive frame packet 
                FramePacket frame = ReceivePacket();

                if (frame.Buffer.Length < 100)
                {
                    string buffer = new ASCIIEncoding().GetString(frame.Buffer);
                        
                    Console.WriteLine(buffer);
                    Console.WriteLine("Total time={0:F1} min / Score = {1}",
                        (total.ElapsedMilliseconds / (1000.0 * 60)), currentGame.Score);
                    Console.WriteLine("Latency #={0} Syncs#={1}", latencyErr, syncsErr);

                    total.Stop();
                    total.Reset();
                    break;
                }

                int latency = 0;
                if (frame.Ping > lastPing)
                    latency = lastPing - frame.Ping + 256;
                else if (lastPing > frame.Ping)
                    latency = lastPing - frame.Ping;

                // Console.Write(latency);
                if (latency != 0)
                {
                    // Console.WriteLine("{0}-{1}", lastPing, frame.Ping);
                    latencyErr++;
                }
                else 
                    lastPing++;

                // interprete 
                currentGame = InterpretPacket(frame);
                
                // Spiel beginnt
                if (!total.IsRunning)
                {
                    Console.WriteLine("Lasst die Spiele beginnen");
                    strategy = StrategyFactory.Create(this);
                    total.Start();
                    time = 0;
                    lastFireTime = time;
                    lastHyperTime = time;
                    latencyErr = 0;
                    syncsErr = 0;
                }
                // Spiel ist zu Ende
                //else if (total.IsRunning && ((time > 60 * 60 * Const.RUN_TIME) || (currentGame.Score > 0 && currentGame.Ships == 0)))
                //{
                //    Console.WriteLine("Game Over");
                //    Console.WriteLine("Total time={0:F1} min / Score = {1}",
                //        (total.ElapsedMilliseconds / (1000.0 * 60)), currentGame.Score);
                //    Console.WriteLine("Latency #={0} Syncs#={1}", latencyErr, syncsErr);

                //    total.Stop();
                //    total.Reset();
                //}

                keys = KeyCode.None;

                if (total.IsRunning)
                {
                    time++;

                    if (winkelByte == -1)
                    {
                        if (signalLeft)
                        {
                            if (currentGame.Ship != null)
                                queue.Add(new Point((int)currentGame.Ship.Dx, (int)currentGame.Ship.Dy));

                            if (queue.Count == 5)
                            {
                                int newWinkelByte = GameUtils.AngleSync(queue.ToArray());
                                if (newWinkelByte != -1)
                                {
                                    winkelByte = (newWinkelByte + 1) % 256;
                                }
                                queue.Clear();
                            }
                        }

                    }
                    else
                    {
                        if (signalRight || signalLeft)
                        {

                            int checkWinkelByte = winkelByte;
                            //if (latency != 0)
                            //{
                            //    if (signalRight)
                            //    {
                            //        checkWinkelByte += (latency);
                            //        if (checkWinkelByte >= 256)
                            //            checkWinkelByte = checkWinkelByte - 256;
                            //    }
                            //    else if (signalLeft)
                            //    {
                            //        checkWinkelByte -= (latency);
                            //        if (checkWinkelByte < 0)
                            //            checkWinkelByte = checkWinkelByte + 256;
                            //    }
                            //}

                            
                            if (currentGame.IsOutOfSync(checkWinkelByte))
                            {
                                winkelByte = currentGame.Resync(checkWinkelByte);
                                if (winkelByte ==-1)
                                {
                                    Console.WriteLine('*');
                                    // Console.WriteLine("out of sync {0}", checkWinkelByte);
                                    ResetWinkelByte();
                                    syncsErr++;
                                }
                            }

                            if (winkelByte != -1)
                            {
                                    if (signalLeft)
                                    {
                                        winkelByte += 1;
                                        if (winkelByte >= 256)
                                            winkelByte = winkelByte - 256;
                                    }
                                    else if (signalRight)
                                    {
                                        winkelByte -= 1;
                                        if (winkelByte < 0)
                                            winkelByte = winkelByte + 256;
                                    }
                            }
                        }
                    }

                    signalRight = false;
                    signalLeft = false;

                    if (currentGame.Ship != null)
                    {
                        //Out.Write(currentGame.GameState.Time);
                        //Out.Write(";");
                        //Out.Write(frame.Ping);
                        //Out.Write(";");
                        //Out.Write(latency);
                        //Out.Write(";");

                        currentGame.Normalize();

                        if (prevGame != null)
                            currentGame.MotionDetection(prevGame, 1);
                        else
                            currentGame.GenerateIds();

                        //foreach (Asteroid spaceObject in currentGame.Asteroids)
                        //{
                        //    Out.Write(";");
                        //    Out.Write(spaceObject.Id);
                        //    Out.Write(";");
                        //    Out.Write(spaceObject.X);
                        //    Out.Write(";");
                        //    Out.Write(spaceObject.Y);
                        //    Out.Write(";");
                        //    Out.Write(spaceObject.Dx);
                        //    Out.Write(";");
                        //    Out.Write(spaceObject.Dy);

                        //}


                        strategy = strategy.Run(currentGame);

                        //Out.WriteLine();
                    }
                    else
                    {
                        currentGame = null;
                        prevGame = null;
                        blocked.Clear();
                    }
                    
                }
                else
                    Start();

                // fps Berechnung und Anzeige
                frames++;

                //if (frames > 1000)
                //{
                //    fps.Stop();
                //    Console.WriteLine(String.Format("fps={0:F1}", frames * 1000.0 / fps.ElapsedMilliseconds));
                //    frames = 0;
                //    fps.Reset();
                //    fps.Start();
                //}

                prevGame = currentGame;
                
            }
            //log.Flush();
            //log.Close();
        }

        private GameFrame InterpretPacket(FramePacket frame)
        {
            GameFrame result = new GameFrame(this);

            using (Stream memoryStream = new MemoryStream(frame.Buffer))
            {
                using (BinaryReader reader = new BinaryReader(memoryStream))
                {
                    Operands state = Operands.Create();
                    
                    bool copyrightFound = false;
                    bool scoreFound = false;
                    bool shipFound = false;

                    int shipX = 0;
                    int shipY = 0;
                    string score = String.Empty;

                    
                    VectorOperation operation = new VectorOperation(reader);
                    while (operation.OpCode != OpCodes.HALT)
                    {
                        switch (operation.OpCode)
                        {
                            // Score ermitteln
                            case OpCodes.LABS:

                                // Console.WriteLine(operation);
                                state = operation.Operands;

                                if (copyrightFound && state.IsScore)
                                {
                                    scoreFound = true;
                                }
                                break;

                            case OpCodes.JMPL:
                                break;

                            case OpCodes.JSRL:

                                // Anzahl Leben ermitteln
                                if (operation.IsLive)
                                {
                                    result.Ships++;
                                    scoreFound = false;
                                }
                                else if (scoreFound)
                                {
                                    if (operation.IsDigit)
                                    {
                                        score += operation.Digit;
                                    }
                                } 
                                // Asteroid detection
                                else if (operation.IsAsteroid)
                                {
                                    result.Add(new Asteroid(state.Dx, state.Dy, state.Vz, operation.AsteroidType));
                                }
                                // UFO detection
                                else if (operation.IsUfo)
                                {
                                    // Console.WriteLine(operation);
                                    result.Ufo = new Ufo(state.Dx, state.Dy, state.Vz);
                                }
                                else if (operation.IsCopyright)
                                {
                                    copyrightFound = true;
                                }
                                
                                break;

                            // Eigene Schiffposition ermitteln 
                            case OpCodes.VCTR:
                                if (operation.IsShot)
                                {
                                    result.Add(new Shot(state.Dx, state.Dy));
                                }
                                else if (operation.IsShip)
                                {
                                    if (!shipFound)
                                    {
                                        shipFound = true;
                                        shipX = operation.Operands.Dx;
                                        shipY = operation.Operands.Dy;
                                    }
                                    else
                                    {
                                        result.Ship = new Ship(state.Dx, state.Dy,
                                            shipX - operation.Operands.Dx, shipY - operation.Operands.Dy);
                                        shipFound = false;
                                    }
                                }
                                break;

                            

                            default:
                                break;
                        }
                        operation = new VectorOperation(reader);
                    }

                    // punktzahl ermitteln
                    //score = score.Trim();
                    //if (!String.IsNullOrEmpty(score))
                    //{
                    //    score = score.Split(' ')[0];  //todo ist das noch notwendig?
                    //    if (score.Length > 5)
                    //        score = score.Substring(0, 5);
                    //    result.Score = Convert.ToInt32(score);
                    //}
                }
            }

            return result;
        }

        private void Dump(FramePacket frame)
        {
            using (Stream memoryStream = new MemoryStream(frame.Buffer))
            {
                using (BinaryReader reader = new BinaryReader(memoryStream))
                {
                    VectorOperation operation = new VectorOperation(reader);
                    while (operation.OpCode != OpCodes.HALT)
                    {
                        Console.WriteLine(operation);
                        operation = new VectorOperation(reader);
                    }

                    Console.WriteLine(operation);
                    Console.WriteLine("---------------------------------");
                }
            }
        }

        private FramePacket ReceivePacket()
        {
            IPEndPoint anyIP = new IPEndPoint(IPAddress.Any, 0);
            return new FramePacket(udpClient.Receive(ref anyIP));
        }
       
        private void SendPacket(KeyCode keyCode)
        {
            sendBuffer[6] = (byte) keyCode;             
            sendBuffer[7] = lastPing;

            udpClient.Send(sendBuffer, 8);
        }

        #region IController Members

        public void Left()
        {
            keys |= KeyCode.Left;

            signalLeft = true;          
        }

        public void Right()
        {
            keys |= KeyCode.Right;

            signalRight = true;
             
        }

        public void Hyperspace()
        {
            if (time > (lastHyperTime + 2))
            {
                keys |= KeyCode.HyperSpace;
                // Console.WriteLine(String.Format("{0} Hyperjump {1},{2}", currentGame.GameState.Time, currentGame.Ship.X, currentGame.Ship.Y));

                lastHyperTime = time; 
                currentGame = null;
                prevGame = null;
                blocked.Clear();
            }
        }

        public void Fire()
        {
            if (time > (lastFireTime + 1))
            {
                keys |= KeyCode.Fire;
                lastFireTime = time; 
            }
        }

        public void Thrust()
        {
            keys |= KeyCode.Thrust;
        }

        public void Start()
        {
            keys |= KeyCode.Start;  // fkt. nur mit mame patch
        }

        #endregion



        #region IGameState Members

        public void ResetWinkelByte()
        {
            winkelByte = -1;
            queue.Clear();
        }

        public int WinkelByte
        {
            get { return winkelByte; }
        }

        public int Time
        {
            get { return time; }
        }


        public bool IsTargetBlocked(SpaceObject target)
        {
            if (target.Id != -1)
                if (blocked.ContainsKey(target.Id))
                    if (time < blocked[target.Id])
                        return true;
                    else
                        blocked.Remove(target.Id);
            return false;
        }

        public void BlockTarget(SpaceObject target, int timeOfs)
        {
            if (target.Id != -1)
            {
                if (blocked.ContainsKey(target.Id))
                    blocked[target.Id] = time + timeOfs;
                else
                    blocked.Add(target.Id, time + timeOfs);
            }
        }

        public TextWriter Out
        {
            get { 

                return log; }
        }
 

        #endregion
    }
     
}
