/*
 * Copyright (C) 2008 Henning Faber
 * 
 * This file is part of Sitting Duck Asteroids Bot project.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. 
 */
package de.hfaber.asteroids.game.objects;


/**
 * Abstract default implementation for a scaleable game object.
 * 
 * @author Henning Faber
 */
public abstract class ScaleableGameObject extends GameObject implements
        IScaleableGameObject {

    /**
     * The size of the object. 
     */
    private int m_size;

    /**
     * Creates a scaleable game object with the given location and
     * object size.
     * 
     * @param x the x coordinate of the scaleable game object
     * @param y the y coordinate of the scaleable game object
     * @param size the object size
     */
    public ScaleableGameObject(int x, int y, int size) {
        super(x, y);
        m_size = size;
    }

    /**
     * Creates a scaleable game object that represents what the given 
     * scaleable game object is expected to be like in the given number 
     * of frames.
     * 
     * @param toProject the scaleable game object to project
     * @param frameCount the number of frames to project
     */
    public ScaleableGameObject(ScaleableGameObject toProject, int frameCount) {
        super(toProject, frameCount);
        m_size = toProject.m_size;
    }

    /* (non-Javadoc)
     * @see de.hfaber.asteroids.asteroids.game.objects.IScaleableGameObject#getSize()
     */
    public final int getScaleFactor() {
        return m_size;
    }
    
    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(getClass().getSimpleName());
        sb.append("[id=");
        sb.append(getId());
        sb.append(" x=");
        sb.append(getRelativeLocation().getX());
        sb.append(" y=");
        sb.append(getRelativeLocation().getY());
        sb.append(" size=");
        sb.append(getScaleFactor());
        sb.append("]");
        return sb.toString();
    }
}
