// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2005  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.util.settings;

import java.util.prefs.Preferences;

/**
 *  Enum value which contains an integer.
 *
 *  @author <a href="mailto:rammi@caff.de">Rammi</a>
 *  @version $Revision$
 */
public class IntegerEnumValue
        extends AbstractBasicEnumValue
{
  /** The integer value. */
  private final int value;
  /** The value as an object. */
  private final Integer realValue;

  /**
   *  Constructor.
   *  @param baseTag  basic i18n tag
   *  @param value    the real value
   */
  public IntegerEnumValue(String baseTag, int value)
  {
    super(baseTag);
    this.value = value;
    realValue = new Integer(value);
  }

  /**
   * Store this value to the preferences under the given key.
   *
   * @param preferences preferences to store to
   * @param key        key under which to store
   */
  public void storeTo(Preferences preferences, String key)
  {
    preferences.putInt(key, value);
  }

  /**
   * Is this value equal to the value which is stored in the preferences under the given key?
   *
   * @param preferences preferences where a enum value is stored
   * @param key        key under which the enum value is stored
   * @return <code>true</code> if the enum value is equal to the one stored in the preferences,
   *         <code>false</code> otherwise
   */
  public boolean isEqualTo(Preferences preferences, String key)
  {
    return preferences.getInt(key, value+1) == value;
  }

  /**
   * Get the real value which is used in this enum.
   *
   * @return the real value
   */
  public Object getRealValue()
  {
    return realValue;
  }

  /**
   *  Get the integer value.
   *  @return value
   */
  public int getValue()
  {
    return value;
  }
}
