// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2008  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.util;

import java.util.*;

/**
 *  A sequence of objects.
 */
public class Sequence<T>
{
  /** The sequence. */
  protected List<T> sequence;

  /**
   *  Default constructor.
   */
  public Sequence()
  {
    sequence = new LinkedList<T>();
  }

  /**
   *  Constructor.
   *  @param objects objects to add in the given sequence
   */
  public Sequence(T ... objects)
  {
    sequence = new ArrayList<T>(Arrays.asList(objects));
  }

  /**
   *  Add an object to the end of the sequence.
   *  @param obj object to add
   */
  public void add(T obj)
  {
    sequence.add(obj);
  }

  /**
   *  Remove an object from the sequence.
   *  @param obj object to remove
   *  @return <code>true</code> if the object was removed<br>
   *          <code>false</code> if no matching object was found in the sequence
   */
  public boolean remove(T obj)
  {
    return sequence.remove(obj);
  }
}
