// ============================================================================
// File:               $File$
//
// Project:            DXF viewer
//
// Purpose:            A knock off listener invoke when a {@link Worker} has finished.
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2003  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================

package de.caff.util;

/**
 *  A knock off listener invoke when a {@link Worker} has finished.
 *  @author <a href="mailto:rammi@caff.de">Rammi</a>
 *  @version $Revision$
 */
public interface KnockOffListener
{
  /**
   *  Called in the event thread when a worker has finished its work.
   *  @param worker worker which finished
   */
  public void knockedOff(Worker worker);
}
