// ============================================================================
// File:               RJPanel.java
//
// Project:            i18n 
//
// Purpose:            JPanel which notifies it's components of locale changes
//
// Author:             Rammi
//-----------------------------------------------------------------------------
// Copyright Notice:   (c) 2002  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================

package de.caff.i18n.swing;


import de.caff.i18n.I18n;
import de.caff.i18n.Localizable;

import javax.swing.*;
import java.awt.*;
import java.util.Locale;

/**
 *  JPanel which notifies it's components of locale changes.
 *  @author <a href="mailto:rammi@caff.de">Rammi</a>
 *  @version $Revision$
 */
public class RJPanel 
  extends    JPanel 
  implements Localizable 
{
  /**
   *
   */
  public RJPanel() {
  }

  /**
   *  @param isDoubleBuffered  double buffer this JPanel?
   */
  public RJPanel(boolean isDoubleBuffered) {
    super(isDoubleBuffered);
  }

  /**
   *  @param  mgr  layout manager
   */
  public RJPanel(LayoutManager mgr) {
    super(mgr);
  }

  /**
   *  @param  mgr  layout manager
   *  @param isDoubleBuffered  double buffer this JPanel?
   */
  public RJPanel(LayoutManager mgr, boolean isDoubleBuffered) {
    super(mgr, isDoubleBuffered);
  }

  /**
   *  @param  isDoubleBuffered is this panel double-buffered?
   *  @param  l         locale 
   */
  public RJPanel(boolean isDoubleBuffered, Locale l) {
    this(isDoubleBuffered);
    setLocale(l);
  }


  /**
   *  @param  mgr  layout manager
   *  @param  l         locale 
   */
  public RJPanel(LayoutManager mgr, Locale l) {
    super(mgr);
    setLocale(l);
  }

  /**
   *  @param  mgr  layout manager
   *  @param isDoubleBuffered  double buffer this JPanel?
   *  @param  l         locale 
   */
  public RJPanel(LayoutManager mgr, boolean isDoubleBuffered, Locale l) {
    this(mgr, isDoubleBuffered);
    setLocale(l);
  }


  /**
   * Notifies this component that it now has a parent component.
   * When this method is invoked, the chain of parent components is
   * set up with <code>KeyboardAction</code> event listeners.
   */
  public void addNotify()
  {
    super.addNotify();
    I18n.addLocalizationChangeListener(this);
  }

  /**
   * Overrides <code>JComponent.removeNotify</code> to check if
   * this button is currently set as the default button on the
   * <code>RootPane</code>, and if so, sets the <code>RootPane</code>'s
   * default button to <code>null</code> to ensure the
   * <code>RootPane</code> doesn't hold onto an invalid button reference.
   */
  public void removeNotify()
  {
    I18n.removeLocalizationChangeListener(this);
    super.removeNotify();
  }


  /**
   *  Change the locale.
   *  @param  l   new locale
   */
  public void setLocale(Locale l) {
    Locale oldLocale = getLocale();
    super.setLocale(l);
    if (oldLocale != null  &&  !oldLocale.equals(l)) {
      invalidate();
    }
  }

  /**
   *  Get the current locale. Don't throws <code>IllegalComponentStateException</code>.
   *  @return current locale or null, if unknown
   */
  public Locale getLocale() {
    try {
      return super.getLocale();
    } catch (IllegalComponentStateException x) {
      return null;
    }
  }

}
