/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid.analysis;

import de.caff.asteroid.analysis.AbstractBasicTimeLine;
import de.caff.asteroid.analysis.DumpFile;
import de.caff.asteroid.analysis.DumpLoadingListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ProgressTimeLine
extends AbstractBasicTimeLine
implements DumpLoadingListener {
    private int nrFrames;
    private int currentFrame;
    private List<DumpFile.Mark> marks = new ArrayList<DumpFile.Mark>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Collection<DumpFile.Mark> getMarks() {
        ArrayList<DumpFile.Mark> result;
        List<DumpFile.Mark> list = this.marks;
        synchronized (list) {
            result = new ArrayList<DumpFile.Mark>(this.marks.size() + 1);
            result.addAll(this.marks);
        }
        result.add(new DumpFile.Mark(this.currentFrame, DumpFile.MarkType.DUMP_END));
        return result;
    }

    @Override
    public int getFrameCount() {
        return this.nrFrames == 0 ? this.currentFrame + 1 : this.nrFrames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setExpectedFrames(int frameCount) {
        this.nrFrames = frameCount;
        List<DumpFile.Mark> list = this.marks;
        synchronized (list) {
            this.marks.clear();
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void marksChanged(Collection<DumpFile.Mark> marks) {
        List<DumpFile.Mark> list = this.marks;
        synchronized (list) {
            this.marks.clear();
            this.marks.addAll(marks);
        }
        this.repaint();
    }

    @Override
    public void frameCountChanged(int frameCount) {
        this.currentFrame = frameCount;
        this.repaint();
    }
}

