// creativ'08-Wettbewerb zum 25. c't-Geburtstag
// Beitrag von Curd Wallhaeusser

package robot41;

import java.util.List;
import java.util.LinkedList;
import java.util.Vector;
import java.util.ListIterator;
import java.util.Collections; 
import java.util.Comparator;

class Screen
{
  static final int LOG_ASTEROID_ANALYSIS     =0x0001;
  static final int LOG_ASTEROID_LOSS         =0x0002;
  static final int LOG_SAUCER_ANALYSIS       =0x0004;
  static final int LOG_SAUCER_LOSS           =0x0008;
  static final int LOG_OWN_SHOT_ANALYSIS     =0x0010;
  static final int LOG_OWN_SHOT_LOSS         =0x0020;
  static final int LOG_FOREIGN_SHOT_ANALYSIS =0x0040;
  static final int LOG_FOREIGN_SHOT_LOSS     =0x0080;

  static final int LOG_MODE=0; 

  public Saucer saucer;
  public Ship ship;
  public List<Asteroid> asteroids=new LinkedList<Asteroid>();
  public List<Shot> ownShots=new LinkedList<Shot>();
  public List<Shot> foreignShots=new LinkedList<Shot>();

  protected static final int MAX_N_SHOTS=64; // ok?
  protected static final int MAX_N_ASTEROIDS=64; // ok?

  protected static final int DELETED=-1;
  protected boolean shipPresent;
  protected int shipX,shipY,shipDx,shipDy;
  protected boolean saucerPresent;
  protected int saucerX,saucerY,saucerT;
  protected int nShots;
  protected int[] shotX,shotY;
  protected int nAsteroids;
  protected int[] asteroidX,asteroidY,asteroidT;

  protected Ship shipInstance;
  protected Saucer saucerInstance;

  Screen()
  {
    shipInstance=new Ship();
    saucerInstance=new Saucer();

    shotX=new int[MAX_N_SHOTS];
    shotY=new int[MAX_N_SHOTS];
    asteroidX=new int[MAX_N_ASTEROIDS];
    asteroidY=new int[MAX_N_ASTEROIDS];
    asteroidT=new int[MAX_N_ASTEROIDS];
  } // constructor
  
  protected void interpreteVRam(int[] vRam)
  {
    int dx,dy,scaleFactor,sx=0,sy=0,vz=0,vs=0;
    int lx=0,ly=0;
    int shipDetect=0;
    
    shipPresent=false;
    saucerPresent=false;
    nShots=0;
    nAsteroids=0;
       
    int pc=1;
    
    while(true)
    {
      int opcode=vRam[pc]>>12;
      switch(opcode)
      {
        case 0xa: // LABS
          sy=(vRam[pc  ]&0x3ff)-128;
          sx= vRam[pc+1]&0x3ff;
          vs= vRam[pc+1]>>12;
          break;
        
        case 0xb: return; // HALT
        
        case 0xc: // JSRL
          int addr=vRam[pc]&0xfff;
          switch(addr)
          {
            case 0x8f3: asteroidX[nAsteroids]=sx; asteroidY[nAsteroids]=sy; asteroidT[nAsteroids]=0x100+0xf&(vs-13); nAsteroids++; break;
            case 0x8ff: asteroidX[nAsteroids]=sx; asteroidY[nAsteroids]=sy; asteroidT[nAsteroids]=0x200+0xf&(vs-13); nAsteroids++; break;
            case 0x90d: asteroidX[nAsteroids]=sx; asteroidY[nAsteroids]=sy; asteroidT[nAsteroids]=0x300+0xf&(vs-13); nAsteroids++; break;
            case 0x91a: asteroidX[nAsteroids]=sx; asteroidY[nAsteroids]=sy; asteroidT[nAsteroids]=0x400+0xf&(vs-13); nAsteroids++; break;
            case 0x929: saucerX=sx; saucerY=sy; saucerT=vs; saucerPresent=true;  break;
          }
          break;

        case 0xd: return; // RTSL

        case 0xe: return; // JMPL

        case 0xf: break;  // SVEC

        default:
          dy=vRam[pc  ]&0x3ff;  if((vRam[pc  ]&0x400)!=0)dy=-dy;
          dx=vRam[pc+1]&0x3ff;  if((vRam[pc+1]&0x400)!=0)dx=-dx;
          scaleFactor=opcode;
          vz=vRam[pc+1]>>12;
          if(dx==0 && dy==0 && vz==15)
          { 
            shotX[nShots]=sx; shotY[nShots]=sy; nShots++;
          }
          if(opcode==6 && vz==12 && dx!=0 && dy!=0)
          {
            if(shipDetect==0)
            { 
              lx=dx;
              ly=dy;
            }
            else              
            {
              shipX=sx;     shipY=sy;
              shipDx=lx-dx; shipDy=ly-dy;
              shipPresent=true;
            }
            shipDetect++;
          }
          else if(shipDetect==1)
          {
            shipDetect=0;
          }
          break;
      } // switch
      if(opcode<=0xa)pc++; 
      if(opcode!=0xe)pc++; // JMPL         
    } // while
  } // interpreteVRam

  public void analyze(int t, int[] vRam)
  {
    // (1)
    interpreteVRam(vRam);
    
    // (2)
    if(shipPresent)
    {
      if(ship==null)ship=shipInstance;
      ship.sx=shipX;   ship.sy=shipY;
      ship.dx=shipDx;  ship.dy=shipDy;
    }
    else
      ship=null;
    
    // (3)
    if(saucerPresent)
    {
      if(saucer==null)saucer=saucerInstance;
      if(saucer.motionAnalyzed)
      {
        saucer.updatePredictedPosition(t);
        saucer.verifyPredictedPosition(saucerX,saucerY); 
        if(!saucer.predictedPositionVerified)
          saucer.analyzeMotion(t,saucerX,saucerY);
      }
      else
      {
        saucer.sx=saucerX; saucer.sy=saucerY;
        saucer.type=saucerT;
        saucer.vx=0; saucer.vy=0;
        saucer.analyzeMotion(t,saucerX,saucerY);
      }
    }
    else
      saucer=null;
    
    // (4) verify and update list of own shots:
    for(Shot shot: ownShots)
      shot.updatePredictedPosition(t);
    // (4a) verify and update list of own shots whose motion has been analyzed:
    for(ListIterator<Shot> iter=ownShots.listIterator(); iter.hasNext();)
    {
      Shot shot=iter.next();
      if(!shot.motionAnalyzed)continue;
      for(int i=0; i<nShots; i++)
      {
        if(shotX[i]==DELETED)continue;
        if(shot.verifyPredictedPosition(shotX[i],shotY[i]))
        {
          shotX[i]=DELETED;
          break;
        }
      }
      if(!shot.predictedPositionVerified)
      { 
        iter.remove();
      }
    }
    // (4b) continue analyzing own shots whose motion has not yet been analzed:
    for(ListIterator<Shot> iter=ownShots.listIterator(); iter.hasNext();)
    {
      Shot shot=iter.next();
      if(shot.motionAnalyzed)continue;
      int iBestMatch=0;
      int bestDd=Integer.MAX_VALUE;
      for(int i=0; i<nShots; i++)
      {
        if(shotX[i]==DELETED)continue;
        int dx,dy,dd;
        dx=shot.sx-shotX[i];
        dy=shot.sy-shotY[i];
        dd=dx*dx+dy*dy;
        if(dd<bestDd)
        {
          bestDd=dd;
          iBestMatch=i;
        }
      }
      if(bestDd<256)
      {
        //shot.sx=shotX[iBestMatch];  shot.sy=shotY[iBestMatch];
        shot.analyzeMotion(t,shotX[iBestMatch],shotY[iBestMatch]);
        shotX[iBestMatch]=DELETED;
      }
      else
      {
        iter.remove();
      }
    }
    
    // (5) verify and update list of shots:
    for(Shot shot: foreignShots)
      shot.updatePredictedPosition(t);
    // (5a) verify and update list of shots whose motion has been analyzed:
    for(ListIterator<Shot> iter=foreignShots.listIterator(); iter.hasNext();)
    {
      Shot shot=iter.next();
      if(!shot.motionAnalyzed)continue;
      for(int i=0; i<nShots; i++)
      {
        if(shotX[i]==DELETED)continue;
        if(shot.verifyPredictedPosition(shotX[i],shotY[i]))
        {
          shotX[i]=DELETED;
          break;
        }
      }
      if(!shot.predictedPositionVerified)
      { 
        iter.remove();
      }
    }
    // (5b) continue analyzing shots whose motion has not yet been analyzed:
    for(ListIterator<Shot> iter=foreignShots.listIterator(); iter.hasNext();)
    {
      Shot shot=iter.next();
      if(shot.motionAnalyzed)continue;
      int iBestMatch=0;
      int bestDd=Integer.MAX_VALUE;
      for(int i=0; i<nShots; i++)
      {
        if(shotX[i]==DELETED)continue;
        int dx,dy,dd;
        dx=shot.sx-shotX[i];
        dy=shot.sy-shotY[i];
        dd=dx*dx+dy*dy;
        if(dd<bestDd)
        {
          bestDd=dd;
          iBestMatch=i;
        }
      }
      if(bestDd<256)
      {
        int dx=0,dy=0,d=0;
        if(ship!=null)
        {
          dx=shot.sx-ship.sx;
          dy=shot.sy-ship.sy;
          d=(int)Math.round(Math.sqrt(dx*dx+dy*dy));
        }
        shot.analyzeMotion(t,shotX[iBestMatch],shotY[iBestMatch]);
        
        // check whether shot was own shot (doesen't work in 100%, but...)
        // to improve: use better own-shot-detection
        if(shot.iStep==2) //  && (d>=18 && d<=21))
        {
          dx=(dx*50)/16-shot.vx;  dy=(dy*50)/16-shot.vy;
          if(dx*dx+dy*dy<144) // this is an own shot
          {
            ownShots.add(shot);
            iter.remove();
          }
        }
        shotX[iBestMatch]=DELETED;
      }
      else
      {
        iter.remove();
      }
    }
    // (5c) start analyzing remaing shots:
    for(int i=0; i<nShots; i++)
    {
      if(shotX[i]==DELETED)continue;
      Shot shot=new Shot(shotX[i],shotY[i]);
      shot.analyzeMotion(t,shotX[i],shotY[i]);
      foreignShots.add(shot);
    }

    // (6) verify and update list of asteroids:
    for(Asteroid asteroid: asteroids)
      asteroid.updatePredictedPosition(t);
    // (6a) verify and update list of asteroids whose motion has been analyzed:
    for(ListIterator<Asteroid> iter=asteroids.listIterator(); iter.hasNext();)
    {
      Asteroid asteroid=iter.next();
      if(!asteroid.motionAnalyzed)continue;
      for(int i=0; i<nAsteroids; i++)
      {
        if(asteroidX[i]==DELETED)continue;
        if(asteroidT[i]!=asteroid.type)continue;
        if(asteroid.verifyPredictedPosition(asteroidX[i],asteroidY[i]))
        {
          asteroidX[i]=DELETED;
          break;
        }
      }
      if(!asteroid.predictedPositionVerified)
      { 
        if((LOG_MODE&LOG_ASTEROID_LOSS)!=0)
        {
          System.out.print("t="+t+" lost asteroid "+asteroid);
          System.out.println(" tExpectedFireHit="+asteroid.tExpectedFireHit);
        }
        iter.remove();
      }
    }
    // (6b) continue analyzing asteroids whose motion has not yet been analzed:
    for(ListIterator<Asteroid> iter=asteroids.listIterator(); iter.hasNext();)
    {
      Asteroid asteroid=iter.next();
      if(asteroid.motionAnalyzed)continue;
      int iBestMatch=0;
      int bestDd=Integer.MAX_VALUE;
      for(int i=0; i<nAsteroids; i++)
      {
        if(asteroidX[i]==DELETED)continue;
        if(asteroidT[i]!=asteroid.type)continue;
        int dx,dy,dd;
        dx=asteroid.psx-asteroidX[i];
        dy=asteroid.psy-asteroidY[i];
        dd=dx*dx+dy*dy;
        if(dd<bestDd)
        {
          bestDd=dd;
          iBestMatch=i;
        }
      }
      if(bestDd<100)
      {
        asteroid.analyzeMotion(t,asteroidX[iBestMatch],asteroidY[iBestMatch]);
        asteroidX[iBestMatch]=DELETED;
      }
      else
      {
        iter.remove();
      }
    }
    // (5c) start analyzing remaing asteroids:
    for(int i=0; i<nAsteroids; i++)
    {
      if(asteroidX[i]==DELETED)continue;
      Asteroid asteroid=new Asteroid(asteroidX[i],asteroidY[i],asteroidT[i]);
      asteroid.analyzeMotion(t,asteroidX[i],asteroidY[i]);
      asteroids.add(asteroid);
    }
  } // analyze

} // class
