// creativ'08-Wettbewerb zum 25. c't-Geburtstag
// Beitrag von Curd Wallhaeusser

package robot41;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

public class ControlPacket
{

  static final int PACKET_SIZE=8;     

  byte[] buffer=new byte[PACKET_SIZE];

  static final byte HYPERSPACE =0x01;
  static final byte FIRE       =0x02;
  static final byte THRUST     =0x04;
  static final byte RIGHT      =0x08;
  static final byte LEFT       =0x10;

  DatagramSocket datagramSocket;
  DatagramPacket datagramPacket=new DatagramPacket(buffer,PACKET_SIZE);
  
  byte turningDir,keys,ping;
  boolean fire;

  public ControlPacket(DatagramSocket datagramSocket, InetAddress host, int port)
  {
    this.datagramSocket=datagramSocket;
    datagramPacket.setAddress(host);
	datagramPacket.setPort(port);
    buffer[0]=(byte)'c';
    buffer[1]=(byte)'t';
    buffer[2]=(byte)'m';
    buffer[3]=(byte)'a';
    buffer[4]=(byte)'m';
    buffer[5]=(byte)'e';
    buffer[6]=(byte)0;
    buffer[7]=(byte)0;
    keys=0;
  } // constuctor

  public void setLeft      (boolean d){ if(d)keys|=LEFT;       else keys&=~LEFT; }
  public void setRight     (boolean d){ if(d)keys|=RIGHT;      else keys&=~RIGHT; }
  public void setFire      (boolean d){ if(d)keys|=FIRE;       else keys&=~FIRE; }
  public void setHyperspace(boolean d){ if(d)keys|=HYPERSPACE; else keys&=~HYPERSPACE; }
  public void setThrust    (boolean d){ if(d)keys|=THRUST;     else keys&=~THRUST; }

  public void setPing(byte ping){ this.ping=ping; }

  public byte getTurningDir(){ return turningDir; }
  public boolean getFire(){ return fire; }

  public void send() throws IOException
  {
    turningDir=0;
    fire=false;
    if((keys&LEFT)!=0){ keys&=~RIGHT; turningDir=1; }else if((keys&RIGHT)!=0)turningDir=-1;
    if((keys&FIRE)!=0)fire=true;
    buffer[6]=keys;
    buffer[7]=ping;
    datagramPacket.setLength(PACKET_SIZE);
    datagramSocket.send(datagramPacket);
    keys=0;
  } // send

} // class
