// creativ'08-Wettbewerb zum 25. c't-Geburtstag
// Beitrag von Curd Wallhaeusser

package robot41;

public class Body
{
  public int sx,sy; // position

  // prediction data:
  public int psx,psy;                       // predicted position
  public boolean predictedPositionVerified; // prediction state

  // motion analysis data:
  public int t0;                            // base time 
  public int sx0,sy0;                       // base position
  public int vx,vy;                         // velocity (per 8 frames)
  public int[] stepX,stepY;                 // position steps within 8 frame intervall
  protected int iStep;                      // step counter 0..8 for analysis
  public boolean motionAnalyzed;            // analysis state

  public Body()
  {
    motionAnalyzed=false;
    stepX=new int[8];
    stepY=new int[8];
  } // constructor

  public void updatePredictedPosition(int t)
  {
    if(motionAnalyzed)
    {
      // exact calculation:
      int dt=t-t0;
      int td=dt/8;
      int tm=dt%8;
      psx=sx0 + td*vx + stepX[tm];
      psy=sy0 + td*vy + stepY[tm];
      if(psx>=1024)psx=psx%1024; else if(psx<0)psx=1024-((-psx)%1024);
      if(psy>= 768)psy=psy% 768; else if(psy<0)psy= 768-((-psy)% 768);
      if(tm==0){ sx0=psx; sy0=psy; t0=t; }
    }
    else
    {
      // best approximation:
      int dt=t-t0;
      psx=sx0 + (dt*vx)/8;
      psy=sy0 + (dt*vy)/8;
      if(psx>=1024)psx=psx%1024; else if(psx<0)psx=1024-((-psx)%1024);
      if(psy>= 768)psy=psy% 768; else if(psy<0)psy= 768-((-psy)% 768);
    }
    predictedPositionVerified=false;
  } // updatePredictedPosition 

  boolean verifyPredictedPosition(int sx, int sy)
  {
    if(sx==psx && sy==psy)
    {
      this.sx=sx;
      this.sy=sy;
      predictedPositionVerified=true;
      return true;
    }
    return false;
  } // verifyPredictedPosition

/**
  * @return true if this was the last analysis step; otherwise false
  */
  public boolean analyzeMotion(int t, int sx, int sy)
  {
    if(motionAnalyzed)
    {
      // when a body's motion has been analyzed, but 
      // its new position could not been predicted,
      // the motion has to be reanalyzed
      // (this should happen only for saucers when they change motion)
      motionAnalyzed=false;
      t0=t-1;
      sx0=this.sx;
      sy0=this.sy;
      stepX[0]=0;
      stepY[0]=0;
      iStep=1;
    }
    
    this.sx=sx;
    this.sy=sy;

    if(iStep==0)
    {
      t0   =t;
      sx0  =sx;
      sy0  =sy;
      vx=0;
      vy=0;
      stepX[0]=0;
      stepY[0]=0;
      iStep=1;
      return false;
    }

    int stX,stY;
    stX=sx-sx0;
    stY=sy-sy0;
    if(stX>512)stX-=1024; else if(stX<-512)stX+=1024;
    if(stY>384)stY-= 768; else if(stY<-384)stY+= 768;
    if(iStep!=t-t0)
    {
      //throw new Error("Error: "+this+" iStep="+iStep+" t-t0="+(t-t0));
      //System.err.println("lost some frames?");
      t0   =t;
      sx0  =sx;
      sy0  =sy;
      vx=0;
      vy=0;
      stepX[0]=0;
      stepY[0]=0;
      iStep=1;
      return false;
    }
    
    if(iStep<8)
    {
      vx=(8*stX)/iStep; // best approximation for vx
      vy=(8*stY)/iStep; // best approximation for vy
      stepX[iStep]=stX;
      stepY[iStep]=stY;
      iStep++;
      return false;
    }
    else
    {
      vx=stX; // exact value for for vx
      vy=stY; // exact value for for vy
      motionAnalyzed=true;
      predictedPositionVerified=true;
      return true;
    } 
  } // analyzeMotion

} // class
