/*
 * Decompiled with CFR 0.152.
 */
package robot41;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.TextField;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.List;
import robot41.Asteroid;
import robot41.Game;
import robot41.Saucer;
import robot41.Screen;
import robot41.Ship;
import robot41.Shot;
import robot41.Target;

public class Display
extends Frame
implements WindowListener {
    TextField commentLine = new TextField("...");
    Game game;
    Screen screen;

    public Display(Game game) {
        this.game = game;
        this.screen = game.screen;
        this.addWindowListener(this);
        this.add((Component)this.commentLine, "South");
        this.setSize(1024, 848);
        this.setResizable(false);
        this.show();
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        int n3;
        Ship ship = this.screen.ship;
        Saucer saucer = this.screen.saucer;
        Target target = this.game.target;
        List<Asteroid> list = this.screen.asteroids;
        List<Shot> list2 = this.screen.ownShots;
        List<Shot> list3 = this.screen.foreignShots;
        for (Asteroid body : list) {
            n3 = body.sx;
            n2 = 768 - body.sy;
            n = body.getRadius();
            if (body == target) {
                graphics.setColor(Color.RED);
                if (body.motionAnalyzed) {
                    graphics.drawOval(n3 - n, n2 - n, 2 * n, 2 * n);
                }
            } else {
                if (body.motionAnalyzed) {
                    graphics.setColor(Color.BLACK);
                } else {
                    graphics.setColor(Color.DARK_GRAY);
                }
                graphics.drawOval(n3 - n, n2 - n, 2 * n, 2 * n);
                graphics.setColor(Color.LIGHT_GRAY);
            }
            graphics.drawLine(n3, n2, n3 + 100 * body.vx, n2 - 100 * body.vy);
        }
        for (Shot shot : list2) {
            n3 = shot.sx;
            n2 = 768 - shot.sy;
            n = 2;
            graphics.setColor(Color.YELLOW);
            graphics.drawOval(n3 - n, n2 - n, 2 * n, 2 * n);
            graphics.setColor(Color.YELLOW);
            graphics.drawLine(n3, n2, n3 + 100 * shot.vx, n2 - 100 * shot.vy);
        }
        for (Shot shot : list3) {
            n3 = shot.sx;
            n2 = 768 - shot.sy;
            n = 2;
            graphics.setColor(Color.DARK_GRAY);
            graphics.drawOval(n3 - n, n2 - n, 2 * n, 2 * n);
            graphics.setColor(Color.LIGHT_GRAY);
            graphics.drawLine(n3, n2, n3 + 100 * shot.vx, n2 - 100 * shot.vy);
        }
        if (ship != null) {
            graphics.setColor(Color.GREEN);
            double d = 0.07363107781851078 * (double)ship.aiming;
            double d2 = Math.cos(d);
            double d3 = Math.sin(d);
            n3 = ship.sx;
            n2 = 768 - ship.sy;
            n = ship.getRadius();
            graphics.drawOval(n3 - n, n2 - n, 2 * n, 2 * n);
            graphics.drawLine(n3, n2, n3 + (int)Math.round(25.0 * d2), n2 - (int)Math.round(25.0 * d3));
        }
        if (saucer != null) {
            n3 = saucer.sx;
            n2 = 768 - saucer.sy;
            n = saucer.getRadius();
            graphics.setColor(Color.MAGENTA);
            graphics.fillOval(n3 - n, n2 - n, 2 * n, 2 * n);
            graphics.drawLine(n3, n2, n3 + 100 * saucer.vx, n2 - 100 * saucer.vy);
        }
        int n4 = list.size();
        this.commentLine.setText("#asteroids=" + n4 + (saucer == null ? "" : "saucer.type=" + saucer.type));
    }

    void shutDown() {
        System.exit(0);
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.shutDown();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

