/*
 * Decompiled with CFR 0.152.
 */
package robot41;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

public class ControlPacket {
    static final int PACKET_SIZE = 8;
    byte[] buffer = new byte[8];
    static final byte HYPERSPACE = 1;
    static final byte FIRE = 2;
    static final byte THRUST = 4;
    static final byte RIGHT = 8;
    static final byte LEFT = 16;
    DatagramSocket datagramSocket;
    DatagramPacket datagramPacket = new DatagramPacket(this.buffer, 8);
    byte turningDir;
    byte keys;
    byte ping;
    boolean fire;

    public ControlPacket(DatagramSocket datagramSocket, InetAddress inetAddress, int n) {
        this.datagramSocket = datagramSocket;
        this.datagramPacket.setAddress(inetAddress);
        this.datagramPacket.setPort(n);
        this.buffer[0] = 99;
        this.buffer[1] = 116;
        this.buffer[2] = 109;
        this.buffer[3] = 97;
        this.buffer[4] = 109;
        this.buffer[5] = 101;
        this.buffer[6] = 0;
        this.buffer[7] = 0;
        this.keys = 0;
    }

    public void setLeft(boolean bl) {
        this.keys = bl ? (byte)(this.keys | 0x10) : (byte)(this.keys & 0xFFFFFFEF);
    }

    public void setRight(boolean bl) {
        this.keys = bl ? (byte)(this.keys | 8) : (byte)(this.keys & 0xFFFFFFF7);
    }

    public void setFire(boolean bl) {
        this.keys = bl ? (byte)(this.keys | 2) : (byte)(this.keys & 0xFFFFFFFD);
    }

    public void setHyperspace(boolean bl) {
        this.keys = bl ? (byte)(this.keys | 1) : (byte)(this.keys & 0xFFFFFFFE);
    }

    public void setThrust(boolean bl) {
        this.keys = bl ? (byte)(this.keys | 4) : (byte)(this.keys & 0xFFFFFFFB);
    }

    public void setPing(byte by) {
        this.ping = by;
    }

    public byte getTurningDir() {
        return this.turningDir;
    }

    public boolean getFire() {
        return this.fire;
    }

    public void send() throws IOException {
        this.turningDir = 0;
        this.fire = false;
        if ((this.keys & 0x10) != 0) {
            this.keys = (byte)(this.keys & 0xFFFFFFF7);
            this.turningDir = 1;
        } else if ((this.keys & 8) != 0) {
            this.turningDir = (byte)-1;
        }
        if ((this.keys & 2) != 0) {
            this.fire = true;
        }
        this.buffer[6] = this.keys;
        this.buffer[7] = this.ping;
        this.datagramPacket.setLength(8);
        this.datagramSocket.send(this.datagramPacket);
        this.keys = 0;
    }
}

