/*
 * Decompiled with CFR 0.152.
 */
package robot41;

public class Body {
    public int sx;
    public int sy;
    public int psx;
    public int psy;
    public boolean predictedPositionVerified;
    public int t0;
    public int sx0;
    public int sy0;
    public int vx;
    public int vy;
    public int[] stepX = new int[8];
    public int[] stepY = new int[8];
    protected int iStep;
    public boolean motionAnalyzed = false;

    public void updatePredictedPosition(int n) {
        if (this.motionAnalyzed) {
            int n2 = n - this.t0;
            int n3 = n2 / 8;
            int n4 = n2 % 8;
            this.psx = this.sx0 + n3 * this.vx + this.stepX[n4];
            this.psy = this.sy0 + n3 * this.vy + this.stepY[n4];
            if (this.psx >= 1024) {
                this.psx %= 1024;
            } else if (this.psx < 0) {
                this.psx = 1024 - -this.psx % 1024;
            }
            if (this.psy >= 768) {
                this.psy %= 768;
            } else if (this.psy < 0) {
                this.psy = 768 - -this.psy % 768;
            }
            if (n4 == 0) {
                this.sx0 = this.psx;
                this.sy0 = this.psy;
                this.t0 = n;
            }
        } else {
            int n5 = n - this.t0;
            this.psx = this.sx0 + n5 * this.vx / 8;
            this.psy = this.sy0 + n5 * this.vy / 8;
            if (this.psx >= 1024) {
                this.psx %= 1024;
            } else if (this.psx < 0) {
                this.psx = 1024 - -this.psx % 1024;
            }
            if (this.psy >= 768) {
                this.psy %= 768;
            } else if (this.psy < 0) {
                this.psy = 768 - -this.psy % 768;
            }
        }
        this.predictedPositionVerified = false;
    }

    boolean verifyPredictedPosition(int n, int n2) {
        if (n == this.psx && n2 == this.psy) {
            this.sx = n;
            this.sy = n2;
            this.predictedPositionVerified = true;
            return true;
        }
        return false;
    }

    public boolean analyzeMotion(int n, int n2, int n3) {
        if (this.motionAnalyzed) {
            this.motionAnalyzed = false;
            this.t0 = n - 1;
            this.sx0 = this.sx;
            this.sy0 = this.sy;
            this.stepX[0] = 0;
            this.stepY[0] = 0;
            this.iStep = 1;
        }
        this.sx = n2;
        this.sy = n3;
        if (this.iStep == 0) {
            this.t0 = n;
            this.sx0 = n2;
            this.sy0 = n3;
            this.vx = 0;
            this.vy = 0;
            this.stepX[0] = 0;
            this.stepY[0] = 0;
            this.iStep = 1;
            return false;
        }
        int n4 = n2 - this.sx0;
        int n5 = n3 - this.sy0;
        if (n4 > 512) {
            n4 -= 1024;
        } else if (n4 < -512) {
            n4 += 1024;
        }
        if (n5 > 384) {
            n5 -= 768;
        } else if (n5 < -384) {
            n5 += 768;
        }
        if (this.iStep != n - this.t0) {
            this.t0 = n;
            this.sx0 = n2;
            this.sy0 = n3;
            this.vx = 0;
            this.vy = 0;
            this.stepX[0] = 0;
            this.stepY[0] = 0;
            this.iStep = 1;
            return false;
        }
        if (this.iStep < 8) {
            this.vx = 8 * n4 / this.iStep;
            this.vy = 8 * n5 / this.iStep;
            this.stepX[this.iStep] = n4;
            this.stepY[this.iStep] = n5;
            ++this.iStep;
            return false;
        }
        this.vx = n4;
        this.vy = n5;
        this.motionAnalyzed = true;
        this.predictedPositionVerified = true;
        return true;
    }
}

