package de.wens02;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.util.Vector;

public class UFO extends Target
{
	private static final GeneralPath	SMALL;
	private static final GeneralPath	BIG		= new GeneralPath();

	static {
		int w = 24;
		int h = 8;

		BIG.moveTo( -w, 0 );
		BIG.lineTo( w, 0 );
		BIG.lineTo( w / 2, h );
		BIG.lineTo( -w / 2, h );
		BIG.lineTo( -w, 0 );
		BIG.lineTo( -w / 2, -h );
		BIG.lineTo( w / 2, -h );
		BIG.lineTo( w, 0 );
		BIG.moveTo( -h, -h );
		BIG.lineTo( -2 * h / 3, -2 * h );
		BIG.lineTo( 2 * h / 3, -2 * h );
		BIG.lineTo( h, -h );

		SMALL = new GeneralPath( BIG );
		SMALL.transform( AffineTransform.getScaleInstance( 0.5, 0.5 ) );
	};

	protected boolean									visible		= false;
	protected boolean									small			= true;
	protected Shape										shape			= null;

	protected static Vector<Shot>			shots			= new Vector<Shot>();

	public UFO( int x, int y, int s, int type )
	{
		super( x, y, s, type );
	}
	
	protected void setAppearance( int x, int y, int s, int type )
	{
		set( x, y, s, type );

		small = ( s != 15 );
		shape = small ? SMALL : BIG;

		x0				= x_virtual = x;
		y0				= y_virtual = y;
		dx				= 0.0f;
		dy				= 0.0f;
		frames		= 1;
		framewait = 0;

		visible		= true;
		exploding	= false;
		
		pixelSize					= small ? 20 : 40;
		squaredPixelSize	= pixelSize * pixelSize;
	}
	
	public int getPoints()
	{
		return small ? 1000 : 200;
	}
	
	public int getPixelSize()
	{
		return small ? 20 : 40;
	}
	
	public void update( Point p )
	{
		if ( this instanceof UFO && frames > 2 ) {
			// Das UFO fliegt nur mit dx,dy aus {-2,0,2}
			int dx_new = p.x - x;
			int dy_new = p.y - y;

			if ( dx_new != dx || dy_new != dy ) {
				if ( Debug.ufo ) {
					Log.debug(	String.format(
							"UFO Richtungsnderung: dx=%f,dy=%f, neu: dx=%d,dy=%d", dx, dy, p.x - x, p.y - y ) );
				}
				x = x0		= x_virtual = p.x;
				y = y0		= y_virtual = p.y;
				dx				= dx_new;
				dy				= dy_new;
				frames		= 1;
				framewait = 0;

				return;
			}
		}
		super.update( p );

		if ( 9 == frames && Debug.ufo ) {
			Log.debug(	String.format( "UFO dx=%f,dy=%f", dx, dy ) );
		}
	}

	public void paint( Graphics2D g )
	{
		g.setColor( Color.orange );
		g.draw( AffineTransform.getTranslateInstance( x, 1024 - y ).createTransformedShape( shape ) );
	}
}
