package de.wens02;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Vector;

public class Shot extends MovingObject
{
	/** Maximale Lebensdauer eines Schusses in Frames. Achtung: Im letzten Frame trifft ein Schuss nichts mehr */
	protected static final int MAX_LIFE	= 72;
	protected static final int MIN_LIFE	= 69;

	/** Wie gro die Projektilgeschwindigkeit ist, wurde in einem anderen
	 *  Posting schon exakt beschrieben. Die Lebenszeit eines Projektils
	 *  betrgt 18 und wird jedes 4. Frame um eins runtergezhlt
	 *  (wenn die interne Framenummer durch 4 teilbar ist),
	 *  insgesamt also zwischen 69 und 72 Frames, je nach Abschusszeitpunkt.
	 */
	protected static int		mod4_offset	= 0;
	
	/** Synchronisation eigener frame_cnt mit asteroids-frame_cnt erfolgt */
	private static boolean	measured		= false;

	/** Schuss kommt vom UFO */
	protected boolean				saucer			= false;

	/** Schuss wrde das Schiff abschieen */
	protected boolean				killing			= false;

	/** Winkelbyte bei Abgabe des Schusses */
	protected int						winkelbyte	= 0;

	/** Ziel dieses Schusses */
	protected Target				target			= null;

	/** max. Lebensdauer dieses Schusses: 69...72 Frames */
	protected int						max_remaining_frames;
	
	/** Berechnete Lebensdauer bis zum Impact: */
	protected int						calc_remaining_frames;

	public Shot( int x, int y )
	{
		super( x, y, 5, 0 );

		// Der Schussbefehl erfolgte zwei Frames frher, deswegen hier der Offset -2
		calc_remaining_frames	= getLifeSpan( -2 );
		max_remaining_frames	= getLifeSpan( -2 );
	}

	/** Testschuss bei frame mod 4 abgefeuert hatte Lebensspanne von lifespan Frames */
	public static void setLifeSpanOffset( final int frame_mod4, final int lifespan )
	{
		mod4_offset = ( 4 + ( MAX_LIFE - lifespan ) - frame_mod4 ) % 4;
		measured = true;
	}

	/** Reichweite eines Schusses, der im aktuellen Frame abgeschossen wrde */
	public static int getLifeSpan()
	{
		if ( !measured ) return MIN_LIFE;
		return MAX_LIFE - ( AsteroidApp.frame_cnt + mod4_offset ) % 4;
	}

	/** Reichweite eines Schusses, der in #frameHorizon Frames abgeschossen wird */
	public static int getLifeSpan( final int frameHorizon )
	{
		if ( !measured ) return MIN_LIFE;
		return MAX_LIFE - ( AsteroidApp.frame_cnt + frameHorizon + mod4_offset ) % 4;
	}
	
	public int getPixelSize()
	{
		return 4;
	}

	public int getSquaredPixelSize()
	{
		return 16;
	}
	
	public void update( Point p )
	{
		super.update( p );
		
		if ( calc_remaining_frames > 0 ) {
			calc_remaining_frames--;
		}
		if ( max_remaining_frames > 0 ) {
			max_remaining_frames--;
		}
	}

	public void paint( Graphics g )
	{
		int d = killing ? 10 : 4;
		g.setColor( killing ? Color.red : Color.lightGray );
		g.fillOval( x - d / 2, 1024 - y - d / 2, d, d );

		if ( dx != 0.0 || dy != 0.0 ) {
			// Schussvektor: Position in 20 Frames
			int xn = (int)( x + 20.0 * dx );
			int yn = (int)( y + 20.0 * dy );

			g.drawLine( x, 1024 - y, xn, 1024 - yn );
		}
		if ( projected_frames > 0 ) {
			g.drawOval( projected_x - d / 2, 1024 - projected_y - d / 2, d, d );
		}
	}

	/**
	 * Im Vektor av der Shots des letzten Frames suchen, ob
	 * es eine passende bereinstimmung zu (vx,vy) des jetzigen Frames gibt
	 */
	public static Shot FindShot( Vector<Shot> sv, Point p )
	{
		Shot		best			= null;
		double	best_dist	= 144.0;		// max. quadratischer Abstand

		for ( Shot shot : sv ) {
			double dist = shot.getSquaredTorusDistance( p, 1 );

			if ( dist < best_dist ) {
				best			= shot;
				best_dist	= dist;
			}
		}
		if ( null != best ) {
			sv.remove( best );
			best.update( p );
		}
		return best;
	}
}
