// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2005  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.util.settings;

import de.caff.i18n.I18n;

import java.util.Locale;
import java.util.MissingResourceException;

/**
 *  Basic implementation of a localizable preference property.
 *
 *  @author <a href="mailto:rammi@caff.de">Rammi</a>
 *  @version $Revision$
 */
public abstract class AbstractBasicLocalizablePreferenceProperty
        extends AbstractBasicPreferenceProperty
{
  /** The basic i18n tag used for the label. */
  private final String baseTag;

  /**
   *
   *  @param basicName  basic name (prefix)
   *  @param baseTag    basic i18n tag
   */
  protected AbstractBasicLocalizablePreferenceProperty(String basicName, String baseTag)
  {
    super(basicName);
    this.baseTag = baseTag;
  }

  /**
   * Get a name for the editor component.
   *
   * @param l locale used for i18n
   * @return common title or <code>null</code>
   */
  public String getName(Locale l)
  {
    return getLabelString(l);
  }

  /**
   *  Return a localized string to be used as a label.
   *  @param l  locale
   *  @return label string
   */
  public String getLabelString(Locale l)
  {
    return getString(l, I18n.SUFFIX_TEXT);
  }

  /**
   *  Return a localitzed string to be used as a menu entry.
   *  @param l  locale
   *  @return menu entry string
   */
  public String getMenuString(Locale l)
  {
    String str = getString(l, I18n.SUFFIX_TEXT);
    return str == null  ?  getLabelString(l)  :  str;
  }

  /**
   *  Get the basic i18n label tag.
   *  @return label tag
   */
  public String getBaseTag()
  {
    return baseTag;
  }

  /**
   *  Get a localized text for a tag which is the result of concatening the basic label tag with
   *  the tag extension.
   *  @param locale         locale
   *  @param tagExtension   tag extension
   *  @return localized string or <code>null</code> if the resulting tag is undefined
   */
  protected String getString(Locale locale, String tagExtension)
  {
    try {
      return I18n.getString(baseTag+tagExtension, locale);
    } catch (MissingResourceException e) {
      return null;
    }
  }
}
