// ============================================================================
// File:               $File$
//
// Project:
//
// Purpose:
//
// Author:             Rammi
//
// Copyright Notice:   (c) 1999-2006  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date: 2006-02-01 13:48:49 +0100 (Mi, 01 Feb 2006) $
//
// History:	       $Log$
//=============================================================================

package de.caff.util.debug;

import javax.swing.*;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

/**
 *  A panel with Checkboxes allowing to switch on/off global debug levels
 *
 *  @author Rammi
 */
public class DebugLevelSwitchBoard
        extends JPanel
        implements Debug.ModeChangeListener, DebugConstants
{
  private JCheckBox      _traceCB;
  private JCheckBox      _messageCB;
  private JCheckBox      _warningCB;
  private JCheckBox      _errorCB;
  private JCheckBox      _fatalCB;
  private JCheckBox      _logCB;
  private JCheckBox      _assertCB;
  private JCheckBox      _stdoutCB;
  private JCheckBox      _stderrCB;

  public DebugLevelSwitchBoard() {
    setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));

    _traceCB = new JCheckBox("Capture trace messages", Debug.getTraceMode());
    _traceCB.addItemListener(new ItemListener() {
      public void itemStateChanged(ItemEvent e) {
	Debug.setTraceMode(e.getStateChange() == ItemEvent.SELECTED);
      }
    });
    _traceCB.setToolTipText("Toggles the global setting for trace debug messages.");
    add(_traceCB);
      
    _messageCB = new JCheckBox("Capture standard messages", Debug.getStandardMode());
    _messageCB.addItemListener(new ItemListener() {
      public void itemStateChanged(ItemEvent e) {
	Debug.setStandardMode(e.getStateChange() == ItemEvent.SELECTED);
      }
    });
    _messageCB.setToolTipText("Toggles the global setting for standard debug messages.");
    add(_messageCB);

    _warningCB = new JCheckBox("Capture warnings", Debug.getWarningMode());
    _warningCB.addItemListener(new ItemListener() {
      public void itemStateChanged(ItemEvent e) {
	Debug.setWarningMode(e.getStateChange() == ItemEvent.SELECTED);
      }
    });
    _warningCB.setToolTipText("Toggles the global setting for warning debug messages.");
    add(_warningCB);

    _errorCB = new JCheckBox("Capture error messages", Debug.getErrorMode());
    _errorCB.addItemListener(new ItemListener() {
      public void itemStateChanged(ItemEvent e) {
	Debug.setErrorMode(e.getStateChange() == ItemEvent.SELECTED);
      }
    });
    _errorCB.setToolTipText("Toggles the global setting for error debug messages.");
    add(_errorCB);

    _fatalCB = new JCheckBox("Capture fatal error messages", Debug.getFatalMode());
    _fatalCB.addItemListener(new ItemListener() {
      public void itemStateChanged(ItemEvent e) {
	Debug.setFatalMode(e.getStateChange() == ItemEvent.SELECTED);
      }
    });
    _fatalCB.setToolTipText("Toggles the global setting for fatal error debug messages.");
    add(_fatalCB);

    _logCB = new JCheckBox("Capture logging messages", Debug.getLogMode());
    _logCB.addItemListener(new ItemListener() {
      public void itemStateChanged(ItemEvent e) {
	Debug.setLogMode(e.getStateChange() == ItemEvent.SELECTED);
      }
    });
    _logCB.setToolTipText("Toggles the global setting for logging messages.");
    add(_logCB);

    _assertCB = new JCheckBox("Capture failed assertions", Debug.getAssertionMode());
    _assertCB.addItemListener(new ItemListener() {
      public void itemStateChanged(ItemEvent e) {
	Debug.setAssertionMode(e.getStateChange() == ItemEvent.SELECTED);
      }
    });
    _assertCB.setToolTipText("Toggles the global setting for failed assertion messages.");
    add(_assertCB);
      
    _stdoutCB = new JCheckBox("Capture stdout", Debug.getStdoutCaptureMode());
    _stdoutCB.addItemListener(new ItemListener() {
      public void itemStateChanged(ItemEvent e) {
	Debug.setStdoutCaptureMode(e.getStateChange() == ItemEvent.SELECTED);
      }
    });
    _stdoutCB.setToolTipText("If set, messages to stdout are shown as standard messages");
    add(_stdoutCB);
      
    _stderrCB = new JCheckBox("Capture stderr", Debug.getStderrCaptureMode());
    _stderrCB.addItemListener(new ItemListener() {
      public void itemStateChanged(ItemEvent e) {
	Debug.setStderrCaptureMode(e.getStateChange() == ItemEvent.SELECTED);
      }
    });
    _stderrCB.setToolTipText("If set, messages to stderr are shown as error messages");
    add(_stderrCB);


    Debug.addModeChangeListener(this);
  }

  /**
   *  The state of a debug mode is changed.
   *  @param  modeID  mode number
   *  @param  state   new state
   */
  public void modeChanged(int modeID, boolean state) {
    final int     id = modeID;
    final boolean st = state;

    SwingUtilities.invokeLater(new Runnable() {
      public void run() {
	switch (id) {
	case TRACE:
	  _traceCB.setSelected(st);
	  break;
	  
	case MESSAGE:
	  _messageCB.setSelected(st);
	  break;

	case WARNING:
	  _warningCB.setSelected(st);
	  break;

	case DebugConstants.ERROR:
	  _errorCB.setSelected(st);
	  break;

	case FATAL:
	  _fatalCB.setSelected(st);
	  break;

	case LOG:
	  _logCB.setSelected(st);
	  break;
	  
	case ASSERT:
	  _assertCB.setSelected(st);
	  break;
	}
      }
    });
  }

  /**
   *  The state of the capturing of stdout is changed.
   *  @param state  new state
   */
  public void stdoutCaptureChanged(boolean state) {
    final boolean st = state;
    
    SwingUtilities.invokeLater(new Runnable() {
      public void run() {
	_stdoutCB.setSelected(st);
      }
    });
  }

  /**
   *  The state of the capturing of stderr is changed.
   *  @param state  new state
   */
  public void stderrCaptureChanged(boolean state) {
    final boolean st = state;
    
    SwingUtilities.invokeLater(new Runnable() {
      public void run() {
	_stderrCB.setSelected(st);
      }
    });
  }


}
