// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2008  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.asteroid;

/**
 *  A simple property of a game object.
 *
 *  This class is part of a solution for a
 *  <a href="http://www.heise.de/ct/creativ/08/02/details/">competition by the German computer magazine c't</a>.
 */
public class Property<T>
{
  /** The property name. */
  private final String name;
  /** The property value. */
  private final T value;

  /**
   *  Create property.
   *  @param name   property name
   *  @param value  property value
   */
  public Property(String name, T value)
  {
    this.name = name;
    this.value = value;
  }

  /**
   *  Get the property name.
   *  @return property name
   */
  public String getName()
  {
    return name;
  }

  /**
   *  Get the property value.
   *  @return property value
   */
  public T getValue()
  {
    return value;
  }

  /**
   *  Get the value as a string.
   *  @return value string
   */
  public String getValueString()
  {
    return value.toString();
  }

  /**
   * Returns a string representation of the object.
   *
   * @return a string representation of the object.
   */
  @Override
  public String toString()
  {
    return String.format("%s->'%s'", name, getValueString());
  }
}
