// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2008  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.asteroid;

/**
 *  Provider of information when pings where sent with a key datagram.
 */
public interface PingKeyProvider
{
  /**
   *  Get the buttons sent with a given ping, looking backwards from a given frame.
   *  @param frameNr frame counter
   *  @param ping    ping
   *  @return buttons sent with a given ping
   */
  int getKeysForPing(int frameNr, int ping);

  /**
   *  Get the timestamp when a given ping was send, looking backwards from a given frame.
   *  @param frameNr frame counter
   *  @param ping    ping
   *  @return timestamp when the ping was sent, or <code>0L</code> if the info is not longer available
   */
  long getTimestampForPing(int frameNr, int ping);

  /**
   *  Is information about the given ping still known, looking backwards from a given frame?
   *  @param frameNr frame counter
   *  @param ping    ping
   *  @return the answer
   */
  boolean isStillKnown(int frameNr, int ping);
}
