/*
 * Decompiled with CFR 0.152.
 */
package de.wens02;

import de.wens02.AsteroidApp;
import de.wens02.MovingObject;
import de.wens02.Target;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Vector;

public class Shot
extends MovingObject {
    protected static final int MAX_LIFE = 72;
    protected static final int MIN_LIFE = 69;
    protected static int mod4_offset = 0;
    private static boolean measured = false;
    protected boolean saucer = false;
    protected boolean killing = false;
    protected int winkelbyte = 0;
    protected Target target = null;
    protected int max_remaining_frames;
    protected int calc_remaining_frames = Shot.getLifeSpan(-2);

    public Shot(int x, int y) {
        super(x, y, 5, 0);
        this.max_remaining_frames = Shot.getLifeSpan(-2);
    }

    public static void setLifeSpanOffset(int frame_mod4, int lifespan) {
        mod4_offset = (4 + (72 - lifespan) - frame_mod4) % 4;
        measured = true;
    }

    public static int getLifeSpan() {
        if (!measured) {
            return 69;
        }
        return 72 - (AsteroidApp.frame_cnt + mod4_offset) % 4;
    }

    public static int getLifeSpan(int frameHorizon) {
        if (!measured) {
            return 69;
        }
        return 72 - (AsteroidApp.frame_cnt + frameHorizon + mod4_offset) % 4;
    }

    public int getPixelSize() {
        return 4;
    }

    public int getSquaredPixelSize() {
        return 16;
    }

    @Override
    public void update(Point p) {
        super.update(p);
        if (this.calc_remaining_frames > 0) {
            --this.calc_remaining_frames;
        }
        if (this.max_remaining_frames > 0) {
            --this.max_remaining_frames;
        }
    }

    public void paint(Graphics g) {
        int d = this.killing ? 10 : 4;
        g.setColor(this.killing ? Color.red : Color.lightGray);
        g.fillOval(this.x - d / 2, 1024 - this.y - d / 2, d, d);
        if (this.dx != 0.0 || this.dy != 0.0) {
            int xn = (int)((double)this.x + 20.0 * this.dx);
            int yn = (int)((double)this.y + 20.0 * this.dy);
            g.drawLine(this.x, 1024 - this.y, xn, 1024 - yn);
        }
        if (this.projected_frames > 0) {
            g.drawOval(this.projected_x - d / 2, 1024 - this.projected_y - d / 2, d, d);
        }
    }

    public static Shot FindShot(Vector<Shot> sv, Point p) {
        Shot best = null;
        double best_dist = 144.0;
        for (Shot shot : sv) {
            double dist = shot.getSquaredTorusDistance(p, 1);
            if (!(dist < best_dist)) continue;
            best = shot;
            best_dist = dist;
        }
        if (best != null) {
            sv.remove(best);
            best.update(p);
        }
        return best;
    }
}

