/*
 * Decompiled with CFR 0.152.
 */
package de.wens02;

import de.wens02.Asteroid;
import de.wens02.AsteroidApp;
import de.wens02.Config;
import de.wens02.Debug;
import de.wens02.Log;
import de.wens02.MovingObject;
import de.wens02.Shot;
import de.wens02.Target;
import de.wens02.UFO;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Vector;

public class Ship
extends MovingObject {
    private static boolean useJNIMethods = true;
    protected int x2 = 0;
    protected int y2 = 0;
    protected boolean visible = false;
    public static boolean winkelbyte_resync;
    public static int winkelbyte;
    Vector<Integer> possiblePosition = new Vector();
    protected static Vector<Shot> shots;
    private Point lPoint = new Point(0, 0);
    private Point rPoint = new Point(0, 0);
    private int[] ship_dx = new int[8];
    private int[] ship_dy = new int[8];
    private int ship_di = 0;
    public static double[] shot_dist;
    public static double[] shot_alpha;
    public static int[][] shot_offset_x;
    public static int[][] shot_offset_y;
    public static short[][] shot_offset_norm_x;
    public static short[][] shot_offset_norm_y;
    public static int[][] shot_origin;
    public static int[][] ship_delta;
    public static double[][] shot_delta;
    public static double[][] shot_delta_tmp;

    static {
        System.loadLibrary("ship");
        winkelbyte_resync = false;
        winkelbyte = 0;
        shots = new Vector();
        shot_dist = new double[256];
        shot_alpha = new double[256];
        shot_offset_x = new int[256][74];
        shot_offset_y = new int[256][74];
        shot_offset_norm_x = new short[256][74];
        shot_offset_norm_y = new short[256][74];
        shot_origin = new int[256][2];
        ship_delta = new int[256][2];
        shot_delta = new double[256][2];
        shot_delta_tmp = new double[][]{{7.875, 0.0, 1536.0, 0.0, 19.0, 0.0}, {7.875, 0.5, 1536.0, 0.0, 19.0, 1.0}, {7.875, 1.125, 1528.0, 152.0, 19.0, 2.0}, {7.75, 1.75, 1504.0, 296.0, 19.0, 4.0}, {7.625, 2.25, 1472.0, 440.0, 19.0, 5.0}, {7.375, 2.875, 1472.0, 440.0, 18.0, 7.0}, {7.125, 3.375, 1416.0, 584.0, 17.0, 8.0}, {6.875, 3.875, 1360.0, 720.0, 17.0, 9.0}, {6.625, 4.375, 1280.0, 856.0, 16.0, 10.0}, {6.25, 4.875, 1280.0, 856.0, 15.0, 12.0}, {5.875, 5.25, 1192.0, 976.0, 14.0, 13.0}, {5.5, 5.75, 1088.0, 1088.0, 13.0, 14.0}, {5.0, 6.125, 976.0, 1192.0, 12.0, 15.0}, {4.5, 6.5, 976.0, 1192.0, 11.0, 16.0}, {4.0, 6.75, 856.0, 1280.0, 10.0, 16.0}, {3.5, 7.0, 720.0, 1360.0, 8.0, 17.0}, {3.0, 7.25, 584.0, 1416.0, 7.0, 18.0}, {2.5, 7.5, 584.0, 1416.0, 6.0, 18.0}, {1.875, 7.625, 440.0, 1472.0, 4.0, 19.0}, {1.375, 7.75, 296.0, 1504.0, 3.0, 19.0}, {0.75, 7.875, 152.0, 1528.0, 1.0, 19.0}, {0.125, 7.875, 152.0, 1528.0, 0.0, 19.0}, {-0.375, 7.875, -152.0, 1528.0, -1.0, 19.0}, {-1.0, 7.875, -296.0, 1504.0, -3.0, 19.0}, {-1.625, 7.75, -296.0, 1504.0, -5.0, 19.0}, {-2.125, 7.625, -440.0, 1472.0, -6.0, 19.0}, {-2.75, 7.5, -584.0, 1416.0, -7.0, 18.0}, {-3.25, 7.25, -720.0, 1360.0, -9.0, 18.0}, {-3.75, 7.0, -720.0, 1360.0, -10.0, 17.0}, {-4.25, 6.625, -856.0, 1280.0, -11.0, 16.0}, {-4.75, 6.375, -976.0, 1192.0, -12.0, 15.0}, {-5.25, 6.0, -1088.0, 1088.0, -14.0, 15.0}, {-5.625, 5.625, -1088.0, 1088.0, -15.0, 14.0}, {-6.0, 5.125, -1192.0, 976.0, -15.0, 12.0}, {-6.375, 4.75, -1280.0, 856.0, -16.0, 11.0}, {-6.75, 4.25, -1360.0, 720.0, -17.0, 10.0}, {-7.0, 3.75, -1360.0, 720.0, -18.0, 9.0}, {-7.25, 3.125, -1416.0, 584.0, -19.0, 7.0}, {-7.5, 2.625, -1472.0, 440.0, -19.0, 6.0}, {-7.625, 2.125, -1504.0, 296.0, -20.0, 5.0}, {-7.875, 1.5, -1504.0, 296.0, -20.0, 3.0}, {-7.875, 1.0, -1528.0, 152.0, -20.0, 2.0}, {-8.0, 0.375, -1536.0, 0.0, -20.0, 0.0}, {-8.0, -0.25, -1536.0, 0.0, -20.0, -1.0}, {-7.875, -0.75, -1528.0, -152.0, -20.0, -2.0}, {-7.875, -1.375, -1528.0, -152.0, -20.0, -4.0}, {-7.75, -2.0, -1504.0, -296.0, -20.0, -5.0}, {-7.625, -2.5, -1472.0, -440.0, -20.0, -7.0}, {-7.375, -3.125, -1416.0, -584.0, -19.0, -8.0}, {-7.125, -3.625, -1416.0, -584.0, -18.0, -10.0}, {-6.875, -4.125, -1360.0, -720.0, -18.0, -11.0}, {-6.5, -4.625, -1280.0, -856.0, -17.0, -12.0}, {-6.125, -5.125, -1192.0, -976.0, -16.0, -13.0}, {-5.75, -5.5, -1192.0, -976.0, -15.0, -14.0}, {-5.375, -5.875, -1088.0, -1088.0, -14.0, -15.0}, {-4.875, -6.25, -976.0, -1192.0, -13.0, -16.0}, {-4.5, -6.625, -856.0, -1280.0, -12.0, -17.0}, {-4.0, -7.0, -856.0, -1280.0, -10.0, -18.0}, {-3.375, -7.25, -720.0, -1360.0, -9.0, -19.0}, {-2.875, -7.375, -584.0, -1416.0, -8.0, -19.0}, {-2.375, -7.625, -440.0, -1472.0, -6.0, -20.0}, {-1.75, -7.75, -440.0, -1472.0, -5.0, -20.0}, {-1.25, -7.875, -296.0, -1504.0, -4.0, -20.0}, {-0.625, -8.0, -152.0, -1528.0, -2.0, -20.0}, {0.0, -8.0, 0.0, -1536.0, 0.0, -20.0}, {0.5, -8.0, 152.0, -1528.0, 1.0, -20.0}, {1.125, -7.875, 296.0, -1504.0, 2.0, -20.0}, {1.75, -7.75, 440.0, -1472.0, 4.0, -20.0}, {2.25, -7.625, 440.0, -1472.0, 5.0, -20.0}, {2.875, -7.375, 584.0, -1416.0, 7.0, -19.0}, {3.375, -7.25, 720.0, -1360.0, 8.0, -19.0}, {3.875, -7.0, 856.0, -1280.0, 9.0, -18.0}, {4.375, -6.625, 856.0, -1280.0, 10.0, -17.0}, {4.875, -6.25, 976.0, -1192.0, 12.0, -16.0}, {5.25, -5.875, 1088.0, -1088.0, 13.0, -15.0}, {5.75, -5.5, 1192.0, -976.0, 14.0, -14.0}, {6.125, -5.125, 1192.0, -976.0, 15.0, -13.0}, {6.5, -4.625, 1280.0, -856.0, 16.0, -12.0}, {6.75, -4.125, 1360.0, -720.0, 16.0, -11.0}, {7.0, -3.625, 1416.0, -584.0, 17.0, -10.0}, {7.25, -3.125, 1416.0, -584.0, 18.0, -8.0}, {7.5, -2.5, 1472.0, -440.0, 18.0, -7.0}, {7.625, -2.0, 1504.0, -296.0, 19.0, -5.0}, {7.75, -1.375, 1528.0, -152.0, 19.0, -4.0}, {7.875, -0.75, 1528.0, -152.0, 19.0, -2.0}, {7.875, -0.25, 1536.0, 0.0, 19.0, -1.0}, {7.875, 0.375, 1536.0, 0.0, 19.0, 0.0}, {7.875, 1.0, 1528.0, 152.0, 19.0, 2.0}, {7.75, 1.5, 1504.0, 296.0, 19.0, 3.0}, {7.625, 2.125, 1504.0, 296.0, 19.0, 5.0}, {7.5, 2.625, 1472.0, 440.0, 18.0, 6.0}, {7.25, 3.125, 1416.0, 584.0, 18.0, 7.0}, {7.0, 3.75, 1360.0, 720.0, 17.0, 9.0}, {6.625, 4.25, 1360.0, 720.0, 16.0, 10.0}, {6.375, 4.75, 1280.0, 856.0, 15.0, 11.0}, {6.0, 5.125, 1192.0, 976.0, 15.0, 12.0}, {5.625, 5.625, 1088.0, 1088.0, 14.0, 14.0}, {5.125, 6.0, 1088.0, 1088.0, 12.0, 15.0}, {4.75, 6.375, 976.0, 1192.0, 11.0, 15.0}, {4.25, 6.625, 856.0, 1280.0, 10.0, 16.0}, {3.75, 7.0, 720.0, 1360.0, 9.0, 17.0}, {3.125, 7.25, 720.0, 1360.0, 7.0, 18.0}, {2.625, 7.5, 584.0, 1416.0, 6.0, 18.0}, {2.125, 7.625, 440.0, 1472.0, 5.0, 19.0}, {1.5, 7.75, 296.0, 1504.0, 3.0, 19.0}, {1.0, 7.875, 296.0, 1504.0, 2.0, 19.0}, {0.375, 7.875, 152.0, 1528.0, 0.0, 19.0}, {-0.25, 7.875, -152.0, 1528.0, -1.0, 19.0}, {-0.75, 7.875, -152.0, 1528.0, -2.0, 19.0}, {-1.375, 7.75, -296.0, 1504.0, -4.0, 19.0}, {-2.0, 7.625, -440.0, 1472.0, -5.0, 19.0}, {-2.5, 7.5, -584.0, 1416.0, -7.0, 18.0}, {-3.125, 7.25, -584.0, 1416.0, -8.0, 18.0}, {-3.625, 7.0, -720.0, 1360.0, -10.0, 17.0}, {-4.125, 6.75, -856.0, 1280.0, -11.0, 16.0}, {-4.625, 6.5, -976.0, 1192.0, -12.0, 16.0}, {-5.125, 6.125, -976.0, 1192.0, -13.0, 15.0}, {-5.5, 5.75, -1088.0, 1088.0, -14.0, 14.0}, {-5.875, 5.25, -1192.0, 976.0, -15.0, 13.0}, {-6.25, 4.875, -1280.0, 856.0, -16.0, 12.0}, {-6.625, 4.375, -1280.0, 856.0, -17.0, 10.0}, {-7.0, 3.875, -1360.0, 720.0, -18.0, 9.0}, {-7.25, 3.375, -1416.0, 584.0, -19.0, 8.0}, {-7.375, 2.875, -1472.0, 440.0, -19.0, 7.0}, {-7.625, 2.25, -1472.0, 440.0, -20.0, 5.0}, {-7.75, 1.75, -1504.0, 296.0, -20.0, 4.0}, {-7.875, 1.125, -1528.0, 152.0, -20.0, 2.0}, {-8.0, 0.5, -1536.0, 0.0, -20.0, 1.0}, {-8.0, 0.0, -1536.0, 0.0, -20.0, 0.0}, {-8.0, -0.625, -1536.0, 0.0, -20.0, -2.0}, {-7.875, -1.25, -1528.0, -152.0, -20.0, -4.0}, {-7.75, -1.75, -1504.0, -296.0, -20.0, -5.0}, {-7.625, -2.375, -1472.0, -440.0, -20.0, -6.0}, {-7.375, -2.875, -1472.0, -440.0, -19.0, -8.0}, {-7.25, -3.375, -1416.0, -584.0, -19.0, -9.0}, {-7.0, -4.0, -1360.0, -720.0, -18.0, -10.0}, {-6.625, -4.5, -1280.0, -856.0, -17.0, -12.0}, {-6.25, -4.875, -1280.0, -856.0, -16.0, -13.0}, {-5.875, -5.375, -1192.0, -976.0, -15.0, -14.0}, {-5.5, -5.75, -1088.0, -1088.0, -14.0, -15.0}, {-5.125, -6.125, -976.0, -1192.0, -13.0, -16.0}, {-4.625, -6.5, -976.0, -1192.0, -12.0, -17.0}, {-4.125, -6.875, -856.0, -1280.0, -11.0, -18.0}, {-3.625, -7.125, -720.0, -1360.0, -10.0, -18.0}, {-3.125, -7.375, -584.0, -1416.0, -8.0, -19.0}, {-2.5, -7.625, -584.0, -1416.0, -7.0, -20.0}, {-2.0, -7.75, -440.0, -1472.0, -5.0, -20.0}, {-1.375, -7.875, -296.0, -1504.0, -4.0, -20.0}, {-0.75, -7.875, -152.0, -1528.0, -2.0, -20.0}, {-0.25, -8.0, -152.0, -1528.0, -1.0, -20.0}, {0.375, -8.0, 152.0, -1528.0, 0.0, -20.0}, {1.0, -7.875, 296.0, -1504.0, 2.0, -20.0}, {1.5, -7.875, 296.0, -1504.0, 3.0, -20.0}, {2.125, -7.625, 440.0, -1472.0, 5.0, -20.0}, {2.625, -7.5, 584.0, -1416.0, 6.0, -19.0}, {3.125, -7.25, 720.0, -1360.0, 7.0, -19.0}, {3.75, -7.0, 720.0, -1360.0, 9.0, -18.0}, {4.25, -6.75, 856.0, -1280.0, 10.0, -17.0}, {4.75, -6.375, 976.0, -1192.0, 11.0, -16.0}, {5.125, -6.0, 1088.0, -1088.0, 12.0, -15.0}, {5.625, -5.625, 1088.0, -1088.0, 14.0, -15.0}, {6.0, -5.25, 1192.0, -976.0, 15.0, -14.0}, {6.375, -4.75, 1280.0, -856.0, 15.0, -12.0}, {6.625, -4.25, 1360.0, -720.0, 16.0, -11.0}, {7.0, -3.75, 1360.0, -720.0, 17.0, -10.0}, {7.25, -3.25, 1416.0, -584.0, 18.0, -9.0}, {7.5, -2.75, 1472.0, -440.0, 18.0, -7.0}, {7.625, -2.125, 1504.0, -296.0, 19.0, -6.0}, {7.75, -1.625, 1504.0, -296.0, 19.0, -5.0}, {7.875, -1.0, 1528.0, -152.0, 19.0, -3.0}, {7.875, -0.375, 1536.0, 0.0, 19.0, -1.0}, {7.875, 0.125, 1536.0, 0.0, 19.0, 0.0}, {7.875, 0.75, 1528.0, 152.0, 19.0, 1.0}, {7.75, 1.375, 1528.0, 152.0, 19.0, 3.0}, {7.625, 1.875, 1504.0, 296.0, 19.0, 4.0}, {7.5, 2.5, 1472.0, 440.0, 18.0, 6.0}, {7.25, 3.0, 1416.0, 584.0, 18.0, 7.0}, {7.0, 3.5, 1416.0, 584.0, 17.0, 8.0}, {6.75, 4.0, 1360.0, 720.0, 16.0, 10.0}, {6.5, 4.5, 1280.0, 856.0, 16.0, 11.0}, {6.125, 5.0, 1192.0, 976.0, 15.0, 12.0}, {5.75, 5.5, 1192.0, 976.0, 14.0, 13.0}, {5.25, 5.875, 1088.0, 1088.0, 13.0, 14.0}, {4.875, 6.25, 976.0, 1192.0, 12.0, 15.0}, {4.375, 6.625, 856.0, 1280.0, 10.0, 16.0}, {3.875, 6.875, 856.0, 1280.0, 9.0, 17.0}, {3.375, 7.125, 720.0, 1360.0, 8.0, 17.0}, {2.875, 7.375, 584.0, 1416.0, 7.0, 18.0}, {2.25, 7.625, 440.0, 1472.0, 5.0, 19.0}, {1.75, 7.75, 440.0, 1472.0, 4.0, 19.0}, {1.125, 7.875, 296.0, 1504.0, 2.0, 19.0}, {0.5, 7.875, 152.0, 1528.0, 1.0, 19.0}, {0.0, 7.875, 0.0, 1536.0, 0.0, 19.0}, {-0.625, 7.875, -152.0, 1528.0, -2.0, 19.0}, {-1.25, 7.875, -296.0, 1504.0, -4.0, 19.0}, {-1.75, 7.75, -440.0, 1472.0, -5.0, 19.0}, {-2.375, 7.625, -440.0, 1472.0, -6.0, 19.0}, {-2.875, 7.375, -584.0, 1416.0, -8.0, 18.0}, {-3.375, 7.125, -720.0, 1360.0, -9.0, 17.0}, {-4.0, 6.875, -856.0, 1280.0, -10.0, 17.0}, {-4.5, 6.625, -856.0, 1280.0, -12.0, 16.0}, {-4.875, 6.25, -976.0, 1192.0, -13.0, 15.0}, {-5.375, 5.875, -1088.0, 1088.0, -14.0, 14.0}, {-5.75, 5.5, -1192.0, 976.0, -15.0, 13.0}, {-6.125, 5.0, -1192.0, 976.0, -16.0, 12.0}, {-6.5, 4.5, -1280.0, 856.0, -17.0, 11.0}, {-6.875, 4.0, -1360.0, 720.0, -18.0, 10.0}, {-7.125, 3.5, -1416.0, 584.0, -18.0, 8.0}, {-7.375, 3.0, -1416.0, 584.0, -19.0, 7.0}, {-7.625, 2.5, -1472.0, 440.0, -20.0, 6.0}, {-7.75, 1.875, -1504.0, 296.0, -20.0, 4.0}, {-7.875, 1.375, -1528.0, 152.0, -20.0, 3.0}, {-7.875, 0.75, -1528.0, 152.0, -20.0, 1.0}, {-8.0, 0.125, -1536.0, 0.0, -20.0, 0.0}, {-8.0, -0.375, -1536.0, 0.0, -20.0, -1.0}, {-7.875, -1.0, -1528.0, -152.0, -20.0, -3.0}, {-7.875, -1.625, -1504.0, -296.0, -20.0, -5.0}, {-7.625, -2.125, -1504.0, -296.0, -20.0, -6.0}, {-7.5, -2.75, -1472.0, -440.0, -19.0, -7.0}, {-7.25, -3.25, -1416.0, -584.0, -19.0, -9.0}, {-7.0, -3.75, -1360.0, -720.0, -18.0, -10.0}, {-6.75, -4.25, -1360.0, -720.0, -17.0, -11.0}, {-6.375, -4.75, -1280.0, -856.0, -16.0, -12.0}, {-6.0, -5.25, -1192.0, -976.0, -15.0, -14.0}, {-5.625, -5.625, -1088.0, -1088.0, -15.0, -15.0}, {-5.25, -6.0, -1088.0, -1088.0, -14.0, -15.0}, {-4.75, -6.375, -976.0, -1192.0, -12.0, -16.0}, {-4.25, -6.75, -856.0, -1280.0, -11.0, -17.0}, {-3.75, -7.0, -720.0, -1360.0, -10.0, -18.0}, {-3.25, -7.25, -720.0, -1360.0, -9.0, -19.0}, {-2.75, -7.5, -584.0, -1416.0, -7.0, -19.0}, {-2.125, -7.625, -440.0, -1472.0, -6.0, -20.0}, {-1.625, -7.875, -296.0, -1504.0, -5.0, -20.0}, {-1.0, -7.875, -296.0, -1504.0, -3.0, -20.0}, {-0.375, -8.0, -152.0, -1528.0, -1.0, -20.0}, {0.125, -8.0, 152.0, -1528.0, 0.0, -20.0}, {0.75, -7.875, 152.0, -1528.0, 1.0, -20.0}, {1.375, -7.875, 296.0, -1504.0, 3.0, -20.0}, {1.875, -7.75, 440.0, -1472.0, 4.0, -20.0}, {2.5, -7.625, 584.0, -1416.0, 6.0, -20.0}, {3.0, -7.375, 584.0, -1416.0, 7.0, -19.0}, {3.5, -7.125, 720.0, -1360.0, 8.0, -18.0}, {4.0, -6.875, 856.0, -1280.0, 10.0, -18.0}, {4.5, -6.5, 976.0, -1192.0, 11.0, -17.0}, {5.0, -6.125, 976.0, -1192.0, 12.0, -16.0}, {5.5, -5.75, 1088.0, -1088.0, 13.0, -15.0}, {5.875, -5.375, 1192.0, -976.0, 14.0, -14.0}, {6.25, -4.875, 1280.0, -856.0, 15.0, -13.0}, {6.625, -4.5, 1280.0, -856.0, 16.0, -12.0}, {6.875, -4.0, 1360.0, -720.0, 17.0, -10.0}, {7.125, -3.375, 1416.0, -584.0, 17.0, -9.0}, {7.375, -2.875, 1472.0, -440.0, 18.0, -8.0}, {7.625, -2.375, 1472.0, -440.0, 19.0, -6.0}, {7.75, -1.75, 1504.0, -296.0, 19.0, -5.0}, {7.875, -1.25, 1528.0, -152.0, 19.0, -4.0}, {7.875, -0.625, 1536.0, 0.0, 19.0, -2.0}};
    }

    public static native Target findBestTargetJNI(int var0, int var1, Vector<Target> var2, int var3, int var4, int var5, int var6, int var7);

    public Ship(int x, int y, int x2, int y2) {
        super(x, y, 10, 0);
        this.x2 = x2;
        this.y2 = y2;
        this.pixelSize = 25;
        this.squaredPixelSize = this.pixelSize * this.pixelSize;
        double shot_dist_min = 1000.0;
        double shot_dist_max = 0.0;
        double shot_dist_sum = 0.0;
        int wb = 0;
        while (wb < 256) {
            Ship.shot_delta[wb][0] = shot_delta_tmp[wb][0];
            Ship.shot_delta[wb][1] = shot_delta_tmp[wb][1];
            Ship.ship_delta[wb][0] = (int)shot_delta_tmp[wb][2];
            Ship.ship_delta[wb][1] = (int)shot_delta_tmp[wb][3];
            Ship.shot_origin[wb][0] = (int)shot_delta_tmp[wb][4];
            Ship.shot_origin[wb][1] = (int)shot_delta_tmp[wb][5];
            int f = 2;
            while (f < 74) {
                this.getShotPrediction(this.lPoint, f, wb);
                Ship.shot_offset_x[wb][f] = (short)(this.lPoint.x - x);
                Ship.shot_offset_y[wb][f] = (short)(this.lPoint.y - y);
                ++f;
            }
            double dx = shot_delta[wb][0];
            double dy = shot_delta[wb][1];
            Ship.shot_dist[wb] = Math.sqrt(dx * dx + dy * dy);
            Ship.shot_alpha[wb] = Math.toDegrees(Math.atan2(dx, dy));
            if (Debug.shot_dist) {
                if (shot_dist[wb] < shot_dist_min) {
                    shot_dist_min = shot_dist[wb];
                }
                if (shot_dist[wb] > shot_dist_max) {
                    shot_dist_max = shot_dist[wb];
                }
                shot_dist_sum += shot_dist[wb];
            }
            ++wb;
        }
        if (Debug.shot_dist) {
            System.out.println(String.format("Ship.shot: min,avg,max = %5f/%5f/%5f", shot_dist_min, shot_dist_sum / 256.0, shot_dist_max));
        }
    }

    public void setVisible(int vx, int vy) {
        this.visible = true;
        this.x = vx;
        this.y = vy;
        this.dx = 0.0;
        this.dy = 0.0;
        this.updateShotOffsets();
    }

    public void draw(Graphics g) {
        g.setColor(Color.blue);
        g.fillOval(this.x - 5, 1024 - this.y - 5, 10, 10);
        g.drawLine(this.x, 1024 - this.y, this.x + (this.x2 - this.x) / 50, 1024 - (this.y + (this.y2 - this.y) / 50));
        int svx = (int)((double)this.x + 100.0 * shot_delta[winkelbyte][0]);
        int svy = (int)((double)this.y + 100.0 * shot_delta[winkelbyte][1]);
        g.drawLine(this.x, 1024 - this.y, svx, 1024 - svy);
    }

    public void update(int x_new, int y_new) {
        this.ship_dx[this.ship_di] = x_new - this.x;
        this.ship_dy[this.ship_di] = y_new - this.y;
        this.ship_di = (this.ship_di + 1) % this.ship_dx.length;
        this.dx = 0.0;
        this.dy = 0.0;
        int i = 0;
        while (i < this.ship_dy.length) {
            this.dx += (double)this.ship_dx[i];
            this.dy += (double)this.ship_dy[i];
            ++i;
        }
        this.dx /= (double)this.ship_dx.length;
        this.dy /= (double)this.ship_dx.length;
        boolean changedPos = this.x != x_new || this.y != y_new;
        this.x = x_new;
        this.y = y_new;
        if (changedPos) {
            this.updateShotOffsets();
        }
    }

    private void updateShotOffsets() {
        Log.debug(String.format("Frame#%5d: ship.updateShotOffsets!", AsteroidApp.frame_cnt));
        int wb = 0;
        while (wb < 256) {
            int f = 2;
            while (f < 74) {
                int sx = this.x + shot_offset_x[wb][f];
                int sy = this.y + shot_offset_y[wb][f];
                if (sx < 0) {
                    sx += 1024;
                } else if (sx > 1023) {
                    sx -= 1024;
                }
                if (sy < 0) {
                    sy += 768;
                } else if (sy > 767) {
                    sy -= 768;
                }
                Ship.shot_offset_norm_x[wb][f] = (short)sx;
                Ship.shot_offset_norm_y[wb][f] = (short)sy;
                ++f;
            }
            ++wb;
        }
    }

    public void getShotPrediction(Point p, int frameHorizon, int wb) {
        int x0 = this.x + shot_origin[wb][0];
        int y0 = this.y + shot_origin[wb][1];
        p.x = x0 + (int)((double)(frameHorizon - 2) * shot_delta[wb][0] + (double)frameHorizon * this.dx);
        p.y = y0 + (int)((double)(frameHorizon - 2) * shot_delta[wb][1] + (double)frameHorizon * this.dy);
    }

    public void getShotPrediction(Point p, int frameHorizon) {
        this.getShotPrediction(p, frameHorizon, AsteroidApp.getWinkelbyte());
    }

    public static void addShot(Shot newShot) {
        int i = 0;
        while (i < shots.size()) {
            Shot shot = shots.elementAt(i);
            if (newShot.frames > shot.frames) {
                shots.insertElementAt(newShot, i);
                return;
            }
            ++i;
        }
        shots.add(newShot);
    }

    public int nextShotAvailable() {
        if (shots.size() < 4) {
            return 0;
        }
        int minFrame = 100;
        for (Shot shot : shots) {
            if (shot.calc_remaining_frames >= minFrame) continue;
            minFrame = shot.calc_remaining_frames;
        }
        return minFrame;
    }

    public boolean shotAvailable(int frameHorizon) {
        for (Shot shot : shots) {
            if (shot.calc_remaining_frames >= frameHorizon) continue;
            return true;
        }
        return false;
    }

    public void rotate(boolean left) {
        if (winkelbyte_resync) {
            this.rotate_resync(left);
        } else {
            int sdx = ship_delta[winkelbyte][0];
            int sdy = ship_delta[winkelbyte][1];
            if (sdx != this.x2 - this.x || sdy != this.y2 - this.y) {
                this.possiblePosition.clear();
                if (Debug.winkelbyte) {
                    Log.warn(String.format("Frame#%5d: WB1 resync [%5d,%5d]", AsteroidApp.frame_cnt, this.x2 - this.x, this.y2 - this.y));
                }
                int i = 0;
                while (i < 255) {
                    if (this.x2 - this.x == ship_delta[i][0] && this.y2 - this.y == ship_delta[i][1]) {
                        this.possiblePosition.add(i);
                    }
                    ++i;
                }
                winkelbyte_resync = true;
                this.rotate_resync(left);
            }
        }
        winkelbyte = left ? winkelbyte + 1 & 0xFF : winkelbyte + 255 & 0xFF;
    }

    public void rotate_resync(boolean left) {
        Vector<Integer> tmpVector = new Vector<Integer>();
        for (Integer i : this.possiblePosition) {
            int j;
            int n = j = left ? i + 1 & 0xFF : i + 255 & 0xFF;
            if (this.x2 - this.x != ship_delta[j][0] || this.y2 - this.y != ship_delta[j][1]) continue;
            tmpVector.add(i);
        }
        this.possiblePosition = tmpVector;
        if (this.possiblePosition.size() == 1) {
            winkelbyte_resync = false;
            winkelbyte = this.possiblePosition.elementAt(0);
            return;
        }
        if (this.possiblePosition.size() == 0) {
            int i = 0;
            while (i < 255) {
                int j;
                int n = j = left ? i + 1 & 0xFF : i + 255 & 0xFF;
                if (Debug.winkelbyte) {
                    System.err.println(String.format("Frame#%5d: WB2 resync [%5d,%5d]", AsteroidApp.frame_cnt, this.x2 - this.x, this.y2 - this.y));
                }
                if (this.x2 - this.x == ship_delta[j][0] && this.y2 - this.y == ship_delta[j][1]) {
                    this.possiblePosition.add(j);
                    winkelbyte = i;
                }
                ++i;
            }
        }
    }

    public Asteroid findNearestAsteroid(Vector<Asteroid> asteroids) {
        Asteroid nearest = null;
        for (Asteroid a : asteroids) {
            if (nearest != null && !(a.distance < nearest.distance)) continue;
            nearest = a;
        }
        return nearest;
    }

    public int findHardTargets(Vector<Target> result, Vector<Target> targets, int frameHorizon, int distance) {
        result.clear();
        int distanceSq = distance * distance;
        for (Target target : targets) {
            boolean near = false;
            int f = 1;
            while (!near && f < frameHorizon) {
                if (this.getSquaredTorusDistance(target, f) < (double)distanceSq) {
                    near = true;
                }
                f += 10;
            }
            if (near && !(target instanceof UFO) && (!(target instanceof Asteroid) || ((Asteroid)target).sizeType == 1)) continue;
            result.add(target);
        }
        return result.size();
    }

    public Target findCollisionTarget(Vector<Target> targets, int minFrame) {
        Target nearest_frame = null;
        int frame_min = minFrame;
        for (Target target : targets) {
            target.collision = false;
            target.collisionFrame = 1000;
            double collisionDist = (this.pixelSize + target.pixelSize) / 2;
            double squaredCollisionDist = collisionDist * collisionDist;
            int f = 1;
            while (f < minFrame) {
                double squaredDist = this.getSquaredTorusDistance(target, f);
                if (1 == f) {
                    target.distance = Math.sqrt(squaredDist);
                }
                if (squaredDist <= squaredCollisionDist) {
                    target.collision = true;
                    target.collisionFrame = Math.min(f, target.collisionFrame);
                    if (target.framewait == 0 && f < frame_min) {
                        nearest_frame = target;
                        frame_min = f;
                    }
                }
                ++f;
            }
        }
        return nearest_frame;
    }

    public int getMaxShots(Target target, int frameHorizon) {
        if (target instanceof UFO) {
            return 1;
        }
        Asteroid a = (Asteroid)target;
        if (1 == a.sizeType) {
            return 1;
        }
        if (2 == a.sizeType) {
            return this.getTorusDistance(a, frameHorizon) <= (double)Config.MediumMinDist[AsteroidApp.level_part] ? 3 : 2;
        }
        return this.getTorusDistance(a, frameHorizon) <= (double)Config.LargeMinDist[AsteroidApp.level_part] ? 3 : 2;
    }

    public void checkShotHits(Vector<Target> targets, int level_frame) {
        int nChecks = 0;
        for (Shot shot : shots) {
            boolean check;
            boolean bl = check = 1 == shot.frames || 9 == shot.frames || shot.frames > 60 && level_frame < 10;
            if (shot.target != null && shot.target.exploding) {
                if (Debug.shot_target) {
                    Log.debug(String.format("Frame#%5d: Shot Target explodiert, shot.lifetime=%2d", AsteroidApp.frame_cnt, shot.calc_remaining_frames));
                }
                check = true;
            }
            if (!check) continue;
            ++nChecks;
            boolean target_found = false;
            int f = 1;
            while (!target_found && f < shot.max_remaining_frames - 1) {
                for (Target target : targets) {
                    if (!target.shotWillHit(shot, f)) continue;
                    if (target.shot == null) {
                        target.shot = shot;
                        target.hit_in_frames = f;
                    }
                    if (target.maxShots() == 1 && target.shot != shot) {
                        if (!Debug.shot_target) continue;
                        Log.info(String.format("Frame#%5d: staggered Asteroid shot", AsteroidApp.frame_cnt));
                        continue;
                    }
                    ++target.shots_fired_at;
                    shot.target = target;
                    shot.calc_remaining_frames = f;
                    if (target.shots_fired_at >= this.getMaxShots(target, 0) || shot.frames >= 9) {
                        target.framewait = f + 2;
                    }
                    target_found = true;
                }
                ++f;
            }
            if (target_found) continue;
            if (shot.target != null) {
                shot.target.framewait = 0;
                shot.target.shot = null;
                shot.target = null;
            }
            shot.calc_remaining_frames = shot.max_remaining_frames;
        }
        if (Debug.shot_target && nChecks > 0) {
            Log.debug(String.format("Frame#%5d: %2d Shot Pr\u00fcfungen", AsteroidApp.frame_cnt, nChecks));
        }
    }

    public Target markTargetReachability(Target[] aBest, Vector<Target> targets, int maxKeyPress) {
        aBest[1] = null;
        Target target = aBest[0] = useJNIMethods ? Ship.findBestTargetJNI(this.x, this.y, targets, AsteroidApp.getWinkelbyte(), 0, maxKeyPress, Shot.getLifeSpan(), 0) : this.findBestTarget(targets, AsteroidApp.getWinkelbyte(), 0, maxKeyPress, 0);
        if (Debug.findTargetsJNI) {
            for (Target target2 : targets) {
                System.out.println(String.format("L%4d|%4d R%4d|%4d", target2.leftMinHitInFrames, target2.leftMinHitInFramesKeys, target2.rightMinHitInFrames, target2.rightMinHitInFramesKeys));
            }
            if (aBest[0] != null) {
                System.out.println(String.format("Frame#%5d: C++ tBest L%2d|%2d R%2d|%2d", AsteroidApp.frame_cnt, aBest[0].leftMinHitInFrames, aBest[0].leftMinHitInFramesKeys, aBest[0].rightMinHitInFrames, aBest[0].rightMinHitInFramesKeys));
            }
        }
        if (aBest[0] != null && aBest[0].leftMinHitInFramesKeys == 0) {
            targets.remove(aBest[0]);
            aBest[1] = useJNIMethods ? Ship.findBestTargetJNI(this.x, this.y, targets, AsteroidApp.getWinkelbyte(), 0, maxKeyPress, Shot.getLifeSpan(), 2) : this.findBestTarget(targets, AsteroidApp.getWinkelbyte(), 0, maxKeyPress, 2);
            targets.add(aBest[0]);
        }
        return aBest[0];
    }

    private Target findBestTarget(Vector<Target> targets, int wbStart, int minKeyPress, int maxKeyPress, int frameHorizon) {
        Target tBest = null;
        int tFrames = 1000;
        for (Target target : targets) {
            target.leftMinHitInFrames = 1000;
            target.leftMinHitInFramesKeys = 1000;
            target.rightMinHitInFrames = 1000;
            target.rightMinHitInFramesKeys = 1000;
        }
        int wb_left = wbStart;
        int wb_right = wbStart;
        int keypress = minKeyPress;
        while (keypress < maxKeyPress) {
            int maxShotFrame = keypress + 2 + Shot.getLifeSpan(frameHorizon + keypress) - 1;
            int f = keypress + 2;
            while (f < maxShotFrame) {
                if (f > tFrames) break;
                int fk = f - keypress;
                this.lPoint.x = shot_offset_norm_x[wb_left][fk];
                this.lPoint.y = shot_offset_norm_y[wb_left][fk];
                this.rPoint.x = shot_offset_norm_x[wb_right][fk];
                this.rPoint.y = shot_offset_norm_y[wb_right][fk];
                for (Target target : targets) {
                    if (target.shotWillHit(this.lPoint, frameHorizon + f)) {
                        if (f < target.leftMinHitInFrames) {
                            target.leftMinHitInFrames = f;
                            target.leftMinHitInFramesKeys = keypress;
                        }
                        if (tBest == null || target.leftMinHitInFrames < tFrames) {
                            tBest = target;
                            tFrames = target.leftMinHitInFrames;
                        }
                    }
                    if (!target.shotWillHit(this.rPoint, frameHorizon + f)) continue;
                    if (f < target.rightMinHitInFrames) {
                        target.rightMinHitInFrames = f;
                        target.rightMinHitInFramesKeys = keypress;
                    }
                    if (tBest != null && target.rightMinHitInFrames >= tFrames) continue;
                    tBest = target;
                    tFrames = target.rightMinHitInFrames;
                }
                ++f;
            }
            wb_left = wb_left + 1 & 0xFF;
            wb_right = wb_right + 255 & 0xFF;
            ++keypress;
        }
        if (tBest != null) {
            System.out.println(String.format("Frame#%5d: Java Best L%2d|%2d R%2d|%2d", AsteroidApp.frame_cnt, tBest.leftMinHitInFrames, tBest.leftMinHitInFramesKeys, tBest.rightMinHitInFrames, tBest.rightMinHitInFramesKeys));
        }
        return tBest;
    }

    public Target findTarget(Vector<Target> targets, int waitFrames) {
        int wb = AsteroidApp.getWinkelbyte();
        int maxShotFrames = 2 + Shot.getLifeSpan(waitFrames) - 1;
        int f = 2;
        while (f < maxShotFrames) {
            this.lPoint.x = this.x + shot_offset_x[wb][f];
            this.lPoint.y = this.y + shot_offset_y[wb][f];
            MovingObject.normalize(this.lPoint);
            for (Target target : targets) {
                if (!target.shotWillHit(this.lPoint, f + waitFrames)) continue;
                target.leftMinHitInFrames = f;
                target.rightMinHitInFrames = f;
                target.leftMinHitInFramesKeys = 0;
                target.rightMinHitInFramesKeys = 0;
                return target;
            }
            ++f;
        }
        return null;
    }

    protected byte moveToTarget(Target best, Target second) {
        if (best.leftMinHitInFramesKeys == 0) {
            return second != null ? this.moveToTarget(second, null) : (byte)0;
        }
        if (best.leftMinHitInFramesKeys < best.rightMinHitInFramesKeys) {
            return 16;
        }
        return 8;
    }
}

