/*
 * Decompiled with CFR 0.152.
 */
package de.wens02;

import de.caff.asteroid.analysis.DatagramDumper;
import de.wens02.Asteroid;
import de.wens02.Config;
import de.wens02.Debug;
import de.wens02.Log;
import de.wens02.MovingObject;
import de.wens02.MySQL;
import de.wens02.Ship;
import de.wens02.Shot;
import de.wens02.Target;
import de.wens02.Text;
import de.wens02.UFO;
import de.wens02.VectorObject;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class AsteroidApp {
    public static final byte KEY_HYPERSPACE = 1;
    public static final byte KEY_FIRE = 2;
    public static final byte KEY_THRUST = 4;
    public static final byte KEY_RIGHT = 8;
    public static final byte KEY_LEFT = 16;
    public static final byte KEY_START = 32;
    public static final int MAX_X = 1023;
    public static final int MAX_Y = 767;
    public static final int OFFSET_Y = 128;
    public static final int EXTENT_X = 1024;
    public static final int EXTENT_Y = 768;
    public static final int FRAMES_5MIN = 17999;
    public static int FRAME_INTERVAL = 60000;
    public static int MAX_FRAME_LOOKAHEAD = 65;
    public static boolean withMySQL = false;
    public static boolean withLog4j = false;
    public static boolean withDisplay = false;
    public static boolean withDumper = false;
    private static boolean withLatency1 = false;
    private DatagramDumper dumper = null;
    private boolean dumper_active = false;
    private Thread dumper_thread = null;
    private int game_id = 0;
    private DatagramSocket socket;
    private InetAddress address;
    private byte[] sendbuf;
    private byte[] rcvbuf;
    private byte last_frame;
    private static int my_ping = 0;
    private static int server_ping = 0;
    private DatagramPacket send_packet;
    private DatagramPacket rcv_packet;
    private static byte[] keys_send = new byte[256];
    private static int[] winkelbyte = new int[256];
    private MySQL sql;
    private Vector<Target> targets;
    private Vector<Target> tmpTargets;
    private Vector<Target> hardTargets;
    private Target tCollision;
    private Asteroid aNearest;
    private UFO ufo;
    private Ship ship;
    private StringBuffer textbuf;
    private Vector<Text> texts;
    private int prev_cnt_ast;
    private int curr_cnt_ast;
    private Vector<Asteroid> asteroids;
    private VectorObject[] vram_objects;
    private VectorObject[] vram_objects_new;
    private Vector<Shot> prev_shots;
    private Vector<Shot> shots;
    private Point tmpPoint;
    public static int frame_cnt = 0;
    public static int prev_latency = 0;
    public static int latency = 0;
    public static int norm_latency = 0;
    private int shots_fired;
    private int large_ast_hit;
    private int medium_ast_hit;
    private int small_ast_hit;
    private int large_ufo_hit;
    private int small_ufo_hit;
    private int level;
    private int level_shots;
    private int level_key_fire;
    private int level_ufos;
    private int level_startscore;
    private int level_startframe;
    private int level_waitframes;
    protected static int level_part = 0;
    private int score;
    private int scorewrap;
    private int highscore;
    private int ships_remain;
    private int warp_cnt;
    private boolean finishing;
    public JFrame frame;

    public AsteroidApp(String hostname) {
        byte[] byArray = new byte[8];
        byArray[0] = 99;
        byArray[1] = 116;
        byArray[2] = 109;
        byArray[3] = 97;
        byArray[4] = 109;
        byArray[5] = 101;
        this.sendbuf = byArray;
        this.rcvbuf = new byte[1026];
        this.last_frame = 0;
        this.send_packet = null;
        this.rcv_packet = null;
        this.sql = null;
        this.targets = new Vector(27);
        this.tmpTargets = new Vector(27);
        this.hardTargets = new Vector(27);
        this.tCollision = null;
        this.aNearest = null;
        this.ufo = new UFO(0, 0, 15, 2345);
        this.ship = new Ship(0, 0, 0, 0);
        this.textbuf = new StringBuffer(50);
        this.texts = new Vector();
        this.prev_cnt_ast = 0;
        this.curr_cnt_ast = 0;
        this.asteroids = new Vector(30);
        this.vram_objects = new VectorObject[27];
        this.vram_objects_new = new VectorObject[27];
        this.prev_shots = new Vector(10);
        this.shots = new Vector(10);
        this.tmpPoint = new Point();
        this.shots_fired = 0;
        this.large_ast_hit = 0;
        this.medium_ast_hit = 0;
        this.small_ast_hit = 0;
        this.large_ufo_hit = 0;
        this.small_ufo_hit = 0;
        this.level = 0;
        this.level_shots = 0;
        this.level_key_fire = 0;
        this.level_ufos = 0;
        this.level_startscore = 0;
        this.level_startframe = 0;
        this.level_waitframes = 0;
        this.score = 0;
        this.scorewrap = 0;
        this.highscore = 0;
        this.ships_remain = 0;
        this.warp_cnt = 0;
        this.finishing = false;
        this.frame = null;
        this.sql = new MySQL(withMySQL);
        Log.init(withLog4j);
        try {
            this.socket = new DatagramSocket();
            this.address = InetAddress.getByName(hostname);
            this.send_packet = new DatagramPacket(this.sendbuf, this.sendbuf.length, this.address, 1979);
            this.rcv_packet = new DatagramPacket(this.rcvbuf, this.rcvbuf.length);
            if (withLatency1) {
                this.socket.send(this.send_packet);
            }
        }
        catch (Exception e) {
            System.err.println("Exception: " + e);
            e.printStackTrace();
            System.exit(0);
        }
        int i = 0;
        while (i < this.vram_objects_new.length) {
            this.vram_objects_new[i] = new VectorObject(0, 0, 0, 0);
            ++i;
        }
        if (withDisplay) {
            this.frame = new JFrame("M.A.M.E. Asteroid Client"){

                @Override
                public void paint(Graphics g) {
                    try {
                        g.clearRect(0, 0, 1024, 1024);
                        g.drawRect(0, 128, 1023, 768);
                        for (Asteroid a : AsteroidApp.this.asteroids) {
                            if (a == null) continue;
                            g.setColor(Color.darkGray);
                            if (a == AsteroidApp.this.tCollision) {
                                g.setColor(Color.red);
                            }
                            a.paint((Graphics2D)g);
                        }
                        for (Shot shot : Ship.shots) {
                            g.setColor(Color.blue);
                            shot.paint(g);
                        }
                        for (Shot shot : UFO.shots) {
                            g.setColor(Color.orange);
                            shot.paint(g);
                        }
                        int i = 0;
                        while (i < AsteroidApp.this.texts.size()) {
                            Text d = (Text)AsteroidApp.this.texts.get(i);
                            g.drawString(d.d, d.x, 1024 - d.y);
                            ++i;
                        }
                        if (((AsteroidApp)AsteroidApp.this).ship.visible) {
                            AsteroidApp.this.ship.draw((Graphics2D)g);
                        }
                        if (((AsteroidApp)AsteroidApp.this).ufo.visible) {
                            AsteroidApp.this.ufo.paint((Graphics2D)g);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            this.frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    AsteroidApp.this.frame.dispose();
                    System.exit(0);
                }
            });
            this.frame.getContentPane().add(new JPanel());
            this.frame.setLocation(1520, 0);
            this.frame.setSize(1040, 1024);
            this.frame.setVisible(true);
            this.frame.repaint();
        }
    }

    public void startNewGame(boolean force) throws SQLException {
        if (force || frame_cnt > 1000) {
            this.game_id = this.sql.addGame();
        }
        this.finishing = false;
        frame_cnt = 0;
        this.scorewrap = 0;
        this.level = 0;
        this.shots_fired = 0;
        this.large_ast_hit = 0;
        this.medium_ast_hit = 0;
        this.small_ast_hit = 0;
        this.large_ufo_hit = 0;
        this.small_ufo_hit = 0;
        this.ships_remain = 0;
        this.warp_cnt = 0;
        if (this.dumper_thread != null) {
            this.dumper_thread.stop();
            this.dumper_thread = null;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd_HHmmss");
        String filename = df.format(new Date());
        if (this.game_id > 0) {
            filename = String.valueOf(filename) + String.format("_%4d", this.game_id);
        }
        try {
            if (withDumper) {
                this.dumper = new DatagramDumper(filename);
                this.dumper_thread = new Thread((Runnable)this.dumper, "dumper");
                this.dumper_thread.start();
                this.dumper_active = false;
            }
            Log.setFile(String.valueOf(filename) + ".log");
        }
        catch (IOException e) {
            System.err.println("Exception: " + e);
            System.exit(0);
        }
    }

    public int getRealScore() {
        int scorereal = this.scorewrap * 100000 + this.score;
        if (scorereal > this.highscore) {
            this.highscore = scorereal;
        }
        return scorereal;
    }

    public void updateScores(int new_score) {
        if (this.score > 98000 && new_score < this.score) {
            ++this.scorewrap;
        }
        int diff = new_score - this.score;
        while (diff >= 1000) {
            ++this.small_ufo_hit;
            diff -= 1000;
        }
        if (this.score < 10000 && diff >= 200) {
            ++this.large_ufo_hit;
            diff -= 200;
        }
        while (diff >= 100) {
            ++this.small_ast_hit;
            diff -= 100;
        }
        while (diff >= 50) {
            ++this.medium_ast_hit;
            diff -= 50;
        }
        while (diff >= 20) {
            ++this.large_ast_hit;
            diff -= 20;
        }
        this.score = new_score;
    }

    public static int byteToUnsigned(byte b) {
        return b < 0 ? b + 256 : b;
    }

    public static int getWinkelbyte() {
        int wb = winkelbyte[server_ping];
        int i = 1;
        while (i <= norm_latency) {
            if ((keys_send[server_ping + i & 0xFF] & 0x10) != 0) {
                ++wb;
            }
            if ((keys_send[server_ping + i & 0xFF] & 8) != 0) {
                --wb;
            }
            ++i;
        }
        return wb + 256 & 0xFF;
    }

    public byte send(byte command) throws SQLException {
        AsteroidApp.keys_send[AsteroidApp.my_ping] = command;
        try {
            this.sendbuf[6] = command;
            this.sendbuf[7] = (byte)my_ping;
            if (withLatency1) {
                this.socket.receive(this.rcv_packet);
                this.socket.send(this.send_packet);
            } else {
                this.socket.send(this.send_packet);
                this.socket.receive(this.rcv_packet);
            }
            if ((byte)(this.rcvbuf[1024] - this.last_frame) != 1) {
                Log.fatal(String.format("Frame#%5d: Packet LOSS: last = %02x, this = %02x", frame_cnt, this.last_frame, this.rcvbuf[1024]));
            }
            if (this.dumper != null && this.dumper_active) {
                this.dumper.datagramReceived(this.rcv_packet, null);
                this.dumper.datagramSent(this.send_packet);
            }
            ++frame_cnt;
            prev_latency = latency;
            server_ping = AsteroidApp.byteToUnsigned(this.rcvbuf[1025]);
            if (prev_latency != (latency = my_ping - server_ping + 256 & 0xFF)) {
                Log.warn(String.format("Frame#%5d: Latenz %d -> %d", frame_cnt, prev_latency, latency));
            }
            this.interpret();
            if ((keys_send[server_ping] & 0x10) != 0) {
                this.ship.rotate(true);
            }
            if ((keys_send[server_ping] & 8) != 0) {
                this.ship.rotate(false);
            }
            AsteroidApp.winkelbyte[AsteroidApp.server_ping] = Ship.winkelbyte;
            my_ping = my_ping + 1 & 0xFF;
            this.last_frame = this.rcvbuf[1024];
            return this.last_frame;
        }
        catch (Exception e) {
            System.err.println("Exception: " + e);
            e.printStackTrace();
            return 0;
        }
    }

    public void interpret() throws SQLException {
        String header;
        if (this.address.getHostName().equals("asteroids.heise.de") && ((header = new String(this.rcvbuf, 0, 4)).equals("game") || header.equals("busy"))) {
            System.err.println(new String(this.rcvbuf));
            System.exit(5);
        }
        int rb0 = this.rcvbuf[0] & 0xFF;
        int rb1 = this.rcvbuf[1] & 0xFF;
        if (224 != rb1 && 226 != rb1) {
            System.err.println("interpret: 0x0e|0x02-Fehler:");
            System.exit(5);
        }
        this.prev_cnt_ast = this.asteroids.size();
        this.asteroids.clear();
        Ship.shots.clear();
        UFO.shots.clear();
        Vector<Shot> tmpVec = this.prev_shots;
        this.prev_shots.clear();
        this.prev_shots = this.shots;
        this.shots = tmpVec;
        this.texts.clear();
        boolean ship_seen = false;
        boolean saucer_seen = false;
        int ships_seen = 0;
        int vx = 0;
        int vy = 0;
        int vs = 0;
        int v1x = 0;
        int v1y = 0;
        int shipdetect = 0;
        boolean finished = false;
        boolean gameover = false;
        int text_x = 0;
        int text_y = 0;
        boolean textPending = false;
        this.textbuf.setLength(0);
        int vram_cnt = 0;
        int pc = 2;
        while (!finished && !gameover && pc < this.rcvbuf.length) {
            int b0 = this.rcvbuf[pc] & 0xFF;
            int b1 = this.rcvbuf[pc + 1] & 0xFF;
            int op = b1 >> 4;
            int a1 = (b0 | b1 << 8) & 0xFFF;
            int a2 = 0;
            if (op <= 10) {
                b0 = this.rcvbuf[pc += 2] & 0xFF;
                b1 = this.rcvbuf[pc + 1] & 0xFF;
                a2 = b0 | b1 << 8;
            }
            if (op <= 9) {
                int dy = (a1 & 0x400) == 0 ? a1 & 0x3FF : -(a1 & 0x3FF);
                int dx = (a2 & 0x400) == 0 ? a2 & 0x3FF : -(a2 & 0x3FF);
                int vz = a2 >> 12;
                if (dx == 0 && dy == 0 && vz == 15) {
                    this.tmpPoint.x = vx;
                    this.tmpPoint.y = vy;
                    Shot shot = Shot.FindShot(this.prev_shots, this.tmpPoint);
                    if (shot == null) {
                        shot = new Shot(vx, vy);
                        if (this.ship.getSquaredTorusDistance(shot, 0) < 484.0) {
                            shot.winkelbyte = winkelbyte[server_ping + 254 & 0xFF];
                            shot.dx = Ship.shot_delta[shot.winkelbyte][0];
                            shot.dy = Ship.shot_delta[shot.winkelbyte][1];
                            this.ship.getShotPrediction(this.tmpPoint, 40, shot.winkelbyte);
                            shot.projected_frames = 40;
                            shot.projected_x = this.tmpPoint.x;
                            shot.projected_y = this.tmpPoint.y;
                            ++this.shots_fired;
                            ++this.level_shots;
                        } else {
                            shot.saucer = true;
                        }
                    }
                    this.shots.add(shot);
                    if (shot.saucer) {
                        UFO.shots.add(shot);
                    } else {
                        Ship.addShot(shot);
                    }
                } else if (op == 6 && vz == 12 && dx != 0 && dy != 0) {
                    if (shipdetect == 0) {
                        v1x = dx;
                        v1y = dy;
                    } else if (1 == shipdetect) {
                        this.ship.x2 = vx + (v1x - dx);
                        this.ship.y2 = vy + (v1y - dy);
                        if (!this.ship.visible) {
                            this.ship.setVisible(vx, vy);
                        } else {
                            this.ship.update(vx, vy);
                        }
                        ship_seen = true;
                    }
                    ++shipdetect;
                }
            } else {
                block0 : switch (op) {
                    case 10: {
                        vy = (a1 & 0x3FF) - 128;
                        vx = a2 & 0x3FF;
                        vs = a2 >> 12;
                        break;
                    }
                    case 11: {
                        finished = true;
                        break;
                    }
                    case 12: {
                        String s = Text.map[a1];
                        textPending = s != null;
                        if (textPending) {
                            if (this.textbuf.length() == 0) {
                                text_x = vx;
                                text_y = vy;
                            }
                            this.textbuf.append(s);
                            break;
                        }
                        switch (a1) {
                            case 2130: {
                                break block0;
                            }
                            case 2176: 
                            case 2198: 
                            case 2229: 
                            case 2256: {
                                if (this.ufo.x == vx && this.ufo.y == vy && 2229 == a1 && 11 == vs) {
                                    this.ufo.exploding = true;
                                    break block0;
                                }
                                if (this.ufo.exploding && this.ufo.x == vx && this.ufo.y == vy) break block0;
                                this.vram_objects_new[vram_cnt++].setExplosion(vx, vy, vs, a1);
                                break block0;
                            }
                            case 2291: 
                            case 2303: 
                            case 2317: 
                            case 2330: {
                                this.vram_objects_new[vram_cnt++].setAsteroid(vx, vy, vs, a1);
                                break block0;
                            }
                            case 2345: {
                                if (Debug.ufo) {
                                    Log.info(String.format("Frame#%5d: UFO 0x%03x at (%3d,%3d) [vs=%3d, vram_cnt=%2d]", frame_cnt, a1, vx, vy, vs, vram_cnt));
                                }
                                if (!this.ufo.visible) {
                                    this.ufo.setAppearance(vx, vy, vs, 2345);
                                    ++this.level_ufos;
                                } else {
                                    this.tmpPoint.x = vx;
                                    this.tmpPoint.y = vy;
                                    this.ufo.update(this.tmpPoint);
                                }
                                saucer_seen = true;
                                break block0;
                            }
                            case 2669: {
                                ++ships_seen;
                                break block0;
                            }
                        }
                        System.err.println("c a1 = " + Integer.toHexString(a1));
                        break;
                    }
                    case 13: {
                        finished = true;
                        break;
                    }
                    case 14: {
                        finished = true;
                        break;
                    }
                }
            }
            if (!textPending && this.textbuf.length() > 0) {
                String text = this.textbuf.toString();
                if (text_x == 100 && text_y == 748) {
                    int new_score = Integer.parseInt(text.replaceAll(" ", ""));
                    this.updateScores(new_score);
                } else if (text.startsWith("IHR ERGEBNIS") || text.startsWith("STARTKN0EPFE DRUECKEN")) {
                    this.startNewGame(false);
                    gameover = true;
                }
                if (withDisplay) {
                    this.texts.add(new Text(text, text_x, text_y));
                }
                this.textbuf.setLength(0);
            }
            textPending = false;
            pc += 2;
        }
        VectorObject.sync(this.asteroids, this.vram_objects, this.vram_objects_new, vram_cnt);
        this.curr_cnt_ast = this.asteroids.size();
        if (!ship_seen) {
            this.ship.visible = false;
        }
        if (!saucer_seen) {
            this.ufo.visible = false;
        }
        if (ships_seen > this.ships_remain) {
            this.ships_remain = ships_seen;
        }
        if (gameover) {
            this.send((byte)32);
        }
    }

    public void sendName() {
        if (!this.address.getHostName().equals("asteroids.heise.de")) {
            return;
        }
        String name = "ctname...THE DISMAL DREGS OF DEFEAT   ";
        try {
            DatagramPacket packet = new DatagramPacket(name.getBytes(), name.length(), this.address, 1979);
            this.socket.send(packet);
        }
        catch (Exception e) {
            System.err.println("Exception: " + e);
            e.printStackTrace();
        }
    }

    public void start() throws SQLException {
        this.startNewGame(true);
        this.send((byte)0);
        this.sendName();
        boolean fireDelay = false;
        int waitFrames = 0;
        byte keys = 0;
        boolean hyperspace = false;
        boolean hyperspaceWait = false;
        boolean log_invisible = false;
        boolean log_visible = true;
        int measure_shot_at = 0;
        int measure_shot_frames = 0;
        int measure_expected = 0;
        boolean measure_finished = false;
        int wbRange = 0;
        Target[] bestTarget = new Target[2];
        while (true) {
            keys = 0;
            if (frame_cnt == 17999 || Debug.stopAtLevel5 && 5 == this.level) {
                Log.info(String.format("Frame#%5d: Spielstand: %5d", frame_cnt, this.getRealScore()));
                this.sql.setScore5min(this.getRealScore());
                this.sql.setScore10min(0);
            }
            if (!this.ship.visible && log_invisible) {
                Log.info(String.format("Frame#%5d: Ship invisible [wb=%3d]", frame_cnt, Ship.winkelbyte));
                log_invisible = false;
                log_visible = true;
                hyperspaceWait = true;
            }
            if (this.ship.visible && log_visible) {
                Log.info(String.format("Frame#%5d: Ship visible   [wb=%3d]", frame_cnt, Ship.winkelbyte));
                log_visible = false;
                log_invisible = true;
                hyperspaceWait = false;
            }
            if (this.prev_cnt_ast == 0 && this.curr_cnt_ast > 0) {
                if (1 == ++this.level) {
                    this.score = 0;
                    this.scorewrap = 0;
                    frame_cnt = 1;
                    this.warp_cnt = 0;
                    this.dumper_active = true;
                }
                level_part = 0;
                this.level_startframe = frame_cnt;
                this.level_startscore = this.getRealScore();
                this.level_ufos = 0;
                this.level_shots = 0;
                this.level_key_fire = 0;
                Log.info(String.format("Frame#%5d: Start Level %2d [%2d Asteroiden, %5d Punkte] [wait=%3d]", frame_cnt, this.level, this.curr_cnt_ast, this.getRealScore(), this.level_waitframes));
            }
            if (this.prev_cnt_ast > 0 && this.curr_cnt_ast == 0) {
                int nFrames = frame_cnt - this.level_startframe;
                int lScore = this.getRealScore() - this.level_startscore;
                Log.info(String.format("Frame#%5d: Ende  Level %2d [%4d Frames] [%5d Punkte = %3d/100f, %d UFOs, %2d[%3d] Shots]", frame_cnt, this.level, nFrames, lScore, (int)(100.0 * (double)lScore / (double)nFrames), this.level_ufos, this.level_shots, this.level_key_fire));
                this.level_waitframes = 165;
            }
            if (this.level_waitframes > 0) {
                boolean preshot_position_reached;
                --this.level_waitframes;
                this.ship.getShotPrediction(this.tmpPoint, Shot.getLifeSpan(), AsteroidApp.getWinkelbyte());
                MovingObject.normalize(this.tmpPoint);
                int xDistLsq = MovingObject.NormalDistSq(this.tmpPoint, 10, this.tmpPoint.y) / 8;
                int xDistRsq = MovingObject.NormalDistSq(this.tmpPoint, 1013, this.tmpPoint.y) / 8;
                int yDistBsq = MovingObject.NormalDistSq(this.tmpPoint, this.tmpPoint.x, 10) / 8;
                int yDistTsq = MovingObject.NormalDistSq(this.tmpPoint, this.tmpPoint.x, 757) / 8;
                boolean bl = preshot_position_reached = this.level_waitframes >= 65 && (xDistLsq < 900 || xDistRsq < 900 || yDistBsq < 900 || yDistTsq < 900);
                if (100 == this.level_waitframes) {
                    measure_shot_at = frame_cnt;
                    measure_shot_frames = 0;
                    measure_finished = false;
                    measure_expected = Shot.getLifeSpan();
                    if (Debug.shot_measure) {
                        Log.debug(String.format("Frame#%5d: Measure shot [frame mod 4 = %d], lifespan expected = %2d", frame_cnt, frame_cnt % 4, Shot.getLifeSpan()));
                    }
                    keys = (byte)(keys | 2);
                } else if (!this.ufo.visible && preshot_position_reached) {
                    int remaining_shot_lifespan = 2 + Shot.getLifeSpan() - this.level_waitframes;
                    if (remaining_shot_lifespan >= 3 && remaining_shot_lifespan <= 7) {
                        if (!fireDelay) {
                            if (Debug.preShots) {
                                Log.debug(String.format("Frame#%5d: PRESHOT [%2d:%d] X(%5d|%5d) Y(%5d|%5d)", frame_cnt, this.level_waitframes, remaining_shot_lifespan, xDistLsq, xDistRsq, yDistBsq, yDistTsq));
                            }
                            keys = (byte)(keys | 2);
                        }
                        keys = (byte)(keys | 8);
                    }
                } else if (!this.ufo.visible) {
                    Point[] edges = new Point[]{new Point(0, this.ship.y), new Point(1023, this.ship.y), new Point(this.ship.x, 0), new Point(this.ship.x, 767)};
                    double dist = 1000.0;
                    Point edge = null;
                    int i = 0;
                    while (i < edges.length) {
                        int dx = this.ship.x - edges[i].x;
                        int dy = this.ship.y - edges[i].y;
                        double edge_dist = Math.sqrt(dx * dx + dy * dy);
                        if (edge == null || edge_dist < dist) {
                            edge = edges[i];
                            dist = edge_dist;
                        }
                        ++i;
                    }
                    double alpha = Math.toDegrees(Math.atan2(edge.x - this.ship.x, edge.y - this.ship.y));
                    double ship_alpha = Ship.shot_alpha[Ship.winkelbyte];
                    if (this.level_waitframes > 80 || Math.abs(alpha - ship_alpha) > 6.0) {
                        keys = (byte)(keys | 8);
                    }
                }
                if (this.level_waitframes > 20 && this.level_waitframes < 40 && this.prev_shots.size() == 1 && !measure_finished) {
                    measure_finished = true;
                    measure_shot_frames = this.prev_shots.firstElement().frames;
                    if (measure_shot_frames >= 69 && measure_shot_frames <= 72) {
                        Shot.setLifeSpanOffset(measure_shot_at % 4, measure_shot_frames);
                        if (measure_expected != measure_shot_frames) {
                            Log.debug(String.format("Frame#%5d: [Level %2d] expected shot frames #%2d != measured frames #%2d", frame_cnt, this.level, measure_expected, measure_shot_frames));
                        }
                    }
                    if (Debug.shot_measure) {
                        Log.debug(String.format("Frame#%5d: Measure shot at %5d [frame mod 4 = %d], frames=%2d", frame_cnt, measure_shot_at, measure_shot_at % 4, measure_shot_frames));
                    }
                }
            }
            if (this.ship.visible) {
                block7: for (Shot shot : UFO.shots) {
                    if (shot.frames < 4) continue;
                    int f = 4 + norm_latency;
                    while (f >= 1) {
                        if (this.ship.shotWillHit(shot, f)) {
                            Log.warn(String.format("Frame#%5d: hyperspace [UFO hit in %2d Frames]", frame_cnt, f));
                            shot.killing = true;
                            hyperspace = true;
                            continue block7;
                        }
                        --f;
                    }
                }
            }
            this.targets.clear();
            if (this.ufo.visible) {
                this.targets.add(this.ufo);
            }
            int cnt_ast_large = 0;
            int cnt_ast_medium = 0;
            int cnt_ast_small = 0;
            for (Asteroid a : this.asteroids) {
                switch (a.sizeType) {
                    case 3: {
                        ++cnt_ast_large;
                        break;
                    }
                    case 2: {
                        ++cnt_ast_medium;
                        break;
                    }
                    case 1: {
                        ++cnt_ast_small;
                    }
                }
                this.targets.add(a);
            }
            wbRange = Config.RotateRange[level_part];
            if (level_part == 0 && cnt_ast_large <= 2 && this.asteroids.size() >= 15) {
                if (Debug.level) {
                    Log.info(String.format("Frame#%5d: [%3d] \u00dcbergang zu Mittelspiel", frame_cnt, frame_cnt - this.level_startframe));
                }
                wbRange = Config.RotateRange[++level_part];
            } else if (1 == level_part && cnt_ast_medium <= 2 && this.asteroids.size() <= 10) {
                if (Debug.level) {
                    Log.info(String.format("Frame#%5d: [%3d] \u00dcbergang zu Endspiel", frame_cnt, frame_cnt - this.level_startframe));
                }
                wbRange = Config.RotateRange[++level_part];
            }
            this.ship.checkShotHits(this.targets, frame_cnt - this.level_startframe);
            this.tCollision = this.ship.findCollisionTarget(this.targets, Config.MinCollisionFrame[level_part]);
            if (this.ship.visible) {
                for (Target target : this.targets) {
                    if (!target.collision || target.collisionFrame > 4 + norm_latency) continue;
                    Log.warn(String.format("Frame#%5d: Asteroid hit in %2d Frames, dist=%5f", frame_cnt, target.collisionFrame, target.distance));
                    hyperspace = true;
                }
            }
            this.targets.clear();
            for (Asteroid a : this.asteroids) {
                if (Config.Asteroid26Lock && this.asteroids.size() == 26 && a.framewait == 0 && a != this.tCollision && a.sizeType != 1 || Config.AsteroidDistLock && a.distance > 150.0 && a.frames < 4 && a.framewait == 0 || a.framewait != 0) continue;
                this.targets.add(a);
            }
            if (frame_cnt > 17750 && frame_cnt < 17920 && this.targets.size() == 1) {
                Target aLast = this.targets.get(0);
                if (!aLast.collision) {
                    this.targets.remove(aLast);
                    aLast.framewait = 1;
                }
            }
            if (this.ufo.visible && this.ufo.framewait == 0) {
                this.targets.add(this.ufo);
            }
            Target target = null;
            if (this.tCollision != null) {
                this.tmpTargets.clear();
                this.tmpTargets.add(this.tCollision);
                target = this.ship.markTargetReachability(bestTarget, this.tmpTargets, 45);
                if (Debug.collisions && target != null) {
                    Log.debug(String.format("Frame#%5d: tCollision %2d Frames, L/R=%2d/%2d", frame_cnt, target.collisionFrame, target.leftMinHitInFramesKeys, target.rightMinHitInFramesKeys));
                }
            }
            if (Config.MediumPreferAtEnd && 2 == level_part && target == null && cnt_ast_medium > 0) {
                this.tmpTargets.clear();
                for (Asteroid a : this.asteroids) {
                    if (a.framewait != 0 || a.sizeType != 2) continue;
                    this.tmpTargets.add(a);
                }
                target = this.ship.markTargetReachability(bestTarget, this.tmpTargets, wbRange);
            }
            if (target == null && this.targets.contains(this.ufo)) {
                if (Config.LastAsteroidBeforeUFO && this.ufo.small && this.targets.size() == 2) {
                    this.targets.remove(this.ufo);
                    target = this.ship.markTargetReachability(bestTarget, this.targets, wbRange);
                    this.targets.add(this.ufo);
                } else if (Config.SmallUFOfirst && this.ufo.small) {
                    this.tmpTargets.clear();
                    this.tmpTargets.add(this.ufo);
                    target = this.ship.markTargetReachability(bestTarget, this.tmpTargets, wbRange);
                } else if (Config.LargeUFOLast && !this.ufo.small) {
                    this.targets.remove(this.ufo);
                    target = this.ship.markTargetReachability(bestTarget, this.targets, wbRange);
                    this.targets.add(this.ufo);
                }
            }
            if (target == null) {
                target = this.ship.markTargetReachability(bestTarget, this.targets, wbRange);
            }
            if (fireDelay) {
                bestTarget[1] = null;
            }
            if (target != null && this.ship.visible) {
                keys = (byte)(keys | this.ship.moveToTarget(target, bestTarget[1]));
            }
            if (!fireDelay && (Ship.shots.size() < 4 || this.ship.shotAvailable(2))) {
                Target dst = null;
                if (target != null && target.leftMinHitInFramesKeys == 0) {
                    dst = target;
                } else {
                    int f = 0;
                    while (f <= Config.WaitFrames[level_part]) {
                        dst = this.ship.findTarget(this.targets, f);
                        if (dst != null) {
                            waitFrames = f;
                            if (waitFrames <= 0) break;
                            if (dst != target) {
                                Log.debug(String.format("Frame#%5d: %d-wait Target, hitframes=%2d", frame_cnt, f, Math.min(dst.leftMinHitInFrames, dst.rightMinHitInFrames)));
                            }
                            dst = null;
                            break;
                        }
                        ++f;
                    }
                }
                if (dst != null) {
                    boolean shoot;
                    if (target == null) {
                        target = dst;
                    }
                    int shot_needed = Math.min(target.leftMinHitInFramesKeys, target.rightMinHitInFramesKeys);
                    boolean bl = shoot = dst == target || dst instanceof UFO || Ship.shots.size() <= 2 || dst.leftMinHitInFrames < shot_needed || this.ship.shotAvailable(2 + shot_needed);
                    if (dst != target && !(dst instanceof UFO) && 1 == shot_needed && Debug.shot_needed) {
                        Log.info(String.format("Frame#%5d: shot_needed = 1, dst[%2d] != target[%2d]", frame_cnt, Math.min(dst.leftMinHitInFrames, dst.rightMinHitInFrames), Math.min(target.leftMinHitInFrames, target.rightMinHitInFrames)));
                    }
                    if (shoot) {
                        if (dst.shots_fired_at >= this.ship.getMaxShots(dst, 0) - 1) {
                            dst.framewait = 2 + norm_latency;
                        }
                        keys = (byte)(keys | 2);
                    }
                }
            } else if (Debug.shot_lock && !fireDelay && target != null && target.leftMinHitInFramesKeys == 0) {
                Log.debug(String.format("Frame#%5d: Schusssperre, Wartezeit = %2d", frame_cnt, this.ship.nextShotAvailable()));
            }
            int levelframe = frame_cnt - this.level_startframe;
            if (1 == this.level && levelframe < 5) {
                keys = 16;
            } else if (levelframe < 2) {
                keys = (byte)(keys & 0xFFFFFFFD);
            } else if (levelframe < 4 && (this.aNearest = this.ship.findNearestAsteroid(this.asteroids)) != null && this.aNearest.distance > 100.0) {
                keys = (byte)(keys & 0xFFFFFFFD);
            }
            if (hyperspace) {
                hyperspace = false;
                keys = (byte)(keys | 1);
                log_invisible = true;
                ++this.warp_cnt;
                Log.info(String.format("Frame#%5d: hyperspace [wb=%3d]", frame_cnt, Ship.winkelbyte));
            }
            if ((keys & 1) != 0 || waitFrames > 0) {
                keys = (byte)(keys & 0xFFFFFFEF);
                keys = (byte)(keys & 0xFFFFFFF7);
                if (waitFrames > 0) {
                    --waitFrames;
                }
            }
            if (hyperspaceWait) {
                keys = 0;
            }
            if ((keys & 2) != 0) {
                fireDelay = true;
                ++this.level_key_fire;
            } else {
                fireDelay = false;
            }
            this.send(keys);
            if (!withDisplay || frame_cnt % FRAME_INTERVAL != 0) continue;
            this.frame.repaint();
        }
    }

    public static void main(String[] arg) {
        Config.readConfig();
        int i = 0;
        while (i < arg.length) {
            if (arg[i].equals("-mysql")) {
                withMySQL = true;
            } else if (arg[i].equals("-log4j")) {
                withLog4j = true;
            } else if (arg[i].equals("-display")) {
                withDisplay = true;
            } else if (arg[i].equals("-dumper")) {
                withDumper = true;
            } else if (arg[i].equals("-latency1")) {
                withLatency1 = true;
                norm_latency = 1;
            } else if (arg[i].equals("-normlatency")) {
                norm_latency = Integer.valueOf(arg[++i]);
            } else if (!arg[i].startsWith("-")) {
                AsteroidApp client = new AsteroidApp(arg[i]);
                try {
                    client.start();
                }
                catch (SQLException e) {
                    System.err.println("SQL Exception: " + e);
                }
                System.exit(0);
            }
            ++i;
        }
    }
}

