/*
 * Decompiled with CFR 0.152.
 */
package de.wens02;

import de.wens02.AsteroidApp;
import de.wens02.Debug;
import de.wens02.Log;
import de.wens02.Target;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;

public class Asteroid
extends Target {
    public static final int SIZE_SMALL = 1;
    public static final int SIZE_MEDIUM = 2;
    public static final int SIZE_LARGE = 3;
    private static final int NORMAL_SCALE = 8;
    private static final GeneralPath PATH0 = new GeneralPath();
    private static final GeneralPath PATH1 = new GeneralPath();
    private static final GeneralPath PATH2 = new GeneralPath();
    private static final GeneralPath PATH3 = new GeneralPath();
    private static final Shape[] SHAPES;
    private Shape shape;
    private int scale;
    protected int sizeType = 0;
    protected static double max_speed;

    static {
        PATH0.moveTo(1.0f, 0.0f);
        PATH0.lineTo(4.0f, -1.0f);
        PATH0.lineTo(4.0f, -2.0f);
        PATH0.lineTo(1.0f, -4.0f);
        PATH0.lineTo(-2.0f, -4.0f);
        PATH0.lineTo(-1.0f, -3.0f);
        PATH0.lineTo(-4.0f, -3.0f);
        PATH0.lineTo(-4.0f, 1.0f);
        PATH0.lineTo(-2.0f, 4.0f);
        PATH0.lineTo(1.0f, 3.0f);
        PATH0.lineTo(2.0f, 4.0f);
        PATH0.lineTo(4.0f, 2.0f);
        PATH0.closePath();
        PATH1.moveTo(3.0f, 0.0f);
        PATH1.lineTo(4.0f, -2.0f);
        PATH1.lineTo(2.0f, -4.0f);
        PATH1.lineTo(0.0f, -2.0f);
        PATH1.lineTo(-2.0f, -4.0f);
        PATH1.lineTo(-4.0f, -2.0f);
        PATH1.lineTo(-4.0f, 2.0f);
        PATH1.lineTo(-2.0f, 4.0f);
        PATH1.lineTo(1.0f, 4.0f);
        PATH1.lineTo(4.0f, 2.0f);
        PATH1.closePath();
        PATH2.moveTo(4.0f, -1.0f);
        PATH2.lineTo(2.0f, -4.0f);
        PATH2.lineTo(-1.0f, -4.0f);
        PATH2.lineTo(-4.0f, -1.0f);
        PATH2.lineTo(-2.0f, 0.0f);
        PATH2.lineTo(-4.0f, 1.0f);
        PATH2.lineTo(-2.0f, 4.0f);
        PATH2.lineTo(0.0f, 1.0f);
        PATH2.lineTo(0.0f, 4.0f);
        PATH2.lineTo(2.0f, 4.0f);
        PATH2.lineTo(4.0f, 1.0f);
        PATH2.closePath();
        PATH3.moveTo(2.0f, -1.0f);
        PATH3.lineTo(4.0f, -2.0f);
        PATH3.lineTo(2.0f, -4.0f);
        PATH3.lineTo(0.0f, -3.0f);
        PATH3.lineTo(-2.0f, -4.0f);
        PATH3.lineTo(-4.0f, -2.0f);
        PATH3.lineTo(-3.0f, 0.0f);
        PATH3.lineTo(-4.0f, 2.0f);
        PATH3.lineTo(-2.0f, 4.0f);
        PATH3.lineTo(-1.0f, 3.0f);
        PATH3.lineTo(2.0f, 4.0f);
        PATH3.lineTo(4.0f, 1.0f);
        PATH3.closePath();
        SHAPES = new Shape[]{PATH1, PATH3, PATH2, PATH0};
        max_speed = 0.0;
    }

    public Asteroid(int x, int y, int s, int type) {
        super(x, y, s, type);
        switch (s) {
            case 0: {
                this.scale = 8;
                this.sizeType = 3;
                break;
            }
            case 15: {
                this.scale = 4;
                this.sizeType = 2;
                break;
            }
            case 14: {
                this.scale = 2;
                this.sizeType = 1;
                break;
            }
            default: {
                System.err.println("Asteroid: unknown size: " + s);
            }
        }
        switch (type) {
            case 2291: {
                this.shape = SHAPES[0];
                break;
            }
            case 2303: {
                this.shape = SHAPES[1];
                break;
            }
            case 2317: {
                this.shape = SHAPES[2];
                break;
            }
            case 2330: {
                this.shape = SHAPES[3];
                break;
            }
            default: {
                System.err.println("Asteroid: unknown shape: " + type);
            }
        }
        this.pixelSize = 8 * this.scale;
        this.squaredPixelSize = this.pixelSize * this.pixelSize;
    }

    public void paint(Graphics2D g) {
        AffineTransform aTr = new AffineTransform(this.scale, 0.0f, 0.0f, this.scale, this.x, 1024 - this.y);
        Shape s = aTr.createTransformedShape(this.shape);
        g.fill(s);
        if (this.collision) {
            g.setColor(Color.red);
            g.draw(s);
        }
        g.setColor(Color.gray);
        g.drawString("#" + this.id, this.x, 1024 - this.y + 10);
        g.drawString("+" + (int)this.distance, this.x, 1024 - this.y + 20);
        g.drawString("L" + this.leftMinHitInFramesKeys, this.x, 1024 - this.y + 40);
        g.drawString("R" + this.rightMinHitInFramesKeys, this.x, 1024 - this.y + 50);
        if (this.dx != 0.0 || this.dy != 0.0) {
            int xn = (int)((double)this.x + 30.0 * this.dx);
            int yn = (int)((double)this.y + 30.0 * this.dy);
            g.setColor(Color.lightGray);
            g.drawLine(this.x, 1024 - this.y, xn, 1024 - yn);
        }
        if (this.projected_frames > 0) {
            aTr = new AffineTransform(this.scale, 0.0f, 0.0f, this.scale, this.projected_x, 1024 - this.projected_y);
            s = aTr.createTransformedShape(this.shape);
            g.draw(s);
        }
    }

    @Override
    public boolean shotWillHit(Point p, int frameHorizon) {
        if (1 == this.sizeType) {
            return this.getSquaredNormalDistance(p, frameHorizon) < this.squaredPixelSize / 4;
        }
        switch (this.shots_fired_at) {
            default: {
                return this.getSquaredNormalDistance(p, frameHorizon) < this.squaredPixelSize / 4;
            }
            case 1: {
                return this.getSquaredNormalDistance(p, frameHorizon + 1) < this.squaredPixelSize / 10;
            }
            case 2: {
                return this.getSquaredNormalDistance(p, frameHorizon + 1) < this.squaredPixelSize / 10;
            }
            case 3: 
        }
        return this.getSquaredNormalDistance(p, frameHorizon + 2) < this.squaredPixelSize / 10;
    }

    @Override
    public int maxShots() {
        if (1 == this.sizeType) {
            return 1;
        }
        if (2 == this.sizeType) {
            return 3;
        }
        return 4;
    }

    @Override
    public int getPoints() {
        if (3 == this.sizeType) {
            return 525;
        }
        if (2 == this.sizeType) {
            return 250;
        }
        return 100;
    }

    public int getPixelSize() {
        return this.pixelSize;
    }

    public int getSquaredPixelSize() {
        return this.squaredPixelSize;
    }

    @Override
    public void update(Point p) {
        super.update(p);
        if (Debug.asteroid_speed) {
            double speed = Math.sqrt(this.dx * this.dx + this.dy * this.dy);
            if (this.frames > 5 && speed > max_speed) {
                max_speed = speed;
                Log.debug(String.format("Frame#%5d: Asteroid ID%2d speed=%5f pixel/frame", AsteroidApp.frame_cnt, this.id, max_speed));
            }
        }
    }
}

