/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings.swing;

import de.caff.util.settings.swing.AbstractBasicEditorProvider;
import de.caff.util.settings.swing.SwingStringPreferenceProperty;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JTextField;

class StringEditor
extends AbstractBasicEditorProvider
implements PropertyChangeListener {
    private final SwingStringPreferenceProperty property;
    private final JTextField textField;

    public StringEditor(SwingStringPreferenceProperty property, Locale l) {
        super(property, l);
        this.property = property;
        this.textField = new JTextField(property.getValue(), 40);
        property.addValueChangeListener(this);
    }

    @Override
    public JComponent getEditor() {
        return this.textField;
    }

    @Override
    public void reset() {
        this.textField.setText(this.property.getValue());
    }

    @Override
    public void save() {
        this.property.setValue(this.textField.getText());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!this.textField.getText().equals(evt.getNewValue().toString())) {
            this.textField.setText(evt.getNewValue().toString());
        }
    }

    @Override
    public void goodBye() {
        this.property.removeValueChangeListener(this);
    }
}

