/*
 * Decompiled with CFR 0.152.
 */
package de.caff.i18n.swing;

import de.caff.i18n.I18n;
import de.caff.i18n.Localizable;
import java.awt.IllegalComponentStateException;
import java.util.Locale;
import javax.swing.JRadioButton;

public class RJRadioButton
extends JRadioButton
implements Localizable {
    protected String resTag;

    public RJRadioButton(boolean on) {
        super("", on);
    }

    public RJRadioButton(String tag, boolean on) {
        super("", on);
        this.setTag(tag);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        I18n.addLocalizationChangeListener(this);
    }

    @Override
    public void removeNotify() {
        I18n.removeLocalizationChangeListener(this);
        super.removeNotify();
    }

    public void setTag(String tag) {
        this.resTag = tag;
        this.setText(I18n.getString(this.resTag, this.getLocale()));
    }

    @Override
    public void setLocale(Locale l) {
        Locale oldLocale = this.getLocale();
        super.setLocale(l);
        if (oldLocale != null && !oldLocale.equals(l) && this.resTag != null) {
            this.setText(I18n.getString(this.resTag, l));
        }
    }

    @Override
    public Locale getLocale() {
        try {
            return super.getLocale();
        }
        catch (IllegalComponentStateException x) {
            return null;
        }
    }
}

