/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid;

import de.caff.asteroid.Glyph;
import de.caff.asteroid.MovingGameObject;
import de.caff.asteroid.Property;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.Collection;

public class SpaceShip
extends MovingGameObject {
    private static final Color COLOR = new Color(128, 128, 128);
    public static final Glyph SHIP_GLYPH;
    public static final Glyph THRUSTING_SHIP_GLYPH;
    public static final double SHIP_SCALING = 0.25;
    private static final Shape SHIP_SHAPE;
    private static final Shape THRUSTING_SHIP_SHAPE;
    private final int dx;
    private final int dy;
    private boolean thrusting;

    static {
        byte[] byArray = new byte[21];
        byArray[0] = 16;
        byArray[1] = 24;
        byArray[3] = -16;
        byArray[4] = 24;
        byArray[5] = 7;
        byArray[6] = -32;
        byArray[7] = 40;
        byArray[8] = 7;
        byArray[10] = -56;
        byArray[11] = 7;
        byArray[12] = 32;
        byArray[13] = 40;
        byArray[14] = 7;
        byArray[15] = 16;
        byArray[16] = 24;
        byArray[17] = 7;
        byArray[18] = -64;
        SHIP_GLYPH = new Glyph(byArray);
        byte[] byArray2 = new byte[24];
        byArray2[0] = 16;
        byArray2[1] = 24;
        byArray2[4] = 56;
        byArray2[5] = 7;
        byArray2[6] = -16;
        byArray2[7] = 24;
        byArray2[8] = 7;
        byArray2[9] = -32;
        byArray2[10] = 40;
        byArray2[11] = 7;
        byArray2[13] = -56;
        byArray2[14] = 7;
        byArray2[15] = 32;
        byArray2[16] = 40;
        byArray2[17] = 7;
        byArray2[18] = 16;
        byArray2[19] = 24;
        byArray2[20] = 7;
        byArray2[21] = -64;
        THRUSTING_SHIP_GLYPH = new Glyph(byArray2);
        AffineTransform at = AffineTransform.getRotateInstance(-1.5707963267948966);
        at.concatenate(AffineTransform.getScaleInstance(0.25, 0.25));
        SHIP_SHAPE = at.createTransformedShape(SHIP_GLYPH.getPath());
        THRUSTING_SHIP_SHAPE = at.createTransformedShape(THRUSTING_SHIP_GLYPH.getPath());
    }

    public SpaceShip(int x, int y, int dx, int dy) {
        super(x, y);
        this.dx = dx;
        this.dy = dy;
    }

    @Override
    public int getSize() {
        return 13;
    }

    public int getDirX() {
        return this.dx;
    }

    public int getDirY() {
        return this.dy;
    }

    public double getDirectionAngle() {
        return Math.atan2(this.dy, this.dx);
    }

    public Point getDirection() {
        return new Point(this.dx, this.dy);
    }

    @Override
    public void draw(Graphics2D g) {
        g.setColor(COLOR);
        g.draw(SpaceShip.getShipShape(this.x, this.y, this.getDirectionAngle(), this.thrusting));
        this.drawVelocityVector(g, Color.green);
    }

    public static Shape getShipShape(int px, int py, double angle, boolean thrusting) {
        AffineTransform at = AffineTransform.getTranslateInstance(px, py);
        at.concatenate(AffineTransform.getRotateInstance(angle));
        return at.createTransformedShape(thrusting ? THRUSTING_SHIP_SHAPE : SHIP_SHAPE);
    }

    public String toString() {
        return String.format("SpaceShip@(%d,%d)>(%-3.1f\u00b0)", this.x, this.y, 180.0 * this.getDirectionAngle() / Math.PI);
    }

    @Override
    public Collection<Property> getProperties() {
        Collection<Property> props = super.getProperties();
        props.add(new Property<Point>("Direction", this.getDirection()));
        props.add(new Property<Double>("Direction Angle (\u00b0)", 180.0 * this.getDirectionAngle() / Math.PI));
        props.add(new Property<Boolean>("Thrusting", this.isThrusting()));
        return props;
    }

    public boolean isThrusting() {
        return this.thrusting;
    }

    public void setThrusting(boolean thrusting) {
        this.thrusting = thrusting;
    }

    @Override
    public String getObjectType() {
        return "Space Ship";
    }
}

