/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;

public class Glyph {
    private static final AffineTransform IDENTITY = new AffineTransform();
    private Point offset;
    private GeneralPath path;
    private Rectangle bounds;

    public Glyph(byte[] data) {
        boolean moveToPending = true;
        this.path = new GeneralPath();
        this.offset = new Point();
        int i = 0;
        while (i < data.length) {
            byte x = -data[i];
            byte y = -data[i + 1];
            byte brightness = data[i + 2];
            if (brightness == 0) {
                moveToPending = true;
                this.offset = new Point(x, y);
            } else {
                if (moveToPending) {
                    this.path.moveTo(this.offset.x, this.offset.y);
                    moveToPending = false;
                }
                this.path.lineTo(x, y);
            }
            i += 3;
        }
    }

    public Glyph(byte[] data, Rectangle bounds) {
        this(data);
        this.bounds = bounds;
    }

    public void drawAndTranslate(Graphics2D g, double scaling) {
        if (scaling != 1.0) {
            g.draw(AffineTransform.getScaleInstance(scaling, scaling).createTransformedShape(this.path));
            g.translate(scaling * (double)this.offset.x, scaling * (double)this.offset.y);
        } else {
            g.draw(this.path);
            g.translate(this.offset.x, this.offset.y);
        }
    }

    public Point getOffset() {
        return this.offset;
    }

    public Rectangle getBounds() {
        return this.getBounds(IDENTITY);
    }

    public Rectangle getBounds(AffineTransform trafo) {
        if (this.bounds != null) {
            return trafo.createTransformedShape(this.bounds).getBounds();
        }
        return trafo.createTransformedShape(this.getPath()).getBounds();
    }

    public Rectangle getBounds(double scale) {
        return this.getBounds(AffineTransform.getScaleInstance(scale, scale));
    }

    public Shape getPath() {
        return this.path;
    }

    public Shape getPath(double scale) {
        return AffineTransform.getScaleInstance(scale, scale).createTransformedShape(this.path);
    }
}

